/*
 * Decompiled with CFR 0.152.
 */
package com.teamdev.jxbrowser.mozilla;

import com.teamdev.jxbrowser.Browser;
import com.teamdev.jxbrowser.events.HistoryChangeEvent;
import com.teamdev.jxbrowser.events.HistoryChangeListener;
import com.teamdev.jxbrowser.events.HistoryChangeType;
import com.teamdev.jxbrowser.gecko.xpcom.ProxyObjectManager;
import com.teamdev.jxbrowser.mozilla.MozillaBrowser;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.mozilla.interfaces.nsIHistoryEntry;
import org.mozilla.interfaces.nsISHistory;
import org.mozilla.interfaces.nsISHistoryListener;
import org.mozilla.interfaces.nsISupports;
import org.mozilla.interfaces.nsIURI;
import org.mozilla.interfaces.nsIWebBrowser;
import org.mozilla.interfaces.nsIWebNavigation;
import org.mozilla.xpcom.Mozilla;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class MozillaHistory {
    private final Browser a;
    private final nsIWebNavigation b;
    private final nsISHistory c;
    private HistoryListener d;

    MozillaHistory(MozillaBrowser mozillaBrowser) {
        this.a = mozillaBrowser;
        mozillaBrowser = mozillaBrowser.getPeer().getNsIWebBrowser();
        mozillaBrowser.addWebBrowserListener((nsISupports)new BridgedHistoryListener(this), "{3b07f591-e8e1-11d4-9882-00c04fa02f40}");
        mozillaBrowser = (nsIWebBrowser)ProxyObjectManager.getInstance().proxyForObject((nsISupports)mozillaBrowser, nsIWebBrowser.class, true);
        mozillaBrowser = (nsIWebNavigation)mozillaBrowser.queryInterface("{f5d9e7b0-d930-11d3-b057-00a024ffc08c}");
        this.b = (nsIWebNavigation)ProxyObjectManager.getInstance().proxyForObject((nsISupports)mozillaBrowser, nsIWebNavigation.class, true);
        mozillaBrowser = this.b.getSessionHistory();
        this.c = (nsISHistory)ProxyObjectManager.getInstance().proxyForObject((nsISupports)mozillaBrowser, nsISHistory.class, true);
        this.d = new HistoryListener(this, this.c);
        this.c.addSHistoryListener((nsISHistoryListener)this.d);
    }

    public List<String> getAllHistory() {
        return this.d.getHistoryList();
    }

    public int getCurrentIndex() {
        return this.d.getCurrentIndex();
    }

    public String getCurrentLocation() {
        MozillaHistory mozillaHistory = mozillaHistory.c.getEntryAtIndex(mozillaHistory.c.getIndex(), false);
        mozillaHistory = (nsIHistoryEntry)ProxyObjectManager.getInstance().proxyForObject((nsISupports)mozillaHistory, nsIHistoryEntry.class, true);
        return mozillaHistory.getURI().getSpec();
    }

    final void a() {
        if (this.b.getCanGoBack()) {
            this.b.gotoIndex(this.d.getBackIndex());
        }
    }

    final void b() {
        if (this.b.getCanGoForward()) {
            this.b.gotoIndex(this.d.getForwardIndex());
        }
    }

    public boolean canGoBack() {
        return this.b.getCanGoBack();
    }

    public boolean canGoForward() {
        return this.b.getCanGoForward();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class HistoryListener
    implements nsISHistoryListener {
        private Map<Integer, Integer> a = new HashMap<Integer, Integer>();
        private LinkedList<String> b = new LinkedList();
        private nsISHistory c;
        private int d = 0;
        private int e = 0;

        public HistoryListener(MozillaHistory mozillaHistory, nsISHistory nsISHistory2) {
            this.c = nsISHistory2;
        }

        public int getCurrentIndex() {
            return this.a.get(this.c.getIndex());
        }

        public List<String> getHistoryList() {
            return this.b;
        }

        public int getBackIndex() {
            int n2 = this.c.getIndex();
            if (this.a.get(n2).equals(this.a.get(n2 - 1))) {
                return this.a.get(n2 - 2);
            }
            return this.a.get(n2 - 1);
        }

        public int getForwardIndex() {
            int n2 = this.c.getIndex();
            return this.a.get(n2 + 1);
        }

        public void onHistoryNewEntry(nsIURI object) {
            object = object.getSpec();
            if (!this.a.isEmpty()) {
                Object object2 = this.c.getEntryAtIndex(this.c.getCount() - 1, false);
                object2 = (nsIHistoryEntry)ProxyObjectManager.getInstance().proxyForObject((nsISupports)object2, nsIHistoryEntry.class, true);
                if (!((String)object).equals(object2 = object2.getURI().getSpec())) {
                    ++this.e;
                    this.b.add((String)object);
                }
            } else {
                this.b.add((String)object);
            }
            this.a.put(this.d++, this.e);
        }

        public boolean onHistoryGoBack(nsIURI nsIURI2) {
            return true;
        }

        public boolean onHistoryGoForward(nsIURI nsIURI2) {
            return true;
        }

        public boolean onHistoryReload(nsIURI nsIURI2, long l2) {
            return true;
        }

        public boolean onHistoryGotoIndex(int n2, nsIURI nsIURI2) {
            return true;
        }

        public boolean onHistoryPurge(int n2) {
            return true;
        }

        public nsISupports queryInterface(String string) {
            return Mozilla.queryInterface((nsISupports)this, (String)string);
        }
    }

    private class BridgedHistoryListener
    implements nsISHistoryListener {
        private /* synthetic */ MozillaHistory a;

        private BridgedHistoryListener(MozillaHistory mozillaHistory) {
            this.a = mozillaHistory;
        }

        public boolean onHistoryGoBack(nsIURI nsIURI2) {
            this.a(new HistoryChangeEvent(this.a.a, this.a.c.getIndex(), nsIURI2.getSpec(), HistoryChangeType.Backward));
            return true;
        }

        public boolean onHistoryGoForward(nsIURI nsIURI2) {
            this.a(new HistoryChangeEvent(this.a.a, this.a.c.getIndex(), nsIURI2.getSpec(), HistoryChangeType.Forward));
            return true;
        }

        public boolean onHistoryGotoIndex(int n2, nsIURI nsIURI2) {
            this.a(new HistoryChangeEvent(this.a.a, n2, nsIURI2.getSpec(), HistoryChangeType.GotoIndex));
            return true;
        }

        public void onHistoryNewEntry(nsIURI nsIURI2) {
            this.a(new HistoryChangeEvent(this.a.a, this.a.c.getIndex(), nsIURI2.getSpec(), HistoryChangeType.NewEntry));
        }

        public boolean onHistoryPurge(int n2) {
            return true;
        }

        public boolean onHistoryReload(nsIURI nsIURI2, long l2) {
            return true;
        }

        public nsISupports queryInterface(String string) {
            return Mozilla.queryInterface((nsISupports)this, (String)string);
        }

        private void a(HistoryChangeEvent historyChangeEvent) {
            Iterator iterator = new LinkedList<HistoryChangeListener>(((BridgedHistoryListener)((Object)iterator)).a.a.getHistoryChangeListeners());
            iterator = iterator.iterator();
            while (iterator.hasNext()) {
                HistoryChangeListener historyChangeListener = (HistoryChangeListener)iterator.next();
                historyChangeListener.historyChanged(historyChangeEvent);
            }
        }
    }
}

