/*
 * Decompiled with CFR 0.152.
 */
package com.teamdev.jxbrowser.mozilla;

import com.teamdev.jxbrowser.Configurable;
import com.teamdev.jxbrowser.Feature;
import com.teamdev.jxbrowser.gecko.BrowserPreferences;
import com.teamdev.jxbrowser.mozilla.MozillaBrowser;
import java.util.EnumMap;
import java.util.Map;
import org.mozilla.interfaces.nsIPrefService;
import org.mozilla.xpcom.Mozilla;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MozillaConfigurable
implements Configurable {
    private static boolean a = true;
    private final MozillaBrowser b;
    private final BrowserPreferences c;
    private final Map<Feature, FeatureStateChanger> d;

    public static boolean canAutoEnableOfflineMode() {
        return a;
    }

    public static void setAutoEnableOfflineMode(boolean bl2) {
        a = bl2;
    }

    MozillaConfigurable(MozillaBrowser mozillaBrowser) {
        this.b = mozillaBrowser;
        this.c = new BrowserPreferences();
        this.c.setAllowAuthentication(true);
        this.c.setAllowImages(true);
        this.c.setAllowJavascript(true);
        this.c.setAllowMetaRedirects(true);
        this.c.setAllowPlugins(true);
        this.c.setAllowSubframes(true);
        this.c.setZoom(1.0f);
        this.d = new EnumMap<Feature, FeatureStateChanger>(Feature.class);
        this.d.put(Feature.DOWNLOAD_IMAGES, new ImagesStateChanger(this));
        this.d.put(Feature.JAVASCRIPT, new JavascriptStateChanger(this));
        this.d.put(Feature.PLUGINS, new PluginsStateChanger(this));
        new JavaPluginStateChanger(this).change(false);
    }

    @Override
    public void disableFeature(Feature feature) {
        this.a(feature, false);
    }

    @Override
    public void enableFeature(Feature feature) {
        this.a(feature, true);
        if (feature == Feature.PLUGINS) {
            new JavaPluginStateChanger(this).change(false);
        }
    }

    @Override
    public Map<Feature, Boolean> getFeatures() {
        EnumMap<Feature, Boolean> enumMap = new EnumMap<Feature, Boolean>(Feature.class);
        enumMap.put(Feature.DOWNLOAD_IMAGES, this.c.isAllowImages());
        enumMap.put(Feature.JAVASCRIPT, this.c.isAllowJavascript());
        enumMap.put(Feature.PLUGINS, this.c.isAllowPlugins());
        return enumMap;
    }

    @Override
    public void setFeatures(Map<Feature, Boolean> map) {
        for (Feature feature : map.keySet()) {
            this.a(feature, map.get((Object)feature));
        }
    }

    private void a(Feature feature, boolean bl2) {
        if (this.d.containsKey((Object)feature)) {
            this.d.get((Object)feature).change(bl2);
            feature = this.b.getPeer();
            feature.setPreferences(this.c);
            feature.refresh();
        }
    }

    private class JavaPluginStateChanger
    implements FeatureStateChanger {
        private JavaPluginStateChanger(MozillaConfigurable mozillaConfigurable) {
        }

        public void change(boolean bl2) {
            JavaPluginStateChanger javaPluginStateChanger = (nsIPrefService)Mozilla.getInstance().getServiceManager().getServiceByContractID("@mozilla.org/preferences-service;1", "{decb9cc7-c08f-4ea5-be91-a8fc637ce2d2}");
            javaPluginStateChanger = javaPluginStateChanger.getBranch("plugin.scan.");
            if (bl2) {
                javaPluginStateChanger.setCharPref("SunJRE", System.getProperty("java.specification.version"));
                return;
            }
            javaPluginStateChanger.setCharPref("SunJRE", "999");
        }
    }

    private class PluginsStateChanger
    implements FeatureStateChanger {
        private /* synthetic */ MozillaConfigurable a;

        private PluginsStateChanger(MozillaConfigurable mozillaConfigurable) {
            this.a = mozillaConfigurable;
        }

        public void change(boolean bl2) {
            this.a.c.setAllowPlugins(bl2);
        }
    }

    private class JavascriptStateChanger
    implements FeatureStateChanger {
        private /* synthetic */ MozillaConfigurable a;

        private JavascriptStateChanger(MozillaConfigurable mozillaConfigurable) {
            this.a = mozillaConfigurable;
        }

        public void change(boolean bl2) {
            this.a.c.setAllowJavascript(bl2);
        }
    }

    private class ImagesStateChanger
    implements FeatureStateChanger {
        private /* synthetic */ MozillaConfigurable a;

        private ImagesStateChanger(MozillaConfigurable mozillaConfigurable) {
            this.a = mozillaConfigurable;
        }

        public void change(boolean bl2) {
            this.a.c.setAllowImages(bl2);
        }
    }

    private static interface FeatureStateChanger {
        public void change(boolean var1);
    }
}

