/*
 * Decompiled with CFR 0.152.
 */
package com.teamdev.jxbrowser;

import com.teamdev.jxbrowser.Browser;
import com.teamdev.jxbrowser.BrowserType;
import com.teamdev.jxbrowser.Environment;
import com.teamdev.jxbrowser.UnsupportedBrowserTypeException;
import com.teamdev.jxbrowser.b;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BrowserFactory {
    private static final Logger a = LoggerFactory.getLogger(BrowserFactory.class);
    private static BrowserType b;

    protected abstract Browser create();

    public static Browser createBrowser(BrowserType browserType) {
        Object object;
        if (!browserType.isSupported()) {
            String string = Environment.getInstance().getInfo();
            throw new UnsupportedBrowserTypeException(browserType, (Object)((Object)browserType) + " engine doesn't support current environment: " + string);
        }
        try {
            object = new a();
            object = ((a)object).a(browserType);
        }
        catch (Exception exception) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("Cannot create ").append((Object)browserType).append(" Browser instance on ");
            stringBuilder.append(Environment.getInstance().getInfo());
            a.error(stringBuilder.toString(), (Throwable)exception);
            throw new RuntimeException(stringBuilder.toString(), exception);
        }
        return ((BrowserFactory)object).create();
    }

    public static Browser createBrowser() {
        return BrowserFactory.createBrowser(b);
    }

    public static void setDefaultBrowserType(BrowserType browserType) {
        b = browserType;
    }

    public static BrowserType getDefaultBrowserType() {
        return b;
    }

    static {
        com.teamdev.jxbrowser.b.a();
        b = BrowserType.getPlatformSpecificBrowser();
    }

    private static final class a {
        private final Properties a = new Properties();

        public a() {
            InputStream inputStream = BrowserFactory.class.getResourceAsStream("browsers.properties");
            try {
                this.a.load(inputStream);
                return;
            }
            catch (IOException iOException) {
                throw new RuntimeException(iOException);
            }
        }

        public final BrowserFactory a(BrowserType browserType) {
            Class<Object> clazz = ((a)((Object)clazz)).a.getProperty(browserType.name());
            clazz = Class.forName((String)((Object)clazz));
            clazz = clazz.asSubclass(BrowserFactory.class);
            return clazz.newInstance();
        }
    }
}

