/*
 * Decompiled with CFR 0.152.
 */
package com.jniwrapper;

import com.jniwrapper.Char;
import com.jniwrapper.DelegatingParameter;
import com.jniwrapper.IntegerParameter;
import com.jniwrapper.PlatformContext;
import com.jniwrapper.UInt16;
import com.jniwrapper.UInt32;
import com.jniwrapper.UInt8;
import com.jniwrapper.ac;

public class WideChar
extends DelegatingParameter {
    public WideChar() {
        this('\u0000');
    }

    public WideChar(char c2) {
        ac ac2;
        switch (PlatformContext.getWideCharLength()) {
            case 1: {
                ac2 = new UInt8();
                break;
            }
            case 2: {
                ac2 = new UInt16();
                break;
            }
            case 4: {
                ac2 = new UInt32();
                break;
            }
            default: {
                throw new IllegalStateException("Wide character length is not supported: " + PlatformContext.getWideCharLength());
            }
        }
        super(ac2);
        this.setValue(c2);
    }

    public WideChar(WideChar wideChar) {
        this(wideChar.getValue());
    }

    public int getLength() {
        return PlatformContext.getWideCharLength();
    }

    public Object clone() {
        return new WideChar(this);
    }

    public char getValue() {
        return (char)((IntegerParameter)((Object)this.getValueObject())).getValue();
    }

    public void setValue(char c2) {
        ((IntegerParameter)((Object)this.getValueObject())).setValue(c2);
    }

    public String toString() {
        return this.getClass().getName() + " value: " + String.valueOf(this.getValue());
    }

    public Char toChar() {
        return new Char(this.getValue());
    }
}

