/*
 * Decompiled with CFR 0.152.
 */
package com.jniwrapper;

import com.jniwrapper.JNIWrapperException;
import com.jniwrapper.Library;
import com.jniwrapper.LibraryLoader;
import com.jniwrapper.LibraryNotFoundException;
import com.jniwrapper.LibraryVersionMismatchException;
import com.jniwrapper.PlatformContext;
import com.jniwrapper.ai;
import com.jniwrapper.bc;
import com.jniwrapper.bm;
import com.jniwrapper.util.StreamUtils;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.List;
import java.util.StringTokenizer;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultLibraryLoader
implements LibraryLoader {
    private static final Logger a = LoggerFactory.getLogger((Class)(f == null ? (f = DefaultLibraryLoader.b("com.jniwrapper.DefaultLibraryLoader")) : f));
    private static DefaultLibraryLoader c = null;
    private bc d;
    private static String e = null;
    private String g;
    public static Class f;
    public static Class b;

    private DefaultLibraryLoader() {
        this((f == null ? (f = DefaultLibraryLoader.b("com.jniwrapper.DefaultLibraryLoader")) : f).getClassLoader(), System.getProperty("java.library.path"), Library.NATIVE_CODE);
    }

    public DefaultLibraryLoader(ClassLoader object, String string, String string2) {
        this.d = new ai((ClassLoader)object, string, string2);
        try {
            a.debug("DefaultLibraryLoader.generateTmpFolderName");
            object = this.getClass().getProtectionDomain().getCodeSource().getLocation().toString();
            a.debug("classContainer = " + (String)object);
            string = DefaultLibraryLoader.a((String)object);
            a.debug("bundleVersion = " + string);
            a.debug("DefaultLibraryLoader.getJarName from the container: " + (String)object);
            int n2 = ((String)object).lastIndexOf("/") + 1;
            object = ((String)object).substring(n2);
            n2 = ((String)object).lastIndexOf(".");
            if (n2 == -1) {
                n2 = ((String)object).length();
            }
            object = ((String)object).substring(0, n2);
            a.debug("jarName = " + (String)object);
            String string3 = DefaultLibraryLoader.a();
            a.debug("systemTempFolder = " + string3);
            boolean bl2 = string3.endsWith(File.separator);
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(string3);
            if (!bl2) {
                stringBuffer.append(File.separator);
            }
            if (((String)object).length() != 0) {
                stringBuffer.append((String)object);
            } else {
                stringBuffer.append("JNIWrapper");
            }
            stringBuffer.append(".Build.");
            stringBuffer.append(string);
            if (bl2) {
                stringBuffer.append(File.separator);
            }
            if (!((File)(object = new File(stringBuffer.toString()))).exists() || !((File)object).isDirectory()) {
                if (!((File)object).mkdir()) {
                    this.g = string3;
                    throw new IllegalArgumentException("Cannot create dir: " + ((File)object).getAbsolutePath());
                }
                ((File)object).deleteOnExit();
            }
            this.g = stringBuffer.toString();
            a.debug("DefaultLibraryLoader.generateTmpFolderName: " + this.g);
            return;
        }
        catch (Exception exception) {
            a.debug("Unable to alter tmp folder. Trying to use the system one", (Throwable)exception);
            try {
                this.g = DefaultLibraryLoader.a();
                return;
            }
            catch (IOException iOException) {
                a.debug("Unable to alter tmp folder.", (Throwable)iOException);
                return;
            }
        }
    }

    private static String a(String object) {
        String string = "Unknown";
        if (!((String)object).endsWith("/")) {
            try {
                object = new URL("jar:" + (String)object + "!/META-INF/MANIFEST.MF");
                object = new Manifest(((URL)object).openStream());
                object = ((Manifest)object).getMainAttributes();
                string = ((Attributes)object).getValue("Bundle-Version");
                if (string == null) {
                    string = ((Attributes)object).getValue("Version");
                }
            }
            catch (IOException iOException) {
                a.debug("Unable to retrieve version", (Throwable)iOException);
                string = "Unknown";
            }
        }
        if (string == null) {
            string = "Unknown";
        }
        return string;
    }

    private static String a() {
        String string;
        try {
            string = PlatformContext.isSnowLeopard() || PlatformContext.isLeopard() || PlatformContext.isLion() ? "/private/tmp" : System.getProperty("java.io.tmpdir");
        }
        catch (Exception exception) {
            File file = File.createTempFile("~tmp", "");
            try {
                string = file.getParent();
            }
            finally {
                file.delete();
            }
        }
        return string;
    }

    public static DefaultLibraryLoader getInstance() {
        if (c == null) {
            c = new DefaultLibraryLoader();
        }
        return c;
    }

    public void addPath(File file) {
        this.d.b(file);
    }

    public void prependPath(File file) {
        this.d.a(file);
    }

    public void addPath(List list) {
        this.d.a(list);
    }

    public void addPath(String string) {
        this.d.c(string);
    }

    public File findLibrary(String string) {
        boolean bl2;
        String string2 = string;
        boolean bl3 = bl2 = string2.indexOf(Library.NATIVE_CODE) != -1;
        if (!new File(string).isAbsolute()) {
            string2 = DefaultLibraryLoader.mapLibraryName(string);
        }
        a.debug("Finding library " + string2);
        Object object = null;
        Object object2 = this.getClass().getClassLoader();
        if (object2 == null) {
            a.debug("Class loader of '" + this.getClass() + "' class is null; trying to get context class loader...");
            object2 = Thread.currentThread().getContextClassLoader();
            if (object2 == null) {
                a.debug("Context class looader of current thread: " + Thread.currentThread() + " is null; using system class loader...");
                object2 = ClassLoader.getSystemClassLoader();
            }
        }
        if (object2 == null) {
            a.error("No available class loaders were found");
            throw new RuntimeException("Could not get any class loader");
        }
        try {
            object2 = ((ClassLoader)object2).getResources(string2);
            while (object2.hasMoreElements() && object == null) {
                Object object3 = (URL)object2.nextElement();
                if (object3 != null && ((URL)object3).getProtocol().startsWith("jar")) {
                    a.debug("Looking for library in JAR " + object3);
                    object = this.a((URL)object3, string2);
                }
                if (object != null && ((File)object).exists() || object3 == null) continue;
                a.debug("Finding library in class path...");
                object3 = DefaultLibraryLoader.urlToPath((URL)object3);
                object = ((File)(object3 = new File((String)object3))).exists() && ((File)object3).isFile() ? object3 : null;
                if (object == null || !bl2 || bm.a((File)object)) continue;
                object = bm.a();
            }
        }
        catch (IOException iOException) {
            a.debug("Failed to scan jars for library", (Throwable)iOException);
        }
        if (object == null || !((File)object).exists()) {
            a.debug("Finding library in system library path...");
            object = this.d.b(string2);
        }
        if ((object == null || !((File)object).exists()) && PlatformContext.isMacOS()) {
            a.debug("Finding library in system library path on Mac OS X...");
            string2 = !string.endsWith(".dylib") && !string.endsWith(".jnilib") ? string + ".dylib" : string;
            object2 = this.d.b(string2);
            if (object2 != null) {
                object = object2;
            }
            if (object == null || !((File)object).exists()) {
                int n2 = string2.lastIndexOf("/");
                if (n2 > 0) {
                    string = string2.substring(0, n2);
                    string2 = string + "/lib" + string2.substring(n2 + 1);
                } else {
                    string2 = "lib" + string2;
                }
                object2 = this.d.b(string2);
                if (object2 != null) {
                    object = object2;
                }
            }
        }
        return object;
    }

    public static String urlToPath(URL object) {
        object = ((URL)object).getFile();
        StringBuffer stringBuffer = new StringBuffer();
        StringTokenizer stringTokenizer = new StringTokenizer((String)object, "%", false);
        int n2 = stringTokenizer.countTokens();
        if (n2 > 0) {
            object = stringTokenizer.nextToken();
            if (object != null) {
                stringBuffer.append((String)object);
            }
            while (stringTokenizer.hasMoreTokens()) {
                object = stringTokenizer.nextToken();
                String string = ((String)object).substring(0, 2);
                n2 = Integer.parseInt(string, 16);
                stringBuffer.append((char)n2);
                stringBuffer.append(((String)object).substring(2));
            }
            return stringBuffer.toString();
        }
        return object;
    }

    public void loadLibrary(String string) {
        if ((object = ((DefaultLibraryLoader)object).findLibrary(string)) == null) {
            throw new LibraryNotFoundException("Cannot find library: " + string);
        }
        if (!((File)object).exists()) {
            throw new LibraryVersionMismatchException("Version of the library " + string + "found is not compatible with the current JNIWrapper version");
        }
        Object object = ((File)object).getAbsolutePath();
        a.debug("Loading library from " + (String)object);
        System.load((String)object);
    }

    public static String mapLibraryName(String string) {
        if (string.endsWith(DefaultLibraryLoader.getLibraryExtension())) {
            return string;
        }
        if (string.indexOf(".") != -1) {
            return string;
        }
        return System.mapLibraryName(string);
    }

    public static String getLibraryExtension() {
        if (e == null) {
            String string = System.mapLibraryName("FooLibraryName");
            int n2 = string.indexOf("FooLibraryName");
            e = n2 == -1 ? "" : string.substring(n2 + "FooLibraryName".length());
        }
        return e;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private File a(URL object, String string) {
        File file = null;
        try {
            Object object2;
            a.debug("DefaultLibraryLoader.findLibraryInJars. Loading resources to: " + ((DefaultLibraryLoader)object2).g);
            object = ((URL)object).openStream();
            try {
                file = new File(((DefaultLibraryLoader)object2).g, string);
                if (file.exists() && !file.delete()) {
                    object2 = file;
                    return object2;
                }
                file.createNewFile();
                object2 = new FileOutputStream(file);
                try {
                    StreamUtils.copy((InputStream)object, (OutputStream)object2, 1024);
                }
                finally {
                    ((OutputStream)object2).close();
                }
            }
            finally {
                ((InputStream)object).close();
            }
        }
        catch (Exception exception) {
            object = exception;
            JNIWrapperException.throwException(exception);
        }
        file.deleteOnExit();
        if (string.indexOf(Library.NATIVE_CODE) == -1) return file;
        if (bm.a(file)) return file;
        file.delete();
        return bm.a();
    }

    public static Class b(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

