/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wsdl.extensions.soap;

import com.ibm.wsdl.Constants;
import com.ibm.wsdl.extensions.soap.SOAPConstants;
import com.ibm.wsdl.util.StringUtils;
import com.ibm.wsdl.util.xml.DOMUtils;
import com.ibm.wsdl.util.xml.QNameUtils;
import java.io.PrintWriter;
import java.io.Serializable;
import java.util.List;
import javax.wsdl.Definition;
import javax.wsdl.WSDLException;
import javax.wsdl.extensions.ExtensibilityElement;
import javax.wsdl.extensions.ExtensionDeserializer;
import javax.wsdl.extensions.ExtensionRegistry;
import javax.wsdl.extensions.ExtensionSerializer;
import javax.wsdl.extensions.soap.SOAPHeader;
import javax.wsdl.extensions.soap.SOAPHeaderFault;
import javax.xml.namespace.QName;
import org.w3c.dom.Element;

public class SOAPHeaderSerializer
implements ExtensionSerializer,
ExtensionDeserializer,
Serializable {
    public static final long serialVersionUID = 1L;

    public void marshall(Class clazz, QName qName, ExtensibilityElement extensibilityElement, PrintWriter printWriter, Definition definition, ExtensionRegistry extensionRegistry) throws WSDLException {
        SOAPHeader sOAPHeader = (SOAPHeader)extensibilityElement;
        if (sOAPHeader != null) {
            String string = DOMUtils.getQualifiedValue("http://schemas.xmlsoap.org/wsdl/soap/", "header", definition);
            printWriter.print("        <" + string);
            DOMUtils.printQualifiedAttribute("message", sOAPHeader.getMessage(), definition, printWriter);
            DOMUtils.printAttribute("part", sOAPHeader.getPart(), printWriter);
            DOMUtils.printAttribute("use", sOAPHeader.getUse(), printWriter);
            DOMUtils.printAttribute("encodingStyle", StringUtils.getNMTokens(sOAPHeader.getEncodingStyles()), printWriter);
            DOMUtils.printAttribute("namespace", sOAPHeader.getNamespaceURI(), printWriter);
            Boolean bl = sOAPHeader.getRequired();
            if (bl != null) {
                DOMUtils.printQualifiedAttribute(Constants.Q_ATTR_REQUIRED, bl.toString(), definition, printWriter);
            }
            printWriter.println('>');
            SOAPHeaderSerializer.printSoapHeaderFaults(sOAPHeader.getSOAPHeaderFaults(), definition, printWriter);
            printWriter.println("        </" + string + '>');
        }
    }

    private static void printSoapHeaderFaults(List list, Definition definition, PrintWriter printWriter) throws WSDLException {
        if (list != null) {
            String string = DOMUtils.getQualifiedValue("http://schemas.xmlsoap.org/wsdl/soap/", "headerfault", definition);
            for (SOAPHeaderFault sOAPHeaderFault : list) {
                if (sOAPHeaderFault == null) continue;
                printWriter.print("          <" + string);
                DOMUtils.printQualifiedAttribute("message", sOAPHeaderFault.getMessage(), definition, printWriter);
                DOMUtils.printAttribute("part", sOAPHeaderFault.getPart(), printWriter);
                DOMUtils.printAttribute("use", sOAPHeaderFault.getUse(), printWriter);
                DOMUtils.printAttribute("encodingStyle", StringUtils.getNMTokens(sOAPHeaderFault.getEncodingStyles()), printWriter);
                DOMUtils.printAttribute("namespace", sOAPHeaderFault.getNamespaceURI(), printWriter);
                Boolean bl = sOAPHeaderFault.getRequired();
                if (bl != null) {
                    DOMUtils.printQualifiedAttribute(Constants.Q_ATTR_REQUIRED, bl.toString(), definition, printWriter);
                }
                printWriter.println("/>");
            }
        }
    }

    public ExtensibilityElement unmarshall(Class clazz, QName qName, Element element, Definition definition, ExtensionRegistry extensionRegistry) throws WSDLException {
        SOAPHeader sOAPHeader = (SOAPHeader)extensionRegistry.createExtension(clazz, qName);
        QName qName2 = DOMUtils.getQualifiedAttributeValue(element, "message", "header", false, definition);
        String string = DOMUtils.getAttribute(element, "part");
        String string2 = DOMUtils.getAttribute(element, "use");
        String string3 = DOMUtils.getAttribute(element, "encodingStyle");
        String string4 = DOMUtils.getAttribute(element, "namespace");
        String string5 = DOMUtils.getAttributeNS(element, "http://schemas.xmlsoap.org/wsdl/", "required");
        if (qName2 != null) {
            sOAPHeader.setMessage(qName2);
        }
        if (string != null) {
            sOAPHeader.setPart(string);
        }
        if (string2 != null) {
            sOAPHeader.setUse(string2);
        }
        if (string3 != null) {
            sOAPHeader.setEncodingStyles(StringUtils.parseNMTokens(string3));
        }
        if (string4 != null) {
            sOAPHeader.setNamespaceURI(string4);
        }
        if (string5 != null) {
            sOAPHeader.setRequired(new Boolean(string5));
        }
        Element element2 = DOMUtils.getFirstChildElement(element);
        while (element2 != null) {
            if (QNameUtils.matches(SOAPConstants.Q_ELEM_SOAP_HEADER_FAULT, element2)) {
                sOAPHeader.addSOAPHeaderFault(SOAPHeaderSerializer.parseSoapHeaderFault(SOAPHeader.class, SOAPConstants.Q_ELEM_SOAP_HEADER_FAULT, element2, extensionRegistry, definition));
            } else {
                DOMUtils.throwWSDLException(element2);
            }
            element2 = DOMUtils.getNextSiblingElement(element2);
        }
        return sOAPHeader;
    }

    private static SOAPHeaderFault parseSoapHeaderFault(Class clazz, QName qName, Element element, ExtensionRegistry extensionRegistry, Definition definition) throws WSDLException {
        SOAPHeaderFault sOAPHeaderFault = (SOAPHeaderFault)extensionRegistry.createExtension(clazz, qName);
        QName qName2 = DOMUtils.getQualifiedAttributeValue(element, "message", "header", false, definition);
        String string = DOMUtils.getAttribute(element, "part");
        String string2 = DOMUtils.getAttribute(element, "use");
        String string3 = DOMUtils.getAttribute(element, "encodingStyle");
        String string4 = DOMUtils.getAttribute(element, "namespace");
        String string5 = DOMUtils.getAttributeNS(element, "http://schemas.xmlsoap.org/wsdl/", "required");
        if (qName2 != null) {
            sOAPHeaderFault.setMessage(qName2);
        }
        if (string != null) {
            sOAPHeaderFault.setPart(string);
        }
        if (string2 != null) {
            sOAPHeaderFault.setUse(string2);
        }
        if (string3 != null) {
            sOAPHeaderFault.setEncodingStyles(StringUtils.parseNMTokens(string3));
        }
        if (string4 != null) {
            sOAPHeaderFault.setNamespaceURI(string4);
        }
        if (string5 != null) {
            sOAPHeaderFault.setRequired(new Boolean(string5));
        }
        return sOAPHeaderFault;
    }
}

