/*
 * Decompiled with CFR 0.152.
 */
package com.teamdev.jxbrowser.gecko.cookies;

import com.teamdev.jxbrowser.gecko.cookies.Cookie;
import com.teamdev.jxbrowser.gecko.xpcom.ProxyObjectManager;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.mozilla.interfaces.nsICookie;
import org.mozilla.interfaces.nsICookieManager2;
import org.mozilla.interfaces.nsIFile;
import org.mozilla.interfaces.nsILocalFile;
import org.mozilla.interfaces.nsISimpleEnumerator;
import org.mozilla.interfaces.nsISupports;
import org.mozilla.xpcom.Mozilla;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class CookieManager {
    private final nsICookieManager2 a;

    public CookieManager() {
        ProxyObjectManager proxyObjectManager = ProxyObjectManager.getInstance();
        this.a = proxyObjectManager.proxyForService("@mozilla.org/cookiemanager;1", nsICookieManager2.class);
    }

    public void setCookie(Cookie cookie) {
        this.a.add(cookie.getDomain(), cookie.getDomainsPath(), cookie.getName(), cookie.getValue(), cookie.isSecure(), cookie.isHttpOnly().booleanValue(), cookie.isSession().booleanValue(), cookie.getExpiry());
    }

    public void importCookies(File file) {
        try {
            nsILocalFile nsILocalFile2 = Mozilla.getInstance().newLocalFile(file.getCanonicalPath(), true);
            this.a.importCookies((nsIFile)nsILocalFile2);
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    public int getCookiesCount(String string) {
        return (int)this.a.countCookiesFromHost(string);
    }

    public void remove(String string, String string2, String string3, boolean bl) {
        this.a.remove(string, string2, string3, bl);
    }

    public List<Cookie> getAllCookies() {
        return this.a(this.a.getEnumerator());
    }

    public List<Cookie> getCookiesFromHost(String string) {
        return this.a(this.a.getCookiesFromHost(string));
    }

    private List<Cookie> a(nsISimpleEnumerator nsISimpleEnumerator2) {
        ArrayList<Cookie> arrayList = new ArrayList<Cookie>();
        while (nsISimpleEnumerator2.hasMoreElements()) {
            nsISupports nsISupports2 = nsISimpleEnumerator2.getNext();
            nsICookie nsICookie2 = (nsICookie)nsISupports2.queryInterface("{e9fcb9a4-d376-458f-b720-e65e7df593bc}");
            Cookie cookie = this.a(nsICookie2);
            arrayList.add(cookie);
        }
        return arrayList;
    }

    private Cookie a(nsICookie nsICookie2) {
        Cookie cookie = new Cookie();
        cookie.setDomain(nsICookie2.getHost());
        cookie.setDomainsPath(nsICookie2.getPath());
        cookie.setName(nsICookie2.getName());
        cookie.setValue(nsICookie2.getValue());
        cookie.setSecure(nsICookie2.getIsSecure());
        cookie.setHttpOnly(nsICookie2.getIsSecure());
        cookie.setExpiry((long)nsICookie2.getExpires());
        cookie.setSession(false);
        return cookie;
    }

    public void removeAll() {
        this.a.removeAll();
    }
}

