/*
 * Decompiled with CFR 0.152.
 */
package hermes.swing.actions;

import hermes.Hermes;
import hermes.HermesException;
import hermes.browser.HermesBrowser;
import hermes.browser.IconCache;
import hermes.browser.model.tree.DestinationConfigTreeNode;
import hermes.browser.model.tree.MessageStoreQueueTreeNode;
import hermes.browser.model.tree.MessageStoreTopicTreeNode;
import hermes.browser.model.tree.MessageStoreTreeNode;
import hermes.browser.model.tree.NamingConfigTreeNode;
import hermes.browser.model.tree.RepositoryTreeNode;
import hermes.swing.actions.ActionSupport;
import hermes.util.TextUtils;
import java.awt.Component;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import javax.jms.Destination;
import javax.jms.Queue;
import javax.jms.Topic;
import javax.naming.NamingException;
import javax.swing.Action;
import javax.swing.JOptionPane;
import javax.swing.KeyStroke;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.TreePath;
import org.apache.log4j.Logger;

public class BrowseDestinationOrContextAction
extends ActionSupport {
    private static final Logger log = Logger.getLogger(BrowseDestinationOrContextAction.class);

    public BrowseDestinationOrContextAction() {
        this.putValue("Name", "Browse...");
        this.putValue("ShortDescription", "Browse the queue, topic or context");
        this.putValue("SmallIcon", IconCache.getIcon("hermes.browse"));
        this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(66, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask(), false));
        this.setEnabled(false);
        this.enableOnBrowserTreeSelection(new Class[]{MessageStoreQueueTreeNode.class, MessageStoreTopicTreeNode.class, MessageStoreTreeNode.class, DestinationConfigTreeNode.class, NamingConfigTreeNode.class}, (Action)this, true);
        this.enableOnBrowserTreeSelection(new Class[]{NamingConfigTreeNode.class}, this, new TreeSelectionListener(){

            public void valueChanged(TreeSelectionEvent e) {
                BrowseDestinationOrContextAction.this.setEnabled(BrowseDestinationOrContextAction.this.getBrowserTree().getLastSelectedHermesTreeNode() != null);
            }
        }, true);
    }

    public void actionPerformed(ActionEvent e) {
        this.actionPerformed(this.getBrowserTree().getSelectionModel().getSelectionPath());
    }

    public void actionPerformed(TreePath selectionPath) {
        if (selectionPath != null) {
            try {
                MessageStoreTopicTreeNode topicNode;
                if (selectionPath.getLastPathComponent() instanceof NamingConfigTreeNode) {
                    NamingConfigTreeNode node = (NamingConfigTreeNode)selectionPath.getLastPathComponent();
                    HermesBrowser.getBrowser().getActionFactory().createBrowseContextAction(node.getConfig());
                } else if (selectionPath.getLastPathComponent() instanceof DestinationConfigTreeNode) {
                    DestinationConfigTreeNode destinationNode = (DestinationConfigTreeNode)selectionPath.getLastPathComponent();
                    Hermes hermes = destinationNode.getHermesTreeNode().getHermes();
                    log.info((Object)("browsing " + hermes.getId() + ": " + destinationNode.getDestinationName()));
                    HermesBrowser.getBrowser().getActionFactory().createQueueBrowseAction(hermes, destinationNode.getConfig());
                } else if (selectionPath.getLastPathComponent() instanceof RepositoryTreeNode) {
                    RepositoryTreeNode repNode = (RepositoryTreeNode)selectionPath.getLastPathComponent();
                    if (this.getBrowserTree().getLastSelectedHermesTreeNode() == null) {
                        HermesBrowser.getBrowser().showErrorDialog("You must select a session first to use as the factory to\ncreate messages read from a repository file.");
                    } else {
                        Hermes hermes = HermesBrowser.getBrowser().getBrowserTree().getLastSelectedHermesTreeNode().getHermes();
                        log.info((Object)("reading " + repNode.getRepository().getId()));
                        HermesBrowser.getBrowser().getActionFactory().createRepositoryBrowseAction(repNode.getRepository(), hermes);
                    }
                } else if (selectionPath.getLastPathComponent() instanceof MessageStoreTreeNode) {
                    MessageStoreTreeNode node = (MessageStoreTreeNode)selectionPath.getLastPathComponent();
                    Hermes hermes = this.checkHermesForMessageStore();
                    HermesBrowser.getBrowser().getActionFactory().createMessageStoreBrowseAction(node.getMessageStore(), hermes, null);
                } else if (selectionPath.getLastPathComponent() instanceof MessageStoreQueueTreeNode) {
                    MessageStoreQueueTreeNode queueNode = (MessageStoreQueueTreeNode)selectionPath.getLastPathComponent();
                    if (queueNode.getParent() instanceof MessageStoreTreeNode) {
                        MessageStoreTreeNode storeNode = (MessageStoreTreeNode)queueNode.getParent();
                        Hermes hermes = this.checkHermesForMessageStore();
                        HermesBrowser.getBrowser().getActionFactory().createMessageStoreBrowseAction(storeNode.getMessageStore(), hermes, (Destination)((Queue)queueNode.getBean()), null);
                    }
                } else if (selectionPath.getLastPathComponent() instanceof MessageStoreTopicTreeNode && (topicNode = (MessageStoreTopicTreeNode)selectionPath.getLastPathComponent()).getParent() instanceof MessageStoreTreeNode) {
                    MessageStoreTreeNode storeNode = (MessageStoreTreeNode)topicNode.getParent();
                    Hermes hermes = this.checkHermesForMessageStore();
                    HermesBrowser.getBrowser().getActionFactory().createMessageStoreBrowseAction(storeNode.getMessageStore(), hermes, (Destination)((Topic)topicNode.getBean()), null);
                }
            }
            catch (Exception ex) {
                log.error((Object)ex.getMessage(), (Throwable)ex);
                JOptionPane.showMessageDialog((Component)((Object)HermesBrowser.getBrowser()), "During browse/read: " + ex.getMessage(), "Error", 0);
            }
        }
    }

    private Hermes checkHermesForMessageStore() throws HermesException {
        if (!TextUtils.isEmpty(HermesBrowser.getBrowser().getConfig().getMessageStoreMessageFactory())) {
            try {
                Hermes hermes = (Hermes)HermesBrowser.getBrowser().getContext().lookup(HermesBrowser.getBrowser().getConfig().getMessageStoreMessageFactory());
                if (hermes != null) {
                    return hermes;
                }
            }
            catch (NamingException ex) {
                log.info((Object)("cannot find configured message store message factory, using one from the tree instead: " + ex.getMessage()), (Throwable)ex);
            }
        }
        if (this.getBrowserTree().getLastSelectedHermesTreeNode() == null) {
            return this.getBrowserTree().getBrowserModel().getFirstHermesTreeNode().getHermes();
        }
        return this.getBrowserTree().getLastSelectedHermesTreeNode().getHermes();
    }
}

