/*
 * Decompiled with CFR 0.152.
 */
package hermes.swing;

import java.util.HashSet;
import java.util.Set;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class ProxyListSelectionModel
implements ListSelectionModel {
    private Set<ListSelectionModel> models = new HashSet<ListSelectionModel>();
    private ListSelectionModel selected;
    private Set<ListSelectionListener> listeners = new HashSet<ListSelectionListener>();

    public void remove(ListSelectionModel model) {
        this.models.remove(model);
    }

    public void forward(ListSelectionEvent e) {
        for (ListSelectionListener l : this.listeners) {
            l.valueChanged(e);
        }
    }

    public void add(final ListSelectionModel model) {
        this.models.add(model);
        if (this.models.size() == 1) {
            this.selected = model;
        }
        for (ListSelectionListener l : this.listeners) {
            model.addListSelectionListener(l);
        }
        model.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent e) {
                ProxyListSelectionModel.this.selected = model;
            }
        });
    }

    public void addListSelectionListener(ListSelectionListener x) {
        this.listeners.add(x);
        for (ListSelectionModel m : this.models) {
            m.addListSelectionListener(x);
        }
    }

    public void removeListSelectionListener(ListSelectionListener x) {
        this.listeners.remove(x);
        for (ListSelectionModel m : this.models) {
            m.removeListSelectionListener(x);
        }
    }

    public void addSelectionInterval(int index0, int index1) {
        this.selected.addSelectionInterval(index0, index1);
    }

    public void clearSelection() {
        this.selected.clearSelection();
    }

    public int getAnchorSelectionIndex() {
        return this.selected.getAnchorSelectionIndex();
    }

    public int getLeadSelectionIndex() {
        return this.selected.getLeadSelectionIndex();
    }

    public int getMaxSelectionIndex() {
        return this.selected.getMaxSelectionIndex();
    }

    public int getMinSelectionIndex() {
        return this.selected.getMinSelectionIndex();
    }

    public int getSelectionMode() {
        return this.selected.getSelectionMode();
    }

    public boolean getValueIsAdjusting() {
        return this.selected.getValueIsAdjusting();
    }

    public void insertIndexInterval(int index, int length, boolean before) {
        this.selected.insertIndexInterval(index, length, before);
    }

    public boolean isSelectedIndex(int index) {
        return this.selected.isSelectedIndex(index);
    }

    public boolean isSelectionEmpty() {
        return this.selected.isSelectionEmpty();
    }

    public void removeIndexInterval(int index0, int index1) {
        this.selected.removeIndexInterval(index0, index1);
    }

    public void removeSelectionInterval(int index0, int index1) {
        this.selected.removeSelectionInterval(index0, index1);
    }

    public void setAnchorSelectionIndex(int index) {
        this.selected.setAnchorSelectionIndex(index);
    }

    public void setLeadSelectionIndex(int index) {
        this.selected.setLeadSelectionIndex(index);
    }

    public void setSelectionInterval(int index0, int index1) {
        this.selected.setSelectionInterval(index0, index1);
    }

    public void setSelectionMode(int selectionMode) {
        this.selected.setSelectionMode(selectionMode);
    }

    public void setValueIsAdjusting(boolean valueIsAdjusting) {
        this.selected.setValueIsAdjusting(valueIsAdjusting);
    }
}

