/*
 * Decompiled with CFR 0.152.
 */
package hermes.swing;

import com.jidesoft.docking.DockableFrame;
import com.jidesoft.document.DocumentComponentEvent;
import com.jidesoft.document.DocumentComponentListener;
import com.jidesoft.pane.CollapsiblePane;
import com.jidesoft.pane.CollapsiblePanes;
import com.jidesoft.swing.JideButton;
import com.jidesoft.swing.MultilineLabel;
import hermes.HermesException;
import hermes.browser.HermesBrowser;
import hermes.browser.IconCache;
import hermes.browser.actions.FilterableAction;
import hermes.config.HermesConfig;
import hermes.util.TextUtils;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyVetoException;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.Icon;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import org.apache.log4j.Logger;

public class FilterInputPanel
extends DockableFrame
implements DocumentComponentListener {
    private static final Logger log = Logger.getLogger(FilterInputPanel.class);
    private JideButton comboFilterButton = new JideButton((Icon)IconCache.getIcon("hermes.filter.sql"));
    private JideButton comboRemoveFilterButton = new JideButton((Icon)IconCache.getIcon("hermes.delete"));
    private JideButton textFilterButton = new JideButton((Icon)IconCache.getIcon("hermes.filter.sql"));
    private JideButton textSaveFilterButton = new JideButton((Icon)IconCache.getIcon("hermes.save"));
    private Vector<String> filterHistory = new Vector();
    private JComboBox filterCombo;
    private JTextField filterField = new JTextField();

    public FilterInputPanel() {
        super("Filters", (Icon)IconCache.getIcon("hermes.filter.sql"));
        this.init();
        this.getContext().setInitMode(2);
        this.getContext().setInitSide(4);
        this.setAvailableButtons(12);
        this.comboFilterButton.setToolTipText("Run SQL filter.");
        this.textFilterButton.setToolTipText("Run SQL filter.");
        this.textSaveFilterButton.setToolTipText("Save this filter.");
        this.comboRemoveFilterButton.setToolTipText("Delete this filter.");
        this.setEnabled(false);
    }

    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.filterCombo.setEnabled(enabled);
        this.filterField.setEnabled(enabled);
        this.comboFilterButton.setEnabled(enabled);
        this.textFilterButton.setEnabled(enabled);
        this.textSaveFilterButton.setEnabled(enabled);
        this.comboRemoveFilterButton.setEnabled(enabled);
    }

    private String getDescription() {
        return "Filters are SQL92 expressions that can filter out messages that have been browsed from a JMS queue, topic, message file or a FIX session log. In the expression you can use:\n\nAny JMS header properties.\n\nJMS MapMessage properties.\n\nAny FIX tag, either by number or tag name.";
    }

    private void init() {
        try {
            this.filterHistory.addAll(HermesBrowser.getBrowser().getConfig().getFilters());
        }
        catch (HermesException e1) {
            HermesBrowser.getBrowser().showErrorDialog("Unable to load filter history", (Throwable)((Object)e1));
        }
        this.getContentPane().setLayout(new BorderLayout());
        CollapsiblePanes panes = new CollapsiblePanes();
        CollapsiblePane descriptionPane = new CollapsiblePane("Using Filters");
        MultilineLabel label = new MultilineLabel(this.getDescription());
        label.setBorder(BorderFactory.createEmptyBorder(8, 10, 8, 10));
        descriptionPane.setContentPane((JComponent)label);
        try {
            descriptionPane.setCollapsed(true);
        }
        catch (PropertyVetoException e) {
            log.warn((Object)e.getMessage(), (Throwable)e);
        }
        CollapsiblePane comboPane = new CollapsiblePane("Saved Filters");
        comboPane.getContentPane().setLayout(new BoxLayout(comboPane.getContentPane(), 0));
        JPanel comboPanel = new JPanel();
        comboPanel.setLayout(new BoxLayout(comboPanel, 0));
        comboPanel.setBorder(BorderFactory.createEmptyBorder(8, 10, 8, 10));
        comboPane.setEmphasized(true);
        try {
            comboPane.setCollapsed(true);
        }
        catch (PropertyVetoException e) {
            log.warn((Object)e.getMessage(), (Throwable)e);
        }
        this.filterCombo = new JComboBox<String>(this.filterHistory);
        this.filterCombo.setEditable(false);
        comboPanel.add(this.filterCombo);
        comboPanel.add((Component)this.comboFilterButton);
        comboPanel.add((Component)this.comboRemoveFilterButton);
        comboPane.setContentPane((JComponent)comboPanel);
        CollapsiblePane fieldPane = new CollapsiblePane("New Filter");
        JPanel fieldPanel = new JPanel();
        fieldPane.setEmphasized(true);
        fieldPanel.setLayout(new BoxLayout(fieldPanel, 0));
        fieldPanel.setBorder(BorderFactory.createEmptyBorder(8, 10, 8, 10));
        fieldPanel.add(this.filterField);
        fieldPanel.add((Component)this.textFilterButton);
        fieldPanel.add((Component)this.textSaveFilterButton);
        fieldPane.setContentPane((JComponent)fieldPanel);
        panes.add((Component)fieldPane);
        panes.add((Component)comboPane);
        panes.add((Component)descriptionPane);
        panes.addExpansion();
        this.filterField.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                FilterInputPanel.this.doFilter(FilterInputPanel.this.filterField.getText());
            }
        });
        this.filterCombo.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                FilterInputPanel.this.doFilter((String)FilterInputPanel.this.filterCombo.getSelectedItem());
            }
        });
        this.comboFilterButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                FilterInputPanel.this.doFilter((String)FilterInputPanel.this.filterCombo.getSelectedItem());
            }
        });
        this.textFilterButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                FilterInputPanel.this.doFilter(FilterInputPanel.this.filterField.getText());
            }
        });
        this.comboRemoveFilterButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (FilterInputPanel.this.filterCombo.getSelectedIndex() >= 0) {
                    FilterInputPanel.this.filterCombo.removeItemAt(FilterInputPanel.this.filterCombo.getSelectedIndex());
                    FilterInputPanel.this.updateFilterConfig();
                }
            }
        });
        this.textSaveFilterButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (!TextUtils.isEmpty(FilterInputPanel.this.filterField.getText()) && !FilterInputPanel.this.filterHistory.contains(FilterInputPanel.this.filterField.getText())) {
                    FilterInputPanel.this.filterCombo.addItem(FilterInputPanel.this.filterField.getText());
                    FilterInputPanel.this.updateFilterConfig();
                }
            }
        });
        this.getContentPane().add((Component)new JScrollPane((Component)panes), "Center");
    }

    public void documentComponentDocked(DocumentComponentEvent arg0) {
    }

    public void documentComponentFloated(DocumentComponentEvent arg0) {
    }

    private void doFilter(String filter) {
        if (HermesBrowser.getBrowser().getDocumentPane().getActiveDocument() instanceof FilterableAction) {
            FilterableAction filterableAction = (FilterableAction)HermesBrowser.getBrowser().getDocumentPane().getActiveDocument();
            try {
                filterableAction.setSelector(filter);
            }
            catch (Throwable e) {
                HermesBrowser.getBrowser().showErrorDialog("Invalid selector: ", e);
            }
        }
    }

    public void documentComponentActivated(DocumentComponentEvent event) {
        if (event.getDocumentComponent() instanceof FilterableAction) {
            this.setEnabled(true);
        } else {
            this.setEnabled(false);
        }
    }

    private void updateFilterConfig() {
        try {
            HermesConfig config = HermesBrowser.getBrowser().getConfig();
            config.getFilters().clear();
            config.getFilters().addAll(this.filterHistory);
            HermesBrowser.getBrowser().backupConfig();
            HermesBrowser.getBrowser().saveConfig();
        }
        catch (HermesException e) {
            HermesBrowser.getBrowser().showErrorDialog("Unable to update configuration", (Throwable)((Object)e));
        }
    }

    public void documentComponentClosed(DocumentComponentEvent arg0) {
    }

    public void documentComponentClosing(DocumentComponentEvent arg0) {
    }

    public void documentComponentDeactivated(DocumentComponentEvent arg0) {
    }

    public void documentComponentMoved(DocumentComponentEvent arg0) {
    }

    public void documentComponentMoving(DocumentComponentEvent arg0) {
    }

    public void documentComponentOpened(DocumentComponentEvent arg0) {
    }
}

