/*
 * Decompiled with CFR 0.152.
 */
package hermes.store.jdbc;

import hermes.Domain;
import hermes.HermesRuntimeException;
import hermes.MessageFactory;
import hermes.impl.DefaultXMLHelper;
import hermes.impl.XMLHelper;
import hermes.store.MessageStore;
import hermes.store.MessageStoreQueue;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.List;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.Queue;
import javax.jms.QueueBrowser;
import javax.naming.NamingException;
import org.apache.commons.dbutils.DbUtils;
import org.apache.log4j.Logger;

public class MessageResultSetHandler
implements QueueBrowser {
    private static final Logger log = Logger.getLogger(MessageResultSetHandler.class);
    private ResultSet resultSet;
    private List<Message> cachedMessages = new ArrayList<Message>();
    private XMLHelper xmlHelper = new DefaultXMLHelper();
    private MessageFactory messageFactory;
    private Connection connection;
    private MessageStore.HeaderPolicy headerPolicy;
    private PreparedStatement statement;
    private boolean resultSetEmpty = false;
    private Enumeration enumeration;

    public MessageResultSetHandler(Connection connection, PreparedStatement statement, MessageFactory messageFactory, MessageStore.HeaderPolicy headerPolicy) throws SQLException {
        this.connection = connection;
        this.messageFactory = messageFactory;
        this.headerPolicy = headerPolicy;
        this.statement = statement;
        this.resultSet = statement.executeQuery();
        this.enumeration = new Enumeration(){

            public Object nextElement() {
                return MessageResultSetHandler.this.getNextMessageQuietly();
            }

            public boolean hasMoreElements() {
                return MessageResultSetHandler.this.hasNextMessage();
            }
        };
    }

    public boolean hasNextMessage() {
        return !this.resultSetEmpty || this.cachedMessages.size() > 0;
    }

    public Message getNextMessage() throws JMSException, SQLException, NamingException {
        if (this.cachedMessages.size() > 0) {
            return this.cachedMessages.remove(0);
        }
        if (this.resultSet.next()) {
            Collection<Message> c = this.xmlHelper.fromXML(this.messageFactory, this.resultSet.getClob(3).getAsciiStream());
            for (Message m : c) {
                if (this.headerPolicy != MessageStore.HeaderPolicy.NO_HEADER) {
                    Destination d = this.messageFactory.getDestination(this.resultSet.getString(1), Domain.getDomain(this.resultSet.getInt(2)));
                    if (this.headerPolicy == MessageStore.HeaderPolicy.DESTINATION_ONLY) {
                        m.setJMSDestination(d);
                    } else if (this.headerPolicy == MessageStore.HeaderPolicy.MESSAGEID_ONLY) {
                        m.setJMSMessageID(this.resultSet.getString(4));
                    } else if (this.headerPolicy == MessageStore.HeaderPolicy.MESSAGEID_AND_DESTINATION) {
                        m.setJMSDestination(d);
                        m.setJMSMessageID(this.resultSet.getString(4));
                    }
                }
                this.cachedMessages.add(m);
            }
            if (this.cachedMessages.size() > 0) {
                return this.cachedMessages.remove(0);
            }
            return null;
        }
        this.resultSetEmpty = true;
        this.close();
        return null;
    }

    public void close() {
        log.debug((Object)"closing MessageResultSetHandler...");
        DbUtils.closeQuietly((Statement)this.statement);
        DbUtils.closeQuietly((Connection)this.connection);
        this.connection = null;
    }

    public Enumeration getEnumeration() throws JMSException {
        return this.enumeration;
    }

    public String getMessageSelector() throws JMSException {
        return null;
    }

    public Queue getQueue() throws JMSException {
        return new MessageStoreQueue("");
    }

    public boolean hasNext() {
        return this.hasNextMessage();
    }

    public Message getNextMessageQuietly() {
        try {
            return this.getNextMessage();
        }
        catch (Exception ex) {
            this.close();
            throw new HermesRuntimeException(ex);
        }
    }
}

