/*
 * Decompiled with CFR 0.152.
 */
package hermes.renderers;

import hermes.renderers.AbstractMessageRenderer;
import hermes.util.MessageUtils;
import hermes.util.XmlUtils;
import java.awt.Font;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.TextMessage;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import org.apache.log4j.Logger;

public class XMLMessageRenderer
extends AbstractMessageRenderer {
    private static final Logger log = Logger.getLogger(XMLMessageRenderer.class);

    public JComponent render(Message m) {
        JEditorPane pane = new JEditorPane();
        pane.setEditable(false);
        pane.setContentType("text/xml");
        try {
            String string = MessageUtils.asString(m);
            pane.setText(XmlUtils.prettyPrintXml(string));
            pane.setCaretPosition(0);
            pane.setFont(Font.decode("Monospaced-PLAIN-12"));
        }
        catch (Throwable e) {
            pane.setText(e.getMessage());
            log.error((Object)"exception converting message to byte[]: ", e);
        }
        pane.setCaretPosition(0);
        return pane;
    }

    public boolean canRender(Message message) {
        try {
            if (message instanceof TextMessage) {
                String text = ((TextMessage)message).getText();
                return XmlUtils.isXML(text);
            }
        }
        catch (JMSException e) {
            log.error((Object)("error getting text: " + e.getMessage()), (Throwable)e);
        }
        return false;
    }

    public String getDisplayName() {
        return "XML";
    }
}

