/*
 * Decompiled with CFR 0.152.
 */
package hermes.renderers;

import hermes.HermesException;
import hermes.browser.HermesBrowser;
import hermes.browser.MessageRenderer;
import hermes.config.DestinationConfig;
import hermes.config.HermesConfig;
import hermes.config.RendererConfig;
import hermes.config.SessionConfig;
import hermes.renderers.DefaultMessageRenderer;
import java.awt.Component;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import javax.swing.JOptionPane;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RendererManager {
    private static final Logger log = Logger.getLogger(RendererManager.class);
    private List<MessageRenderer> renderers = new ArrayList<MessageRenderer>();
    private Map<String, MessageRenderer> renderersByClass = new HashMap<String, MessageRenderer>();
    private Map<String, MessageRenderer> renderersByName = new HashMap<String, MessageRenderer>();

    public MessageRenderer createRenderer(ClassLoader classLoader, RendererConfig rConfig) throws InvocationTargetException, HermesException, InstantiationException, IllegalAccessException, ClassNotFoundException {
        Thread.currentThread().setContextClassLoader(classLoader);
        MessageRenderer renderer = (MessageRenderer)classLoader.loadClass(rConfig.getClassName()).newInstance();
        MessageRenderer.Config rendererConfig = renderer.createConfig();
        if (rendererConfig != null) {
            Properties rendererProperties = HermesBrowser.getConfigDAO().getRendererProperties(rConfig);
            BeanUtils.populate((Object)rendererConfig, (Map)rendererProperties);
        }
        renderer.setConfig(rendererConfig);
        return renderer;
    }

    public void setConfig(ClassLoader classLoader, HermesConfig config) throws HermesException {
        MessageRenderer renderer;
        boolean gotDefaultRenderer = false;
        for (RendererConfig rConfig : config.getRenderer()) {
            try {
                renderer = this.createRenderer(classLoader, rConfig);
                if (renderer.getClass().getName().equals(DefaultMessageRenderer.class.getName())) {
                    gotDefaultRenderer = true;
                }
                this.renderersByClass.put(rConfig.getClassName(), renderer);
                this.renderersByName.put(renderer.getDisplayName(), renderer);
            }
            catch (Throwable t) {
                log.error((Object)("cannot load renderer " + rConfig.getClassName() + ": " + t.getMessage()), t);
                if (HermesBrowser.getBrowser() == null) continue;
                JOptionPane.showMessageDialog((Component)((Object)HermesBrowser.getBrowser()), "Cannot load renderer " + rConfig.getClassName() + ":\n" + t.getClass().getName() + "\n" + t.getMessage(), "Error", 0);
            }
        }
        this.renderers.clear();
        if (!gotDefaultRenderer) {
            RendererConfig rConfig = new RendererConfig();
            rConfig.setClassName(DefaultMessageRenderer.class.getName());
            config.getRenderer().add(rConfig);
            this.renderers.add(new DefaultMessageRenderer());
        }
        StringTokenizer rendererClasses = new StringTokenizer(System.getProperty("hermes.renderer.classes", "hermes.renderers.DefaultMessageRenderer,hermes.renderers.DefaultMessageHeaderRenderer,hermes.renderers.ToStringMessageRenderer,hermes.renderers.HexMessageRenderer,hermes.renderers.XMLMessageRenderer,hermes.renderers.fix.FIXMessageRenderer,hermes.renderers.EBCDICMessageRenderer"), ",");
        while (rendererClasses.hasMoreTokens()) {
            String rendererClassName = rendererClasses.nextToken();
            if (this.renderersByClass.containsKey(rendererClassName)) {
                this.renderers.add(this.renderersByClass.get(rendererClassName));
                continue;
            }
            try {
                renderer = (MessageRenderer)Class.forName(rendererClassName).newInstance();
                this.renderers.add(renderer);
                this.renderersByClass.put(rendererClassName, renderer);
                this.renderersByName.put(renderer.getDisplayName(), renderer);
            }
            catch (Throwable t) {
                log.error((Object)("cannot instantiate renderer: " + rendererClassName + ": " + t.getMessage()), t);
            }
        }
        log.debug((Object)"renderer chain:");
        for (MessageRenderer r : this.renderers) {
            log.debug((Object)(r.getDisplayName() + ": " + r.getClass().getName()));
        }
        for (SessionConfig sConfig : HermesBrowser.getConfigDAO().getAllSessions(config)) {
            for (DestinationConfig dConfig : HermesBrowser.getConfigDAO().getAllDestinations(config, sConfig.getId())) {
                if (dConfig.getRenderer() == null) continue;
                dConfig.setRenderer(null);
            }
        }
    }

    public Collection<MessageRenderer> getRenderers() {
        return this.renderers;
    }

    public MessageRenderer getRendererByName(String displayName) {
        return this.renderersByName.get(displayName);
    }

    public MessageRenderer getRendererByClass(String className) {
        return this.renderersByClass.get(className);
    }
}

