/*
 * Decompiled with CFR 0.152.
 */
package hermes.impl.jms;

import hermes.Hermes;
import hermes.impl.ConnectionManager;
import hermes.impl.jms.ConnectionManagerSupport;
import javax.jms.Connection;
import javax.jms.JMSException;
import org.apache.log4j.Logger;

public class ConnectionPerThreadManager
extends ConnectionManagerSupport
implements ConnectionManager {
    private static final Logger log = Logger.getLogger(ConnectionPerThreadManager.class);
    private ThreadLocal connectionTL = new ThreadLocal();
    private ThreadLocal clientIDTL = new ThreadLocal();
    private int connectionId = 0;

    public void reconnect(String username, String password) throws JMSException {
        Connection oldConnection = (Connection)this.connectionTL.get();
        if (oldConnection != null) {
            try {
                oldConnection.close();
            }
            catch (JMSException e) {
                log.error((Object)("closing old connection: " + e.getMessage()), (Throwable)e);
            }
        }
        if (username != null) {
            this.connectionTL.set(this.createConnection(username, password));
        } else {
            this.connectionTL.set(this.createConnection());
        }
    }

    public void connect() throws JMSException {
        this.reconnect(null, null);
    }

    public Object getObject() throws JMSException {
        return this.getConnection();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws JMSException {
        if (this.connectionTL.get() != null) {
            try {
                Connection connection = (Connection)this.connectionTL.get();
                connection.close();
            }
            finally {
                this.connectionTL.set(null);
                Hermes.events.notifyDisconnected(this.getHermes());
            }
        }
    }

    public Connection getConnection() throws JMSException {
        if (this.connectionTL.get() == null) {
            this.connect();
        }
        return (Connection)this.connectionTL.get();
    }

    public ConnectionManager.Policy getType() {
        return ConnectionManager.Policy.CONNECTION_PER_THREAD;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getClientID() {
        if (super.getClientID() == null) {
            return null;
        }
        if (this.clientIDTL.get() != null) {
            return (String)this.clientIDTL.get();
        }
        ConnectionPerThreadManager connectionPerThreadManager = this;
        synchronized (connectionPerThreadManager) {
            String clientID = super.getClientID() + "-" + this.connectionId++;
            this.clientIDTL.set(clientID);
            return clientID;
        }
    }
}

