/*
 * Decompiled with CFR 0.152.
 */
package hermes.impl;

import hermes.Hermes;
import hermes.HermesException;
import hermes.ProviderMetaData;
import hermes.config.FactoryConfig;
import hermes.config.PropertyConfig;
import java.util.Iterator;
import javax.jms.ConnectionMetaData;
import javax.jms.JMSException;
import org.apache.log4j.Category;

public class DefaultProviderMetaData
implements ProviderMetaData {
    private static final Category cat = Category.getInstance(DefaultProviderMetaData.class);
    private FactoryConfig hermesConfig;
    private String shortName;
    private Hermes hermes;
    private boolean cacheToolTipText = true;
    private String toolTipText;
    private boolean connectionSharing = true;

    public DefaultProviderMetaData(Hermes hermes, FactoryConfig hermesConfig, boolean connectionSharing) throws JMSException {
        this(hermes, hermesConfig, hermes.getId(), connectionSharing);
    }

    public DefaultProviderMetaData(Hermes hermes, FactoryConfig hermesConfig, String shortName, boolean connectionSharing) throws JMSException {
        this.hermes = hermes;
        this.hermesConfig = hermesConfig;
        this.shortName = shortName;
        this.connectionSharing = connectionSharing;
    }

    public String getShortName() throws HermesException {
        return this.shortName;
    }

    public void setShortName(String shortName) {
        this.shortName = shortName;
    }

    public String getToolTipText() throws HermesException {
        try {
            if (this.toolTipText == null && this.hermes.getConnectionFactory() != null) {
                StringBuffer buffer = new StringBuffer();
                buffer.append("<html><b>").append(this.hermes.getConnectionFactory().getClass().getName()).append("</b><br>");
                Iterator<PropertyConfig> iter = this.hermesConfig.getProvider().getProperties().getProperty().iterator();
                while (iter.hasNext()) {
                    PropertyConfig property = iter.next();
                    buffer.append(property.getName()).append("=").append(property.getValue());
                    if (!iter.hasNext()) continue;
                    buffer.append("<br>");
                }
                buffer.append("</html>");
                this.toolTipText = buffer.toString();
            }
        }
        catch (JMSException e) {
            throw new HermesException(e.getMessage(), (Exception)((Object)e));
        }
        return this.toolTipText;
    }

    public String getDebugText() throws HermesException {
        return this.getToolTipText();
    }

    public ConnectionMetaData getConnectionMetaData() throws JMSException {
        return this.hermes.getConnection().getMetaData();
    }

    public boolean getConnectionSharing() {
        return this.connectionSharing;
    }
}

