/*
 * Decompiled with CFR 0.152.
 */
package hermes.fix.quickfix;

import hermes.HermesRuntimeException;
import hermes.fix.FIXException;
import hermes.fix.FIXMessage;
import hermes.fix.FIXMessageFilter;
import hermes.fix.FIXReader;
import hermes.fix.MalformedMessageException;
import hermes.fix.quickfix.NIOQuickFIXMessage;
import hermes.fix.quickfix.QuickFIXMessageCache;
import hermes.fix.quickfix.QuickFIXUtils;
import java.io.FileInputStream;
import java.io.IOException;
import java.lang.reflect.Method;
import java.nio.BufferUnderflowException;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.TimeUnit;
import org.apache.log4j.Logger;
import sun.misc.Cleaner;

public class NIOFIXFileReader
implements FIXReader,
Runnable {
    private static final Logger log = Logger.getLogger(NIOFIXFileReader.class);
    private static byte[] startOfMessage = new byte[]{56, 61, 70, 73, 88};
    private FileInputStream istream;
    private MappedByteBuffer parseBuffer;
    private MappedByteBuffer readBuffer;
    private Object lock = new Object();
    private int position = 0;
    private int mappedStart;
    private BlockingQueue<FIXMessage> messages = new ArrayBlockingQueue<FIXMessage>(8192);
    private QuickFIXMessageCache messageCache;
    private FIXMessageFilter filter = new FIXMessageFilter();

    public FIXMessageFilter getFilter() {
        return this.filter;
    }

    public NIOFIXFileReader(QuickFIXMessageCache messageCache, FileInputStream istream) throws IOException {
        this.istream = istream;
        this.messageCache = messageCache;
        this.map();
        new Thread(this).start();
    }

    public FIXMessage read() throws IOException {
        return this.read(-1L);
    }

    public FIXMessage read(long timeout) {
        try {
            FIXMessage rval = this.messages.poll(100L, TimeUnit.MILLISECONDS);
            while (rval == null && this.istream.getChannel().isOpen()) {
                rval = this.messages.poll(100L, TimeUnit.MILLISECONDS);
            }
            return rval;
        }
        catch (Exception ex) {
            log.error((Object)ex.getMessage(), (Throwable)ex);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] getBytes(int offset, int length) {
        Object object = this.lock;
        synchronized (object) {
            byte[] bytes = new byte[length];
            this.readBuffer.position(offset);
            this.readBuffer.get(bytes);
            return bytes;
        }
    }

    private void waitAndRemap() throws InterruptedException, IOException {
        Thread.sleep(500L);
        this.map();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run() {
        try {
            while (true) {
                if (!this.istream.getChannel().isOpen()) {
                    log.debug((Object)"channel closed");
                    return;
                }
                try {
                    FIXMessage m = this.readMessage();
                    try {
                        if (m == null || !this.filter.filter(m.getMsgType())) continue;
                        this.messages.put(m);
                    }
                    catch (HermesRuntimeException ex) {
                        log.error((Object)("ignoring invalid message: " + ex.getMessage()), (Throwable)ex);
                    }
                }
                catch (BufferUnderflowException ex) {
                    this.waitAndRemap();
                }
                catch (IllegalArgumentException ex) {
                    this.waitAndRemap();
                }
            }
        }
        catch (Throwable ex) {
            log.error((Object)ex.getMessage(), ex);
        }
    }

    protected FIXMessage readMessage() throws MalformedMessageException, FIXException, BufferUnderflowException, InterruptedException, IOException {
        byte b;
        this.parseBuffer.position(this.position);
        int startOfMessageIndex = 0;
        while (startOfMessageIndex < startOfMessage.length) {
            b = this.parseBuffer.get();
            if (startOfMessage[startOfMessageIndex] == b) {
                ++startOfMessageIndex;
                continue;
            }
            startOfMessageIndex = 0;
        }
        int startOfMessageOffset = this.parseBuffer.position() - startOfMessage.length;
        byte[] protocolAsBytes = new byte[12];
        int protocolAsBytesIndex = 0;
        while ((b = this.parseBuffer.get()) != 1) {
            protocolAsBytes[protocolAsBytesIndex++] = b;
        }
        protocolAsBytes[protocolAsBytesIndex++] = 0;
        String protocol = "FIX" + new String(protocolAsBytes).trim();
        b = this.parseBuffer.get();
        if (b != 57) {
            this.position = this.parseBuffer.position();
            throw new MalformedMessageException("Tag 9 does not follow tag 8");
        }
        this.parseBuffer.get();
        byte[] messageLengthBuffer = new byte[16];
        int messageLengthBufferOffset = 0;
        while ((b = this.parseBuffer.get()) != 1) {
            messageLengthBuffer[messageLengthBufferOffset++] = b;
        }
        messageLengthBuffer[messageLengthBufferOffset++] = 1;
        String s = new String(messageLengthBuffer).trim();
        int fixLength = Integer.parseInt(s);
        this.parseBuffer.position(this.parseBuffer.position() + fixLength);
        while ((b = this.parseBuffer.get()) != 1) {
        }
        int messageLength = this.parseBuffer.position() - startOfMessageOffset;
        this.position = this.parseBuffer.position();
        return new NIOQuickFIXMessage(this.messageCache, this, this.mappedStart + startOfMessageOffset, messageLength, QuickFIXUtils.getDictionary(protocol));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void map() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            FileChannel channel = this.istream.getChannel();
            if (channel.isOpen() && (this.parseBuffer == null || channel.size() > (long)this.mappedStart)) {
                if (this.parseBuffer != null) {
                    this.clean(this.parseBuffer);
                }
                if (this.readBuffer != null) {
                    this.clean(this.readBuffer);
                }
                this.mappedStart += this.position;
                this.parseBuffer = channel.map(FileChannel.MapMode.READ_ONLY, this.mappedStart, channel.size() - (long)this.mappedStart);
                this.readBuffer = channel.map(FileChannel.MapMode.READ_ONLY, 0L, channel.size());
                this.position = 0;
            }
        }
    }

    private final void clean(final MappedByteBuffer buffer) {
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                try {
                    Method getCleanerMethod = buffer.getClass().getMethod("cleaner", new Class[0]);
                    getCleanerMethod.setAccessible(true);
                    Cleaner cleaner = (Cleaner)getCleanerMethod.invoke((Object)buffer, new Object[0]);
                    cleaner.clean();
                }
                catch (Exception e) {
                    log.error((Object)e.getMessage(), (Throwable)e);
                }
                return null;
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void release() {
        Object object = this.lock;
        synchronized (object) {
            if (this.readBuffer != null) {
                log.debug((Object)"releasing read memory map");
                this.clean(this.readBuffer);
                this.readBuffer = null;
            }
        }
    }

    protected void finalize() throws Throwable {
        this.release();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        Object object = this.lock;
        synchronized (object) {
            try {
                if (this.istream != null) {
                    this.istream.getChannel().close();
                    this.istream.close();
                    if (this.parseBuffer != null) {
                        log.debug((Object)"releasing parse memory map");
                        this.clean(this.parseBuffer);
                    }
                    this.parseBuffer = null;
                }
            }
            catch (IOException ex) {
                throw new HermesRuntimeException(ex);
            }
        }
    }
}

