/*
 * Decompiled with CFR 0.152.
 */
package hermes.ext;

import hermes.Domain;
import hermes.Hermes;
import hermes.HermesAdmin;
import hermes.HermesException;
import hermes.config.DestinationConfig;
import hermes.ext.HermesAdminSupport;
import java.util.Enumeration;
import javax.jms.JMSException;
import javax.jms.QueueBrowser;
import org.apache.log4j.Logger;

public class DefaultHermesAdmin
extends HermesAdminSupport
implements HermesAdmin {
    private static final Logger log = Logger.getLogger(DefaultHermesAdmin.class);
    private boolean sizeDialogShown = false;
    private int maxSize = 100;

    public DefaultHermesAdmin(Hermes hermes) {
        super(hermes);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getDepth(DestinationConfig dest) throws JMSException {
        if (dest.getDomain().intValue() == Domain.QUEUE.getId()) {
            QueueBrowser browser = this.getHermes().createBrowser(dest);
            int depth = 0;
            try {
                Enumeration iter = browser.getEnumeration();
                while (iter.hasMoreElements()) {
                    iter.nextElement();
                    if (++depth <= this.maxSize) continue;
                    throw new HermesException("The default admin provider only implements queue depth functionality up to " + this.maxSize + " messages");
                }
            }
            finally {
                browser.close();
            }
            return depth;
        }
        throw new HermesException("Cannot get the depth of a topic without a plugin.");
    }

    public void close() throws JMSException {
    }
}

