/*
 * Decompiled with CFR 0.152.
 */
package hermes.executor;

import hermes.executor.HermesExecutorListener;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.log4j.Logger;

public class HermesExecutor
extends ThreadPoolExecutor {
    private static final Logger log = Logger.getLogger(HermesExecutor.class);
    public static final int CORE_POOL_SIZE = 6;
    public static final int MINIMUM_POOL_SIZE = 6;
    public static final long KEEP_ALIVE_TIME = 30000L;
    public static final TimeUnit KEEP_ALIVE_TIME_UNIT = TimeUnit.MILLISECONDS;
    private List<HermesExecutorListener> listeners = new CopyOnWriteArrayList<HermesExecutorListener>();
    private Set<Thread> running = new HashSet<Thread>();

    public HermesExecutor() {
        super(6, 6, 30000L, KEEP_ALIVE_TIME_UNIT, new LinkedBlockingQueue<Runnable>());
    }

    public void addListener(HermesExecutorListener l) {
        this.listeners.add(l);
    }

    public void removeListener(HermesExecutorListener l) {
        this.listeners.remove(l);
    }

    protected void afterExecute(Runnable r, Throwable t) {
        super.afterExecute(r, t);
        for (HermesExecutorListener l : this.listeners) {
            if (this.getActiveCount() != 0) continue;
            l.onInactive();
        }
    }

    protected void beforeExecute(Thread t, Runnable r) {
        for (HermesExecutorListener l : this.listeners) {
            l.onActive();
        }
        super.beforeExecute(t, r);
        this.running.add(t);
    }
}

