/*
 * Decompiled with CFR 0.152.
 */
package hermes.browser.tasks;

import hermes.Hermes;
import hermes.SingletonManager;
import hermes.browser.HermesBrowser;
import hermes.browser.IconCache;
import hermes.browser.model.QueueWatchTableModel;
import hermes.browser.model.WatchInfo;
import hermes.browser.tasks.TaskSupport;
import hermes.impl.ClassLoaderManager;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.jms.JMSException;
import javax.naming.NamingException;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import org.apache.log4j.Logger;

public class DestinationWatchAction
extends TaskSupport {
    private static final Logger log = Logger.getLogger(DestinationWatchAction.class);
    private static final Set activeWatches = new HashSet();
    private QueueWatchTableModel watchModel;
    private String id;
    private JComponent forRepaint;

    public DestinationWatchAction(String id, JComponent forRepaint, QueueWatchTableModel watchModel) {
        super(IconCache.getIcon("hermes.watch"));
        this.watchModel = watchModel;
        this.id = id;
        this.forRepaint = forRepaint;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isDuplicate() {
        Set set = activeWatches;
        synchronized (set) {
            return activeWatches.contains(this.id);
        }
    }

    public String getTitle() {
        return "Watch updating " + this.id;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void invoke() throws Exception {
        Set set = activeWatches;
        synchronized (set) {
            if (activeWatches.contains(this.id)) {
                log.info((Object)("previous watch id=" + this.id + " still running, not starting timed action"));
                return;
            }
            activeWatches.add(this.id);
        }
        log.info((Object)("watch action for " + this.id + " starting"));
        try {
            HashMap<String, Hermes> hermesToClose = new HashMap<String, Hermes>();
            boolean localHasAlert = false;
            for (int i = 0; i < this.watchModel.getRowCount(); ++i) {
                boolean deleted = false;
                WatchInfo info = this.watchModel.getRow(i);
                try {
                    ClassLoaderManager classLoaderManager = (ClassLoaderManager)SingletonManager.get(ClassLoaderManager.class);
                    Thread.currentThread().setContextClassLoader(classLoaderManager.getClassLoaderByHermes(info.getHermesId()));
                    Hermes hermes = null;
                    if (!hermesToClose.keySet().contains(info.getHermesId())) {
                        hermes = (Hermes)HermesBrowser.getBrowser().getContext().lookup(info.getHermesId());
                        hermesToClose.put(info.getHermesId(), hermes);
                    } else {
                        hermes = (Hermes)hermesToClose.get(info.getHermesId());
                    }
                    if (this.updateWatchInfo(hermes, info)) {
                        localHasAlert = true;
                    }
                    info.setE(null);
                    continue;
                }
                catch (Throwable e) {
                    log.error((Object)e.getMessage(), e);
                    info.setE(e);
                }
            }
            for (Map.Entry entry : hermesToClose.entrySet()) {
                Hermes hermes = (Hermes)entry.getValue();
                try {
                    if (hermes == null) continue;
                    hermes.close();
                }
                catch (JMSException e1) {
                    log.error((Object)("closing " + hermes.getId() + ": " + e1.getMessage()), (Throwable)e1);
                }
            }
        }
        catch (Throwable t) {
            log.error((Object)t.getMessage(), t);
        }
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                DestinationWatchAction.this.forRepaint.repaint();
            }
        });
        log.debug((Object)("watch action for " + this.id + " finished"));
        set = activeWatches;
        synchronized (set) {
            activeWatches.remove(this.id);
        }
    }

    private boolean updateWatchInfo(Hermes hermes, WatchInfo info) throws JMSException, NamingException {
        log.debug((Object)("updating " + hermes.getId() + " " + info.getConfig().getName()));
        info.setDepth(hermes.getDepth(info.getConfig()));
        if (info.getDepth() > 0) {
            info.setOldest(hermes.getAge(info.getConfig()));
        } else {
            info.setOldest(0L);
        }
        info.setStatistics(hermes.getStatistics(info.getConfig()));
        return info.isInAlert();
    }
}

