/*
 * Decompiled with CFR 0.152.
 */
package hermes.browser.actions;

import com.jidesoft.document.DocumentComponentEvent;
import com.jidesoft.document.DocumentComponentListener;
import com.jidesoft.swing.JideScrollPane;
import com.jidesoft.swing.JideTabbedPane;
import hermes.browser.HermesBrowser;
import hermes.browser.IconCache;
import hermes.browser.actions.AbstractDocumentComponent;
import hermes.browser.tasks.Task;
import hermes.browser.tasks.TaskListener;
import hermes.fix.FIXException;
import hermes.fix.FIXMessage;
import hermes.fix.FIXMessageTable;
import hermes.fix.FIXUtils;
import hermes.swing.FilterablePanel;
import hermes.swing.SwingRunner;
import hermes.swing.SwingUtils;
import hermes.util.DumpUtils;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Font;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Timer;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextArea;
import javax.swing.border.EtchedBorder;
import javax.swing.event.ListSelectionEvent;
import org.apache.commons.collections.map.LRUMap;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractFIXBrowserDocumentComponent
extends AbstractDocumentComponent
implements DocumentComponentListener,
TaskListener {
    private static final Logger log = Logger.getLogger(AbstractFIXBrowserDocumentComponent.class);
    private final JLabel statusMessage = new JLabel();
    protected static final Timer timer = new Timer();
    private int screenUpdateTimeout = 100;
    private JPanel statusPanel;
    private JPanel topPanel;
    private boolean taskStopped = false;
    private String title;
    private Task task;
    private List<FIXMessage> cachedRows = new ArrayList<FIXMessage>();
    private JideTabbedPane messageTabbedPane = new JideTabbedPane();
    private JideScrollPane messagePayloadPanel = new JideScrollPane();
    private JideScrollPane headerScrollPane = new JideScrollPane();
    private final JPanel bottomPanel = new JPanel(new BorderLayout());
    private final Map<FIXMessage, JComponent> renderedLRUMap = new LRUMap(100);

    public abstract Collection<Object> getSelectedMessages();

    public AbstractFIXBrowserDocumentComponent(String title) {
        super(new JPanel(), title);
        this.title = title;
        this.topPanel = (JPanel)this.getComponent();
    }

    protected void setCachedRows(List<FIXMessage> cachedRows) {
        this.cachedRows = cachedRows;
    }

    protected Collection<FIXMessage> getCachedRows() {
        return this.cachedRows;
    }

    protected abstract Component getHeaderComponent();

    protected Component getBottomComponent() {
        return this.bottomPanel;
    }

    protected void updateMessageTabbedPane(FIXMessage m) {
        int index = this.getMessageTabbedPane().getSelectedIndex();
        this.getMessageTabbedPane().removeAll();
        this.getMessageTabbedPane().add("Parsed", (Component)this.getMessagePayloadPanel());
        this.getMessageTabbedPane().add("Hex", this.createHexPanel(m));
        this.getMessageTabbedPane().add("Text", this.createPrettyPrintPanel(m));
        if (index >= 0) {
            this.getMessageTabbedPane().setSelectedIndex(index);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addMessage(FIXMessage message) {
        List<FIXMessage> list = this.cachedRows;
        synchronized (list) {
            try {
                this.cachedRows.add(message);
            }
            catch (Exception ex) {
                log.error((Object)ex.getMessage(), (Throwable)ex);
            }
        }
    }

    protected void init() {
        this.headerScrollPane.getViewport().putClientProperty("HierarchicalTable.mainViewport", Boolean.TRUE);
        this.headerScrollPane.setViewportView(this.getHeaderComponent());
        this.bottomPanel.add((Component)new FilterablePanel(), "North");
        this.bottomPanel.add((Component)this.getStatusPanel(), "South");
        this.getTopPanel().setLayout(new BorderLayout());
        JSplitPane splitPane = new JSplitPane(0);
        splitPane.setDividerLocation(200);
        splitPane.setOneTouchExpandable(false);
        splitPane.setContinuousLayout(true);
        splitPane.add((Component)this.headerScrollPane, "top");
        splitPane.add((Component)this.messageTabbedPane, "bottom");
        this.messageTabbedPane.setTabPlacement(3);
        this.getTopPanel().add((Component)splitPane, "Center");
        this.getTopPanel().add(this.getBottomComponent(), "South");
        HermesBrowser.getBrowser().addDocumentComponent(this);
        this.addDocumentComponentListener(this);
        this.updateTableRows(true);
    }

    public void doSelectionChanged(FIXMessageTable table, ListSelectionEvent e) {
        int selectedRow = table.getSelectedRow();
        if (table.getRowCount() > selectedRow && selectedRow >= 0) {
            int row = selectedRow;
            FIXMessage m = table.getMessageAt(row);
            table.scrollRectToVisible(table.getCellRect(selectedRow, 0, true));
            try {
                if (!this.renderedLRUMap.containsKey(m)) {
                    JComponent rendered = FIXUtils.createView(m, true, true);
                    this.renderedLRUMap.put(m, rendered);
                }
                this.getMessagePayloadPanel().setViewportView((Component)this.renderedLRUMap.get(m));
            }
            catch (FIXException e1) {
                log.error((Object)e1.getMessage(), (Throwable)((Object)e1));
                JTextArea text = new JTextArea(e1.getMessage());
                text.setEditable(false);
                this.getMessagePayloadPanel().setViewportView((Component)text);
            }
            this.updateMessageTabbedPane(m);
        }
    }

    public JPanel getTopPanel() {
        return this.topPanel;
    }

    @Override
    public void onStarted(Task task) {
    }

    @Override
    public void onThrowable(Task task, Throwable t) {
    }

    @Override
    public void onStatus(Task task, final String status) {
        SwingRunner.invokeLater(new Runnable(){

            public void run() {
                AbstractFIXBrowserDocumentComponent.this.statusMessage.setText(status);
            }
        });
    }

    public boolean isTaskStopped() {
        return this.taskStopped;
    }

    protected abstract void updateTableRows(boolean var1);

    @Override
    public void onStopped(Task task) {
        this.updateTableRows(false);
        this.taskStopped = true;
    }

    public void setStatusText(String text) {
        this.statusMessage.setText(text);
    }

    protected void doClose() {
        if (this.task != null) {
            this.task.stop();
        }
        this.renderedLRUMap.clear();
    }

    public void documentComponentDocked(DocumentComponentEvent arg0) {
    }

    public void documentComponentFloated(DocumentComponentEvent arg0) {
    }

    public void documentComponentMoved(DocumentComponentEvent arg0) {
    }

    public void documentComponentMoving(DocumentComponentEvent arg0) {
    }

    public void documentComponentActivated(DocumentComponentEvent arg0) {
    }

    public void documentComponentClosed(DocumentComponentEvent arg0) {
        this.doClose();
    }

    public void documentComponentClosing(DocumentComponentEvent arg0) {
    }

    public void documentComponentDeactivated(DocumentComponentEvent arg0) {
    }

    public void documentComponentOpened(DocumentComponentEvent arg0) {
    }

    protected JPanel getStatusPanel() {
        if (this.statusPanel == null) {
            this.statusPanel = new JPanel();
            this.statusPanel.setLayout(new BorderLayout());
            this.statusPanel.setAlignmentY(1.0f);
            this.statusMessage.setText("Reading...");
            this.statusMessage.setBorder(new EtchedBorder());
            this.statusPanel.add(this.statusMessage);
        }
        return this.statusPanel;
    }

    public String getTooltip() {
        return this.getTitle();
    }

    public Icon getIcon() {
        return IconCache.getIcon("hermes.file.fix");
    }

    public void setTask(Task task) {
        this.task = task;
        task.addTaskListener(this);
    }

    public String getTitle() {
        return this.title;
    }

    public boolean isRunning() {
        return !this.taskStopped;
    }

    protected Component createPrettyPrintPanel(FIXMessage m) {
        JTextArea textArea = new JTextArea();
        textArea.setEditable(false);
        textArea.setFont(Font.decode("Monospaced-PLAIN-12"));
        Object bytes = null;
        try {
            textArea.setText(FIXUtils.prettyPrint(m));
        }
        catch (Throwable e) {
            textArea.setText(e.getMessage());
            log.error((Object)"exception converting message to byte[]: ", e);
        }
        textArea.setCaretPosition(0);
        return SwingUtils.createJScrollPane(textArea);
    }

    protected Component createHexPanel(FIXMessage m) {
        JTextArea textArea = new JTextArea();
        textArea.setEditable(false);
        textArea.setFont(Font.decode("Monospaced-PLAIN-12"));
        Object bytes = null;
        try {
            textArea.setText(DumpUtils.dumpBinary(m.getBytes(), 4));
        }
        catch (Throwable e) {
            textArea.setText(e.getMessage());
            log.error((Object)"exception converting message to byte[]: ", e);
        }
        textArea.setCaretPosition(0);
        JScrollPane scrollPane = new JScrollPane();
        scrollPane.setViewportView(textArea);
        return scrollPane;
    }

    public int getScreenUpdateTimeout() {
        return this.screenUpdateTimeout;
    }

    protected JideScrollPane getMessagePayloadPanel() {
        return this.messagePayloadPanel;
    }

    protected JideTabbedPane getMessageTabbedPane() {
        return this.messageTabbedPane;
    }
}

