/*
 * Decompiled with CFR 0.152.
 */
package hermes.browser;

import hermes.Hermes;
import hermes.browser.AbstractMessageFileIterator;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileReader;
import java.io.ObjectInputStream;
import java.io.Serializable;
import javax.jms.ObjectMessage;
import javax.jms.TextMessage;
import org.apache.log4j.Category;

public class SimpleMessageFileIterator
extends AbstractMessageFileIterator {
    private static final Category cat = Category.getInstance(SimpleMessageFileIterator.class);
    private boolean fileRead = false;

    public SimpleMessageFileIterator(Hermes hermes, File file) {
        super(hermes, file);
    }

    public boolean hasNext() {
        return !this.fileRead;
    }

    public Object next() {
        TextMessage message = null;
        try {
            BufferedReader reader = new BufferedReader(new FileReader(this.file));
            StringBuffer buffer = new StringBuffer();
            boolean inHeader = true;
            message = this.hermes.createTextMessage();
            try {
                String line;
                while (inHeader && (line = reader.readLine()) != null) {
                    if (line.startsWith("# ObjectMessage")) {
                        message = this.hermes.createObjectMessage();
                        continue;
                    }
                    if (line.startsWith("# TextMessage")) continue;
                    if (line.startsWith("# Properties")) {
                        inHeader = true;
                        continue;
                    }
                    if (line.startsWith("# Message")) {
                        inHeader = false;
                        continue;
                    }
                    if (!inHeader) continue;
                    String[] property = line.split("=");
                    message.setStringProperty(property[0], property[1]);
                }
                if (message instanceof TextMessage) {
                    while ((line = reader.readLine()) != null) {
                        buffer.append(line).append("\n");
                    }
                    message.setText(buffer.toString());
                }
                if (message instanceof ObjectMessage) {
                    while ((line = reader.readLine()) != null) {
                        buffer.append(line);
                    }
                    ByteArrayInputStream bistream = new ByteArrayInputStream(buffer.toString().getBytes());
                    ObjectInputStream oistream = new ObjectInputStream(bistream);
                    Object o = oistream.readObject();
                    ((ObjectMessage)message).setObject((Serializable)o);
                }
            }
            catch (Exception ex) {
                cat.error((Object)ex.getMessage(), (Throwable)ex);
            }
        }
        catch (Exception ex) {
            cat.error((Object)ex.getMessage(), (Throwable)ex);
        }
        this.fileRead = true;
        return message;
    }
}

