/*
 * Decompiled with CFR 0.152.
 */
package hermes;

import hermes.browser.IconCache;
import javax.jms.Destination;
import javax.jms.Queue;
import javax.jms.Topic;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.log4j.Logger;

public class Domain {
    private static final Logger log = Logger.getLogger(Domain.class);
    public static final Domain QUEUE = new Domain("QUEUE", 1, IconCache.getIcon("jms.queue"));
    public static final Domain TOPIC = new Domain("TOPIC", 2, IconCache.getIcon("jms.topic"));
    public static final Domain UNKNOWN = new Domain("UNKNOWN", 3, IconCache.getIcon("jms.queueOrTopic"));
    private String text;
    private int id;
    private Icon icon;

    Domain(String text, int id, ImageIcon icon) {
        this.text = text;
        this.id = id;
        this.icon = icon;
    }

    public Icon getIcon() {
        return this.icon;
    }

    public int getId() {
        return this.id;
    }

    public String toString() {
        return this.text;
    }

    public int hashCode() {
        return this.text.hashCode();
    }

    public boolean equals(Object other) {
        if (other instanceof Domain) {
            Domain d = (Domain)other;
            return d.getId() == this.id;
        }
        return false;
    }

    public static Domain getDomain(Destination destination) {
        if (destination instanceof Queue && destination instanceof Topic) {
            if (destination.getClass().getName().startsWith("weblogic.jms")) {
                try {
                    Boolean isTopic = (Boolean)PropertyUtils.getProperty((Object)destination, (String)"topic");
                    return isTopic != false ? TOPIC : QUEUE;
                }
                catch (Throwable e) {
                    log.error((Object)e.getMessage(), e);
                    return UNKNOWN;
                }
            }
            return UNKNOWN;
        }
        if (destination instanceof Queue) {
            return QUEUE;
        }
        return TOPIC;
    }

    public static Domain getDomain(int encoding) {
        if (encoding == 1) {
            return QUEUE;
        }
        if (encoding == 2) {
            return TOPIC;
        }
        return UNKNOWN;
    }
}

