/*
 * The JabaJaba class library
 *  Copyright (C) 1997-1999  ASAMI, Tomoharu (tasami@ibm.net)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

package jp.gr.java_conf.jaba2.xml.schema;

import org.w3c.dom.*;
import jp.gr.java_conf.jaba2.xml.*;

/**
 * Facets
 *
 * @since   Sep.  6, 1999
 * @version Sep.  6, 1999
 * @author  ASAMI, Tomoharu (tasami@ibm.net)
 */
public class Facets {
    protected Number minInclusive_;
    protected Number maxInclusive_;
    protected Number minExclusive_;
    protected Number maxExclusive_;
    protected Long precision_;
    protected Long scale_;
    protected Long length_;
    protected Long maxLength_;
    protected Literal[] enumeration_;
    protected String[] lexicalRepresentation_; // XXX : Lexical

    public Facets(Element element) {
	SmartElement se;
	if (element instanceof SmartElement) {
	    se = (SmartElement)element;
	} else {
	    se = new SmartElement(element);
	}
	minInclusive_ = se.getDataAsNumber("minInclusive");
	maxInclusive_ = se.getDataAsNumber("maxInclusive");
	minExclusive_ = se.getDataAsNumber("minExclusive");
	maxExclusive_ = se.getDataAsNumber("maxExclusive");
	precision_ = se.getDataAsLong("precision");
	scale_ = se.getDataAsLong("scale");
	length_ = se.getDataAsLong("length");
	maxLength_ = se.getDataAsLong("maxLength");
	enumeration_ = null;	// XXX
	lexicalRepresentation_ = null; // XXX
    }
}
