/*
 * The JabaJaba class library
 *  Copyright (C) 1997-2001  ASAMI, Tomoharu (asami@zeomtech.com)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

package jp.gr.java_conf.jaba2.xml.relax.raw;

import org.w3c.dom.*;
import jp.gr.java_conf.jaba2.text.UString;

/**
 * RElement
 *
 * @since   Dec. 24, 1999
 * @version Feb. 22, 2001
 * @author  ASAMI, Tomoharu (asami@zeomtech.com)
 */
public class RElement extends RNode {
    private String pattern_;
    private String name_;
    private String label_;
    private String type_;
    private String occurs_;

    public RElement(Element element) {
	super(element);
	pattern_ = UString.checkNull(element.getAttribute("role"));
	if (pattern_ == null) {
	    pattern_ = UString.checkNull(element.getAttribute("pred"));
	}
	name_ = UString.checkNull(element.getAttribute("name"));
	label_ = UString.checkNull(element.getAttribute("label"));
	type_ = UString.checkNull(element.getAttribute("type"));
	occurs_ = UString.checkNull(element.getAttribute("occurs"));
	if (pattern_ != null) {
	    throw (new InternalError()); // XXX
	}
    }

    public final String getPattern() {
	return (pattern_);
    }

    public final String getName() {
	return (name_);
    }

    public final String getLabel() {
	return (label_);
    }

    public final String getType() {
	return (type_);
    }

    public final String getOccurs() {
	return (occurs_);
    }
}
