/*
 * The JabaJaba class library
 *  Copyright (C) 1997-2001  ASAMI, Tomoharu (asami@zeomtech.com)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

package jp.gr.java_conf.jaba2.xml.relax.raw;

import java.util.*;
import org.w3c.dom.*;
import jp.gr.java_conf.jaba2.xml.SmartElement;

/**
 * RAttribute
 *
 * @since   Dec. 20, 1999
 * @version Mar. 12, 2001
 * @author  ASAMI, Tomoharu (asami@zeomtech.com)
 */
public class RAttribute extends RNode {
    private String name_;
    private String type_;
    private boolean required_;
    private String[] enumerations_;
    private String namespace_;

    public RAttribute(Element element) {
	super(element);
	SmartElement se = new SmartElement(element);
	name_ = se.getAttributeAsString("name");
	type_ = se.getAttributeAsString("type");
	required_ = se.getAttributeAsBoolean("required");
	if (name_ == null) {
	    throw (new RSyntaxErrorException("no name attribute"));
	}
	if (type_ == null) {
	    type_ = "string";
	}
	namespace_ = se.getAttributeAsString("namespace");
	Element[] enums = se.getElements("enumeration");
	List list = new ArrayList();
	for (int i = 0;i < enums.length;i++) {
	    String value = enums[i].getAttribute("value");
	    if (!"".equals(value)) {
		list.add(value);
	    }
	}
	enumerations_ = new String[list.size()];
	enumerations_ = (String[])list.toArray(enumerations_);
    }

    public final String getName() {
	return (name_);
    }

    public final String getType() {
	return (type_);
    }

    public final String[] getEnumerations() {
	return ((String[])enumerations_.clone());
    }

    public final boolean isRequired() {
	return (required_);
    }

    public final String getNamespace() {
	return (namespace_);
    }
}
