/*
 * The JabaJaba class library
 *  Copyright (C) 1997-2001  ASAMI, Tomoharu (asami@zeomtech.com)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

package jp.gr.java_conf.jaba2.xml.relax.expanded;

import java.util.*;
import org.w3c.dom.*;
import jp.gr.java_conf.jaba2.xml.relax.raw.*;
import jp.gr.java_conf.jaba2.xml.relax.cooked.*;

/**
 * UERule
 *
 * @since   Jan.  2, 2000
 * @version Apr.  6, 2001
 * @author  ASAMI, Tomoharu (asami@zeomtech.com)
 */
public final class UERule implements IEOccurs {
    public static ERelax buildModel(CRelax crelax) {
	return (new ERelax(crelax));
    }

    public static String getOccursSymbol(int occurs) {
	switch (occurs) {

	case OCCURS_ONE:
	    return ("");
	case OCCURS_ZEROONE:
	    return ("?");
	case OCCURS_ONEMORE:
	    return ("+");
	case OCCURS_ZEROMORE:
	    return ("*");
	default:
	    throw (new InternalError());
	}
    }

    public static int getOccurs(COccurs occurs) {
	// assume same integer value
	return (occurs.getType());
    }

    public static boolean canUnification(int parent, int child) {
	if (parent == OCCURS_ZEROMORE) {
	    return (true);
	}
	if (parent == OCCURS_ONEMORE) {
	    return (child == OCCURS_ONE || child == OCCURS_ONEMORE);
	}
	if (parent == OCCURS_ZEROONE) {
	    return (child == OCCURS_ONE || child == OCCURS_ZEROONE);
	}
	if (parent == OCCURS_ONE) {
	    return (child == OCCURS_ONE);
	}
	throw (new InternalError());
    }

    public static int unifyOccurs(int lhs, int rhs) {
	if (lhs == OCCURS_ZEROMORE || rhs == OCCURS_ZEROMORE) {
	    return (OCCURS_ZEROMORE);
	}
	if (lhs == rhs) {
	    return (lhs);
	}
	if (lhs == OCCURS_ONEMORE) {
	    if (rhs == OCCURS_ONE) {
		return (OCCURS_ONEMORE);
	    } else if (rhs == OCCURS_ZEROONE) {
		return (OCCURS_ZEROMORE);
	    } else {
		throw (new InternalError());
	    }
	} else if (lhs == OCCURS_ZEROONE) {
	    if (rhs == OCCURS_ONE) {
		return (OCCURS_ZEROONE);
	    } else if (rhs == OCCURS_ONEMORE) {
		return (OCCURS_ZEROMORE);
	    } else {
		throw (new InternalError());
	    }
	} else if (lhs == OCCURS_ONE) {
	    if (rhs == OCCURS_ZEROONE) {
		return (OCCURS_ZEROONE);
	    } else if (rhs == OCCURS_ONEMORE) {
		return (OCCURS_ONEMORE);
	    } else {
		throw (new InternalError());
	    }
	} else {
	    throw (new InternalError());
	}
    }

    public static boolean hasChildChoice(ENode node) {
	ENode[] children = node.getChildren();
	for (int i = 0;i < children.length;i++) {
	    if (children[i] instanceof EChoiceNode) {
		return (true);
	    }
	    hasChildChoice(children[i]);
	}
	return (false);
    }

    public static boolean hasChoiceParent(ENode node) {
	ENode parent = node.getParent();
	for (;;) {
	    if (parent == null) {
		return (false);
	    }
	    if (parent instanceof ERuleNode) {
		return (false);
	    }
	    if (parent instanceof EChoiceNode ||
		parent instanceof EMixedNode) {

		return (true);
	    }
	    parent = parent.getParent();
	}
    }

    // test driver
    public static void main(String[] args) throws Exception {
	java.net.URL url
	    = jp.gr.java_conf.jaba2.io.UURL.getURLFromFileOrURLName(args[0]);
	jp.gr.java_conf.jaba2.xml.IProcessor processor
	    = jp.gr.java_conf.jaba2.xml.ProcessorFactory.getProcessor();
	Document doc = processor.parseValidDocument(url);
	RRelax rrelax = URRelax.buildModel(doc);
	CRelax crelax = UCRelax.buildModel(rrelax);
	ERelax erelax = UERule.buildModel(crelax);
	EModule[] emodules = erelax.getModules();
	for (int i = 0;i < emodules.length;i++) {
	    _print(emodules[i]);
	}
    }

    private static void _print(EModule emodule) {
	ERuleNode[] rules = emodule.getRootRules();
	System.out.println("[result]");
	for (int i = 0;i < rules.length;i++) {
	    System.out.println(rules[i]);
	}
	System.out.println("[elementRules]");
	rules = emodule.getElementRules();
	for (int i = 0;i < rules.length;i++) {
	    System.out.println(rules[i]);
	}
	System.out.println("[contentRules]");
	rules = emodule.getContentRules();
	for (int i = 0;i < rules.length;i++) {
	    System.out.println(rules[i]);
	}
    }
}
