/*
 * The JabaJaba class library
 *  Copyright (C) 1997-2000  ASAMI, Tomoharu (asami@zeomtech.com)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

package jp.gr.java_conf.jaba2.xml.relax.expanded;

import java.util.*;
import org.w3c.dom.*;
import jp.gr.java_conf.jaba2.datatype.IXMLDatatype;
import jp.gr.java_conf.jaba2.xml.relax.cooked.*;

/**
 * EElementNode
 *
 * @since   Jan.  6, 2000
 * @version Dec. 13, 2000
 * @author  ASAMI, Tomoharu (asami@zeomtech.com)
 */
public class EElementNode extends ERuleNode {
    private String elementName_;
//    private String typeName_ = null;
    private IXMLDatatype datatype_;

    public EElementNode(String tagName) {
	this(tagName, "unknown");
    }

    public EElementNode(String tagName, String label) {
	super("element", label);
	elementName_ = tagName;
	setAttribute("tag", tagName); // info
	setAttribute("id", "element" + getId());
    }

    public final String getElementName() {
	return (elementName_);
    }

/*
    public final void setTypeName(String name) {
	typeName_ = name;
	setAttribute("type", name);
    }

    public final String getTypeName() {
	return (typeName_);
    }
*/

    public final void setDatatype(IXMLDatatype datatype) {
	datatype_ = datatype;
	setAttribute("type", datatype.getName());
    }

    public final IXMLDatatype getDatatype() {
	return (datatype_);
    }

    public boolean enter(IEVisitor visitor) {
	return (visitor.enter(this));
    }

    public void leave(IEVisitor visitor) {
	visitor.leave(this);
    }
}
