/*
 * The JabaJaba class library
 *  Copyright (C) 1997-2001  ASAMI, Tomoharu (asami@zeomtech.com)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

package jp.gr.java_conf.jaba2.xml.relax.expanded;

import java.util.*;
import org.w3c.dom.*;
import jp.gr.java_conf.jaba2.xml.relax.cooked.*;

/**
 * EChoiceNode
 *
 * @since   Jan.  6, 2000
 * @version Mar.  9, 2001
 * @author  ASAMI, Tomoharu (asami@zeomtech.com)
 */
public class EChoiceNode extends ENode implements IEOccurs {
    private int occurs_;
    private boolean isConflict_ = false; // XXX
    private EChoiceNode origin_;

    public EChoiceNode() {
	this(OCCURS_ONE);
    }

    public EChoiceNode(int occurs) {
	super("choice");
	if (occurs != OCCURS_ONE &&
	    occurs != OCCURS_ZEROONE &&
	    occurs != OCCURS_ONEMORE &&
	    occurs != OCCURS_ZEROMORE) {

	    throw (new InternalError());
	}
	occurs_ = occurs;
	origin_ = this;
	setAttribute("occurs", UERule.getOccursSymbol(occurs));
    }

    public EChoiceNode(EChoiceNode chNode) {
	super(chNode);
	occurs_ = chNode.occurs_;
	isConflict_ = chNode.isConflict_;
	origin_ = chNode.origin_;
	setAttribute("occurs", UERule.getOccursSymbol(occurs_));
	addChildrenDeep(chNode);
    }

    public final int getOccurs() {
	return (occurs_);
    }

    public final void setOccurs(int occurs) {
	occurs_ = occurs;
    }

    public final boolean isConflict() {
	return (isConflict_);
    }

    public final void setConflict(boolean conflict) {
	isConflict_ = conflict;
    }

    public final EChoiceNode getOrigin() {
	return (origin_);
    }

    public boolean enter(IEVisitor visitor) {
	return (visitor.enter(this));
    }

    public void leave(IEVisitor visitor) {
	visitor.leave(this);
    }
}
