/*
 * The JabaJaba class library
 *  Copyright (C) 1997-2001  ASAMI, Tomoharu (asami@zeomtech.com)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

package jp.gr.java_conf.jaba2.xml.relax.cooked;

import java.util.*;
import org.w3c.dom.*;
import jp.gr.java_conf.jaba2.xml.datatype.*;
import jp.gr.java_conf.jaba2.xml.relax.raw.RAnyOtherAttribute;

/**
 * CAnyOtherAttribute
 *
 * @since   Mar. 10, 2001
 * @version Aug. 29, 2001
 * @author  ASAMI, Tomoharu (asami@zeomtech.com)
 */
public class CAnyOtherAttribute extends CNode implements ICPatternContent {
    private String[] includeNamespaces_;
    private String[] excludeNamespaces_;

    public CAnyOtherAttribute(RAnyOtherAttribute rany, CModule module) {
	super(rany);
	includeNamespaces_ = rany.getIncludeNamespaces();
	excludeNamespaces_ = rany.getExcludeNamespaces();
    }

    public final String[] getIncludeNamespaces() {
	return (includeNamespaces_);
    }

    public final String[] getExcludeNamespaces() {
	return (excludeNamespaces_);
    }
}
