/*
 * The JabaJaba class library
 *  Copyright (C) 1997-2000  ASAMI, Tomoharu (asami@zeomtech.com)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

package jp.gr.java_conf.jaba2.xml.processor;

import org.xml.sax.*;
import jp.gr.java_conf.jaba2.xml.IProcessor;
import jp.gr.java_conf.jaba2.xml.sax.SimpleErrorHandler;
import jp.gr.java_conf.jaba2.xml.sax.SimpleEntityResolver;

/**
 * AbstractProcessor
 *
 * @since   Aug. 12, 2000
 * @version Aug. 15, 2000
 * @author  ASAMI, Tomoharu (asami@zeomtech.com)
 */
public abstract class AbstractProcessor implements IProcessor {
    private ErrorHandler errorHandler_;
    private EntityResolver entityResolver_;

    protected AbstractProcessor() {
	errorHandler_ = new SimpleErrorHandler();
    }

    public final void setErrorHandler(ErrorHandler handler) {
	errorHandler_ = handler;
    }

    public final ErrorHandler getErrorHandler() {
	return (errorHandler_);
    }

    public final void setEntityResolver(EntityResolver handler) {
	entityResolver_ = handler;
    }

    public final EntityResolver getEntityResolver() {
	return (entityResolver_);
    }
}
