/*
 * The JabaJaba class library
 *  Copyright (C) 1997-1999  ASAMI, Tomoharu (tasami@ibm.net)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

package jp.gr.java_conf.jaba2.xml.pdom;

import java.util.*;
import java.io.IOException;
import java.io.StringReader;
import java.net.URL;
import org.w3c.dom.*;
import com.ibm.xml.parser.Parser;

/**
 * The XML4JPDOMFactory is a Factory to generate PDOM objects using
 * the IBM XML for Java DOM parser.
 *
 * @since   Apr. 24, 1998
 * @version Sep. 15, 1999
 + @author  ASAMI, Tomoharu (tasami@ibm.net)
 */
public class XML4JPDOMFactory extends AbstractPDOMFactory {
    public PDocument generateDoc(URL url) throws IOException {
	Parser parser = new Parser(url.toString());
	Document doc = parser.readStream(url.openStream());
	return (_generatePDocument(doc));
    }

    public PDocumentType generateDTD(URL url) throws IOException {
	Parser parser = new Parser(url.toString());
	DocumentType dtd = parser.readDTDStream(url.openStream());
	return (_generatePDocumentType(dtd));
    }

    public PDocument generateDoc(String text) {
	Parser parser = new Parser("text");
	Document doc = parser.readStream(new StringReader(text));
	return (_generatePDocument(doc));
    }

    public PDocumentType generateDTD(String text) {
	try {
	    Parser parser = new Parser("text");
	    DocumentType dtd = parser.readDTDStream(new StringReader(text));
	    return (_generatePDocumentType(dtd));
	} catch (IOException e) {
	    throw (new InternalError(e.toString()));
	}
    }
}
