/*
 * The JabaJaba class library
 *  Copyright (C) 1997-2000  ASAMI, Tomoharu (tasami@ibm.net)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

package jp.gr.java_conf.jaba2.vfs.filter;

import jp.gr.java_conf.jaba2.text.UString;
import jp.gr.java_conf.jaba2.vfs.*;

/**
 * DirFilter
 *
 * @since   Feb.  8, 2000
 * @version Feb.  8, 2000
 * @author  ASAMI, Tomoharu (tasami@ibm.net)
 */
public class DirFilter implements IFilter {
    private String[] dirs_;

    public DirFilter(String dir) {
	dirs_ = new String[] { dir };
    }

    public DirFilter(String[] dirs) {
	dirs_ = new String[dirs.length];
	System.arraycopy(dirs, 0, dirs_, 0, dirs.length);
    }

    public boolean isMatch(IVFSNode node) {
	String name = node.getPathname();
	for (int i = 0;i < dirs_.length;i++) {
	    if (name.startsWith(dirs_[i])) {
		return (true);
	    }
	}
	return (false);
    }
}
