/*
 * The JabaJaba class library
 *  Copyright (C) 1997-2000  ASAMI, Tomoharu (asami@zeomtech.com)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

package jp.gr.java_conf.jaba2.parcel;

import java.io.OutputStream;
import java.io.IOException;
import org.xml.sax.SAXException;
import org.w3c.dom.Document;

/**
 * TextGadget
 *
 * @since   Aug. 24, 2000
 * @version Aug. 24, 2000
 * @author  ASAMI, Tomoharu (asami@zeomtech.com)
 */
public class TextGadget extends AbstractGadget {
    private String text_;

    public TextGadget() {
	setEncoding("UTF-8");
    }

    public final void setText(String text) {
	text_ = text;
    }

    public final String getText() {
	return (text_);
    }

    public void write(OutputStream out) throws IOException {
	out.write(getBytes());
    }

    public byte[] getBytes() throws IOException {
	return (text_.getBytes(getEncoding()));
    }
}
