/*
 * The JabaJaba class library
 *  Copyright (C) 1997-2000  ASAMI, Tomoharu (asami@zeomtech.com)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

package jp.gr.java_conf.jaba2.jmodel.beans;

import java.util.*;
import jp.gr.java_conf.jaba2.util.ArrayMap;
import jp.gr.java_conf.jaba2.jmodel.lang.*;

/**
 * BJBeans
 *
 * @since   Jan. 18, 2000
 * @version Jul. 19, 2001
 * @author  ASAMI, Tomoharu (asami@zeomtech.com)
 */
public class BJBean extends LJClass {
    private Map properties_ = new ArrayMap(); // Map<String, BJProperty>
    private boolean isPropertyChange_;
    private boolean isVetoableChange_;

    public BJBean(String name) {
	super(name, ACCESS_PUBLIC);
    }

    public void addProperty(BJProperty property) {
	String name = property.getName();
	if (properties_.get(name) != null) {
	    throw (new InternalError());
	}
	properties_.put(name, property);
    }

    public final BJProperty[] getProperties() {
	Collection values = properties_.values();
	BJProperty[] properties = new BJProperty[values.size()];
	return ((BJProperty[])values.toArray(properties));
    }

    public final boolean isPropertyChange() {
	return (isPropertyChange_);
    }

    public final void setPropertyChange(boolean isPropertyChange) {
	isPropertyChange_ = isPropertyChange;
    }

    public final boolean isVetoableChange() {
	return (isVetoableChange_);
    }

    public final void setVetoableChange(boolean isVetoableChange) {
	isVetoableChange_ = isVetoableChange;
    }
}

