/*
 * The JabaJaba class library
 *  Copyright (C) 1997-2000  ASAMI, Tomoharu (asami@zeomtech.com)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

package jp.gr.java_conf.jaba2.dombus.importer;

import java.util.*;
import java.io.IOException;
import jp.gr.java_conf.jaba2.text.UString;
import jp.gr.java_conf.jaba2.parcel.IParcel;
import jp.gr.java_conf.jaba2.dombus.*;

/**
 * DOMBusGeneratorController
 *
 * @since   Aug. 29, 2000
 * @version Sep. 12, 2000
 * @author  ASAMI, Tomoharu (asami@zeomtech.com)
 */
public class DOMBusImporterController extends AbstractDOMBusComponent {
    IDOMBusImporter[] importers_;

    public boolean init() {
	IDOMBusParameter param = context_.getParameter();
	String[] importerNames = param.getParameterAsStringList("importer");
	IDOMBusComponent[] components
	    = bus_.getComponents(IDOMBusImporter.class);
	List list = new ArrayList();
	for (int i = 0;i < components.length;i++) {
	    IDOMBusImporter importer = (IDOMBusImporter)components[i];
	    if (UString.compareList(importer.getID(), importerNames)) {
		list.add(importer);
	    }
	}
	importers_ = new IDOMBusImporter[list.size()];
	importers_ = (IDOMBusImporter[])list.toArray(importers_);
	return (false);
    }

    public Object fire(DOMBusSignal signal) {
	try {
	    IParcel parcel = (IParcel)signal.getContent();
	    for (int i = 0;i < importers_.length;i++) {
		IDOMBusImporter importer = importers_[i];
		if (importer.canImport(parcel)) {
		    IParcel result = importer.importData(parcel);
		    return (result);
		}
	    }
	    for (int i = 0;i < importers_.length;i++) {
		IDOMBusImporter importer = importers_[i];
		if (importer.couldImport(parcel)) {
		    IParcel result = importer.importData(parcel);
		    return (result);
		}
	    }
	    return (null);
	} catch (IOException e) {
	    throw (new DOMBusException(e));
	}
    }
}
