/*
 * The JabaJaba class library
 *  Copyright (C) 1997-2000  ASAMI, Tomoharu (asami@zeomtech.com)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

package jp.gr.java_conf.jaba2.dombus.generator;

import jp.gr.java_conf.jaba2.parcel.IParcel;
import jp.gr.java_conf.jaba2.type.IPowerType;
import jp.gr.java_conf.jaba2.type.ClassPowerType;
import jp.gr.java_conf.jaba2.dombus.DOMBusException;
import jp.gr.java_conf.jaba2.dombus.AbstractDOMBusComponent;

/**
 * AbstractDOMBusGenerator
 *
 * @since   Aug. 24, 2000
 * @version Nov. 16, 2000
 * @author  ASAMI, Tomoharu (asami@zeomtech.com)
 */
public abstract class AbstractDOMBusGenerator
    extends AbstractDOMBusComponent implements IDOMBusGenerator {

    public IPowerType[] getInputTypes() {
	return (new IPowerType[] { new ClassPowerType(IParcel.class) } );
    }

    public IPowerType getOutputType() {
	return (new ClassPowerType(IParcel.class));
    }
}
