package jp.gr.java_conf.jaba2.dombus.configRelaxer;

import org.w3c.dom.*;

/**
 * <b>CSlot</b> is generated by Relaxer based on ConfigFile.rlx.
 * This class is derived from:
 * 
 * <!-- for programmer
 * <elementRule role="slot">
 *   <sequence>
 *     <ref label="guard"/>
 *     <ref label="post" occurs="?"/>
 *     <ref label="component"/>
 *     <ref label="contextRef" occurs="?"/>
 *   </sequence>
 * </elementRule>
 * 
 * <tag name="slot">
 *   <attribute java:default="false" name="multiThread" type="boolean"/>
 * </tag>
 * -->
 * <!-- for javadoc -->
 * <pre> &lt;elementRule role="slot"&gt;
 *   &lt;sequence&gt;
 *     &lt;ref label="guard"/&gt;
 *     &lt;ref label="post" occurs="?"/&gt;
 *     &lt;ref label="component"/&gt;
 *     &lt;ref label="contextRef" occurs="?"/&gt;
 *   &lt;/sequence&gt;
 * &lt;/elementRule&gt;
 * &lt;tag name="slot"&gt;
 *   &lt;attribute java:default="false" name="multiThread" type="boolean"/&gt;
 * &lt;/tag&gt;
 * </pre>
 *
 * @version ConfigFile.rlx (Tue Aug 29 11:45:15 JST 2000)
 * @author  Relaxer 0.10.2b (by ASAMI@Yokohama)
 */
public class CSlot implements java.io.Serializable {
    private Boolean multiThread;
    private CGuard guard;
    private CPost post;
    private CComponent component;
    private CContextRef contextRef;

    /**
     * Creates a <code>CSlot</code>.
     *
     */
    public CSlot() {
    }

    /**
     * Creates a <code>CSlot</code> by the Stack <code>stack</code>
     * that contains Elements.
     * This constructor is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     */
    public CSlot(RStack stack) {
        setup(stack);
    }

    /**
     * Creates a <code>CSlot</code> by the Document <code>doc</code>.
     *
     * @param doc
     */
    public CSlot(Document doc) {
        setup(doc.getDocumentElement());
    }

    /**
     * Creates a <code>CSlot</code> by the Element <code>element</code>.
     *
     * @param element
     */
    public CSlot(Element element) {
        setup(element);
    }

    /**
     * Initializes the <code>CSlot</code> by the Document <code>doc</code>.
     *
     * @param doc
     */
    public void setup(Document doc) {
        setup(doc.getDocumentElement());
    }

    /**
     * Initializes the <code>CSlot</code> by the Element <code>element</code>.
     *
     * @param element
     */
    public void setup(Element element) {
        init(element);
    }

    /**
     * Initializes the <code>CSlot</code> by the Stack <code>stack</code>
     * that contains Elements.
     * This constructor is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     */
    public void setup(RStack stack) {
        setup(stack.popElement());
    }

    /**
     * @param element
     */
    private void init(Element element) {
        IConfigFileFactory factory = ConfigFileFactory.getFactory();
        RStack stack = new RStack(element);
        multiThread = URelaxer.getAttributePropertyAsBooleanObject(element, "multiThread");
        setGuard(factory.createCGuard(stack));
        if (CPost.isMatch(stack)) {
            setPost(factory.createCPost(stack));
        }
        setComponent(factory.createCComponent(stack));
        if (CContextRef.isMatch(stack)) {
            setContextRef(factory.createCContextRef(stack));
        }
    }

    /**
     * Creates a DOM representation of the object.
     * Result is appended to the Node <code>parent</code>.
     *
     * @param parent
     */
    public void makeElement(Node parent) {
        Document doc;
        if (parent instanceof Document) {
            doc = (Document)parent;
        } else {
            doc = parent.getOwnerDocument();
        }
        Element element = doc.createElement("slot");
        int size;
        if (multiThread != null) {
            URelaxer.setAttributePropertyByBoolean(element, "multiThread", multiThread);
        }
        guard.makeElement(element);
        if (post != null) {
            post.makeElement(element);
        }
        component.makeElement(element);
        if (contextRef != null) {
            contextRef.makeElement(element);
        }
        parent.appendChild(element);
    }

    /**
     * Gets the boolean property <b>multiThread</b>.
     *
     * @exception IllegalStateException
     * @return boolean
     */
    public boolean getMultiThread() throws IllegalStateException {
        if (multiThread == null) {
            return(false);
        }
        return (multiThread.booleanValue());
    }

    /**
     * Check the boolean property <b>multiThread</b>.
     *
     * @return boolean
     */
    public boolean checkMultiThread() {
        return (multiThread != null);
    }

    /**
     * Sets the boolean property <b>multiThread</b>.
     *
     * @param multiThread
     */
    public void setMultiThread(boolean multiThread) {
        this.multiThread = new Boolean(multiThread);
    }

    /**
     * Gets the CGuard property <b>guard</b>.
     *
     * @return CGuard
     */
    public final CGuard getGuard() {
        return (guard);
    }

    /**
     * Sets the CGuard property <b>guard</b>.
     *
     * @param guard
     */
    public final void setGuard(CGuard guard) {
        this.guard = guard;
    }

    /**
     * Gets the CPost property <b>post</b>.
     *
     * @return CPost
     */
    public final CPost getPost() {
        return (post);
    }

    /**
     * Sets the CPost property <b>post</b>.
     *
     * @param post
     */
    public final void setPost(CPost post) {
        this.post = post;
    }

    /**
     * Gets the CComponent property <b>component</b>.
     *
     * @return CComponent
     */
    public final CComponent getComponent() {
        return (component);
    }

    /**
     * Sets the CComponent property <b>component</b>.
     *
     * @param component
     */
    public final void setComponent(CComponent component) {
        this.component = component;
    }

    /**
     * Gets the CContextRef property <b>contextRef</b>.
     *
     * @return CContextRef
     */
    public final CContextRef getContextRef() {
        return (contextRef);
    }

    /**
     * Sets the CContextRef property <b>contextRef</b>.
     *
     * @param contextRef
     */
    public final void setContextRef(CContextRef contextRef) {
        this.contextRef = contextRef;
    }

    /**
     * Tests if a Element <code>element</code> is valid
     * for the <code>CSlot</code>.
     *
     * @param element
     * @return boolean
     */
    public static boolean isMatch(Element element) {
        String tagName = element.getTagName();
        if (!"slot".equals(tagName)) {
            return (false);
        }
        RStack target = new RStack(element);
        Element child;
        if (!CGuard.isMatchHungry(target)) {
            return (false);
        }
        if (CPost.isMatchHungry(target)) {
        }
        if (!CComponent.isMatchHungry(target)) {
            return (false);
        }
        if (CContextRef.isMatchHungry(target)) {
        }
        if (!target.isEmptyElement()) {
            return (false);
        }
        return (true);
    }

    /**
     * Tests if elements contained in a Stack <code>stack</code>
     * is valid for the <code>CSlot</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     * @return boolean
     */
    public static boolean isMatch(RStack stack) {
        Element element = stack.peekElement();
        if (element == null) {
            return (false);
        }
        return (isMatch(element));
    }

    /**
     * Tests if elements contained in a Stack <code>stack</code>
     * is valid for the <code>CSlot</code>.
     * This method consumes the stack contents during matching operation.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     * @return boolean
     */
    public static boolean isMatchHungry(RStack stack) {
        Element element = stack.peekElement();
        if (element == null) {
            return (false);
        }
        if (isMatch(element)) {
            stack.popElement();
            return (true);
        } else {
            return (false);
        }
    }
}
