package jp.gr.java_conf.jaba2.dombus.configRelaxer;

import org.w3c.dom.*;

/**
 * <b>CClass</b> is generated by Relaxer based on ConfigFile.rlx.
 * This class is derived from:
 * 
 * <!-- for programmer
 * <elementRule role="class">
 *   <sequence/>
 * </elementRule>
 * 
 * <tag name="class">
 *   <attribute name="name" required="true" type="string"/>
 *   <attribute name="classpath" type="string"/>
 * </tag>
 * -->
 * <!-- for javadoc -->
 * <pre> &lt;elementRule role="class"&gt;
 *   &lt;sequence/&gt;
 * &lt;/elementRule&gt;
 * &lt;tag name="class"&gt;
 *   &lt;attribute name="name" required="true" type="string"/&gt;
 *   &lt;attribute name="classpath" type="string"/&gt;
 * &lt;/tag&gt;
 * </pre>
 *
 * @version ConfigFile.rlx (Tue Aug 29 11:45:14 JST 2000)
 * @author  Relaxer 0.10.2b (by ASAMI@Yokohama)
 */
public class CClass implements java.io.Serializable {
    private String name;
    private String classpath;

    /**
     * Creates a <code>CClass</code>.
     *
     */
    public CClass() {
    }

    /**
     * Creates a <code>CClass</code> by the Stack <code>stack</code>
     * that contains Elements.
     * This constructor is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     */
    public CClass(RStack stack) {
        setup(stack);
    }

    /**
     * Creates a <code>CClass</code> by the Document <code>doc</code>.
     *
     * @param doc
     */
    public CClass(Document doc) {
        setup(doc.getDocumentElement());
    }

    /**
     * Creates a <code>CClass</code> by the Element <code>element</code>.
     *
     * @param element
     */
    public CClass(Element element) {
        setup(element);
    }

    /**
     * Initializes the <code>CClass</code> by the Document <code>doc</code>.
     *
     * @param doc
     */
    public void setup(Document doc) {
        setup(doc.getDocumentElement());
    }

    /**
     * Initializes the <code>CClass</code> by the Element <code>element</code>.
     *
     * @param element
     */
    public void setup(Element element) {
        init(element);
    }

    /**
     * Initializes the <code>CClass</code> by the Stack <code>stack</code>
     * that contains Elements.
     * This constructor is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     */
    public void setup(RStack stack) {
        setup(stack.popElement());
    }

    /**
     * @param element
     */
    private void init(Element element) {
        IConfigFileFactory factory = ConfigFileFactory.getFactory();
        RStack stack = new RStack(element);
        name = URelaxer.getAttributePropertyAsString(element, "name");
        classpath = URelaxer.getAttributePropertyAsString(element, "classpath");
    }

    /**
     * Creates a DOM representation of the object.
     * Result is appended to the Node <code>parent</code>.
     *
     * @param parent
     */
    public void makeElement(Node parent) {
        Document doc;
        if (parent instanceof Document) {
            doc = (Document)parent;
        } else {
            doc = parent.getOwnerDocument();
        }
        Element element = doc.createElement("class");
        int size;
        URelaxer.setAttributePropertyByString(element, "name", name);
        if (classpath != null) {
            URelaxer.setAttributePropertyByString(element, "classpath", classpath);
        }
        parent.appendChild(element);
    }

    /**
     * Gets the String property <b>name</b>.
     *
     * @return String
     */
    public final String getName() {
        return (name);
    }

    /**
     * Sets the String property <b>name</b>.
     *
     * @param name
     */
    public final void setName(String name) {
        this.name = name;
    }

    /**
     * Gets the String property <b>classpath</b>.
     *
     * @return String
     */
    public final String getClasspath() {
        return (classpath);
    }

    /**
     * Sets the String property <b>classpath</b>.
     *
     * @param classpath
     */
    public final void setClasspath(String classpath) {
        this.classpath = classpath;
    }

    /**
     * Tests if a Element <code>element</code> is valid
     * for the <code>CClass</code>.
     *
     * @param element
     * @return boolean
     */
    public static boolean isMatch(Element element) {
        String tagName = element.getTagName();
        if (!"class".equals(tagName)) {
            return (false);
        }
        RStack target = new RStack(element);
        Element child;
        if (!target.isEmptyElement()) {
            return (false);
        }
        return (true);
    }

    /**
     * Tests if elements contained in a Stack <code>stack</code>
     * is valid for the <code>CClass</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     * @return boolean
     */
    public static boolean isMatch(RStack stack) {
        Element element = stack.peekElement();
        if (element == null) {
            return (false);
        }
        return (isMatch(element));
    }

    /**
     * Tests if elements contained in a Stack <code>stack</code>
     * is valid for the <code>CClass</code>.
     * This method consumes the stack contents during matching operation.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     * @return boolean
     */
    public static boolean isMatchHungry(RStack stack) {
        Element element = stack.peekElement();
        if (element == null) {
            return (false);
        }
        if (isMatch(element)) {
            stack.popElement();
            return (true);
        } else {
            return (false);
        }
    }
}
