/*
 * The JabaJaba class library
 *  Copyright (C) 1997-2000  ASAMI, Tomoharu (asami@zeomtech.com)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

package jp.gr.java_conf.jaba2.dombus;

import java.io.*;

/**
 * DOMBusMonitor
 *
 * @since   Mar. 27, 2000
 * @version Apr. 29, 2000
 * @author  ASAMI, Tomoharu (asami@zeomtech.com)
 */
public class DOMBusMonitor extends AbstractDOMBusComponent {
    public static final int LEVEL_NONE = 0;
    public static final int LEVEL_ERROR = 1;
    public static final int LEVEL_WARNING = 2;
    public static final int LEVEL_INFO = 3;
    public static final int LEVEL_VERBOSE = 4;
    public static final int LEVEL_DEBUG = 5;

    private int consoleLevel_ = LEVEL_WARNING;
    private PrintWriter console_;

    // Object
    public String toString() {
	return ("DOMBusMonitor");
    }

    public void setup(String[] args) {
	console_ = new PrintWriter(System.out, true);
	for (int i = 0;i < args.length;i++) {
	    String arg = args[i];
	    if ("-none".equals(args)) {
		consoleLevel_ = LEVEL_NONE;
	    } else if ("-error".equals(arg)) {
		consoleLevel_ = LEVEL_ERROR;
	    } else if ("-warning".equals(arg)) {
		consoleLevel_ = LEVEL_WARNING;
	    } else if ("-info".equals(arg)) {
		consoleLevel_ = LEVEL_INFO;
	    } else if ("-verbose".equals(arg)) {
		consoleLevel_ = LEVEL_VERBOSE;
	    } else if ("-debug".equals(arg)) {
		consoleLevel_ = LEVEL_DEBUG;
	    }
	}
    }

    public Object fire(DOMBusSignal signal) {
	String label = signal.getLabel();
	if ("info".equals(label)) {
	    info(signal.getContent().toString());
	} else if ("verbose".equals(label)) {
	    verbose(signal.getContent().toString());
	} else if ("warning".equals(label)) {
	    warning(signal.getContent().toString());
	} else if ("error".equals(label)) {
	    error(signal.getContent().toString());
	} else if ("debug".equals(label)) {
	    debug(signal.getContent().toString());
	}
	return (null);
    }

    public final void setConsole(PrintWriter console) {
	console_ = console;
    }

    public final void setConsoleLevel(int level) {
	consoleLevel_ = level;
    }

    public void print(String message) {
	console_.print(message);
    }

    public void println(String message) {
	console_.println(message);
	console_.flush();
    }

    public void println() {
	console_.println();
	console_.flush();
    }

    public void info(String message) {
	log(LEVEL_INFO, message);
    }

    public void verbose(String message) {
	log(LEVEL_VERBOSE, message);
    }

    public void warning(String message) {
	log(LEVEL_WARNING, "Warning: " + message);
    }

    public void error(String message) {
	log(LEVEL_ERROR, "Error: " + message);
    }

    public void debug(String message) {
	log(LEVEL_DEBUG, message);
    }

    public void log(int level, String message) {
	if (consoleLevel_ >= level) {
	    console_.println(message);
	    console_.flush();
	}
    }
}
