/*
 * The JabaJaba class library
 *  Copyright (C) 1997-1999  ASAMI, Tomoharu (tasami@ibm.net)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

package jp.gr.java_conf.jaba2.awt.graph;

import java.util.*;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.Point;
import java.awt.Graphics;
import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.*;
import jp.gr.java_conf.jaba2.awt.*;

/**
 * Sample2
 *
 * @since   Dec.  1, 1998
 * @version Mar.  1, 1999
 * @author  ASAMI, Tomoharu (tasami@ibm.net)
 */
public class Sample2 extends JPanel {
    protected GraphModel model_;

    public Sample2() {
	setLayout(new RowLayout());

	model_ = new Model();

	final GraphEditPanel2 panel = new GraphEditPanel2(model_);
	panel.setLayout(new ColumnLayout());

	GraphPanel left = new GraphPanel(new RowLayout());
	GraphPanel right = new GraphPanel(new RowLayout());

	Node node1 = new Node(model_);
	left.add(node1);
	Node node2 = new Node(model_);
	left.add(node2);
	panel.addNode(left);
	Node node3 = new Node(model_);
//	right.add(node3);
//	panel.add(right);
	panel.addNode(node3);

	JPanel buttons = new JPanel();
	final JTextField gridField = new JTextField("1", 10);
	gridField.addActionListener(new ActionListener() {
	    public void actionPerformed(ActionEvent evt) {
		try {
		    int grid = Integer.parseInt(gridField.getText());
		    panel.setGrid(grid);
		} catch (NumberFormatException e) {
		    gridField.setText(Integer.toString(panel.getGrid()));
		}
	    }
	});
	buttons.add(gridField);
	JRadioButton move = new JRadioButton("move");
	move.setSelected(true);
	JRadioButton link = new JRadioButton("link");
	move.addActionListener(new ActionListener() {
	    public void actionPerformed(ActionEvent evt) {
		panel.setMode(GraphEditPanel2.MOVE_MODE);
	    }
	});
	link.addActionListener(new ActionListener() {
	    public void actionPerformed(ActionEvent evt) {
		panel.setMode(GraphEditPanel2.LINK_MODE);
	    }
	});
	buttons.add(move);
	buttons.add(link);
	ButtonGroup group = new ButtonGroup();
	group.add(move);
	group.add(link);

	add(buttons);
	add(panel);
	model_.sync();
    }

    public static class Node extends GraphNode {
	public Node(GraphModel model) {
	    super(model);
	    setSize(50, 50);
	}

	public Dimension getPreferredSize() {
	    return (new Dimension(100, 100));
	}

	public void paint(Graphics g) {
	    if (selected_) {
		g.setColor(Color.red);
	    } else if (hilight_) {
		g.setColor(Color.yellow);
	    } else {
		g.setColor(Color.green);
	    }
	    Dimension size = getSize();
	    g.fillRect(0, 0, size.width, size.height);
	}
    }

    public static class Dock extends GraphDock {
	public Dock(GraphModel model) {
	    super(model);
	    removable_ = false;
	    setSize(50, 50);
	}

	public Dimension getPreferredSize() {
	    return (new Dimension(100, 100));
	}

	public boolean isAction() {
	    return (true);
	}

	public Action[] getActions() {
	    Action[] actions = new Action[1];
	    actions[0] = new AbstractAction("create") {
		public void actionPerformed(ActionEvent evt) {
		    GraphNode node = Dock.this.model_.createNode();
		    node.setBounds(getBounds());
		    Dock.this.model_.sync();
		}
	    };
	    return (actions);
	}

	// JComponent
	public void paint(Graphics g) {
	    g.setColor(Color.blue);
	    Dimension size = getSize();
	    g.fillRect(0, 0, size.width, size.height);
	}
    }

    static class Model extends AbstractGraphModel {
	public Model() {
	}

	public GraphNode createNode() {
	    GraphNode node = new Node(this);
	    return (node);
	}

	public GraphLink createLink(GraphNode lhs, GraphNode rhs) {
	    GraphLink link = new GraphLink(this);
	    link.addLeftNode(lhs);
	    link.addRightNode(rhs);
	    addLink(link);
	    return (link);
	}
    }
}
