/*
 * The JabaJaba class library
 *  Copyright (C) 1997-1999  ASAMI, Tomoharu (tasami@ibm.net)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

package jp.gr.java_conf.jaba2.awt;

public interface LayoutConstants {
    // HBASE
    public static final int HBASE_MASK = 0x0000000f;
    public static final int HBASE_DEFAULT = 0x00000000;
    public static final int HBASE_LEFT = 0x00000001;
    public static final int HBASE_CENTER = 0x00000002; // default
    public static final int HBASE_RIGHT = 0x00000003;
    public static final int HBASE_FILL = 0x00000004;
    // VBASE
    public static final int VBASE_MASK = 0x000000f0;
    public static final int VBASE_DEFAULT = 0x00000000;
    public static final int VBASE_TOP = 0x00000010;
    public static final int VBASE_CENTER = 0x00000020; // default
    public static final int VBASE_BOTTOM = 0x00000030;
    public static final int VBASE_FILL = 0x00000040;
    // HALIGN
    public static final int HALIGN_MASK = 0x0000f00;
    public static final int HALIGN_DEFAULT = 0x00000000;
    public static final int HALIGN_LEFT = 0x00000100;
    public static final int HALIGN_CENTER = 0x00000200; // default
    public static final int HALIGN_RIGHT = 0x00000300;
    public static final int HALIGN_FILL = 0x00000400;
    // VALIGN
    public static final int VALIGN_MASK = 0x0000f000;
    public static final int VALIGN_DEFAULT = 0x00000000;
    public static final int VALIGN_TOP = 0x00001000;
    public static final int VALIGN_CENTER = 0x00002000; // default
    public static final int VALIGN_BOTTOM = 0x00003000;
    public static final int VALIGN_FILL = 0x00004000;
    // WIDTH
    public static final int WIDTH_MASK = 0x000f0000;
    public static final int WIDTH_DEFAULT = 0x00000000;
    public static final int WIDTH_PREFERRED = 0x00010000; // default
    public static final int WIDTH_EQUAL = 0x00020000;
    public static final int WIDTH_FILL = 0x00030000;
    public static final int WIDTH_RELATIVE = 0x00040000; // use attr
    public static final int WIDTH_ABSOLUTE = 0x00050000; // use attr
    // HEIGHT
    public static final int HEIGHT_MASK = 0x00f00000;
    public static final int HEIGHT_DEFAULT = 0x00000000;
    public static final int HEIGHT_PREFERRED = 0x00100000;
    public static final int HEIGHT_EQUAL = 0x00200000; // default
    public static final int HEIGHT_FILL = 0x00300000;
    public static final int HEIGHT_RELATIVE = 0x00400000; // use attr
    public static final int HEIGHT_ABSOLUTE = 0x00500000; // use attr
    // RESIZE
    public static final int RESIZE_MASK = 0x0f000000;
    public static final int RESIZE_DEFAULT = 0x00000000;
    public static final int RESIZE_NONE = 0x01000000;
    public static final int RESIZE_WIDTH = 0x02000000;
    public static final int RESIZE_HEIGHT = 0x03000000; // default
    public static final int RESIZE_BOUND = 0x04000000;
}
