package jp.gr.java_conf.jaba2.awt;

import java.util.*;
import java.awt.LayoutManager2;
import java.awt.Component;
import java.awt.Container;
import java.awt.Insets;
import java.awt.Dimension;
import java.awt.Rectangle;
import jp.gr.java_conf.jaba2.awt.*;

/**
 * DialogLayout
 *
 * @since   Apr. 29, 1998
 * @version May. 31, 1998
 * @author  ASAMI, Tomoharu (tasami@ibm.net)
 */
public class DialogLayout extends AbstractLayoutManager {
    protected Component view_ = new StubComponent();
    protected Component separator_ = new StubComponent(0, 0);
    protected Component indicator_ = new StubComponent();

    public DialogLayout() {
	super(5, 10, 5, 5);
    }

    // AbstractLayoutManager
    public void addLayoutComponent(Component comp, Object constraints) {
//System.out.println(comp);
	try {
	    String place = (String)constraints;
//System.out.println(place);
	    if (place.equals("view")) {
		view_ = comp;
	    } else if (place.equals("separator")) {
		separator_ = comp;
	    } else if (place.equals("indicator")) {
		indicator_ = comp;
	    } else {
		throw (new Exception());
	    }
	} catch (Exception evt) {
	    throw (new IllegalArgumentException(
		"Invalid constraints : " + constraints
	    ));
	}
	super.addLayoutComponent(comp, constraints);
    }

    // LayoutManager
    public void layoutContainer(Container target) {
	Dimension size = _getViewSize(target);
	Insets insets = target.getInsets();
	Dimension viewPref = view_.getPreferredSize();
	Dimension sepPref = separator_.getPreferredSize();
	Dimension indPref = indicator_.getPreferredSize();
	Rectangle viewArea = new Rectangle();
	Rectangle sepArea = new Rectangle();
	Rectangle indArea = new Rectangle();
	int gap = vInnerGap_ / 2;
	int viewHeight
	    = size.height - sepPref.height - indPref.height - gap - gap;
	if (viewHeight < 0) {
	    viewHeight = 0;
	}
	viewArea.x = 0;
	viewArea.y = 0;
	viewArea.width = size.width;
	viewArea.height = viewHeight;
	sepArea.x = 0;
	sepArea.y = viewHeight + gap;
	sepArea.width = size.width;
	sepArea.height = sepPref.height;
	indArea.x = 0;
	indArea.y = sepArea.y + sepArea.height + gap;
	indArea.width = size.width;
	indArea.height = indPref.height;
	List areas = new ArrayList();
	areas.add(viewArea);
	areas.add(sepArea);
	areas.add(indArea);
	List comps = new ArrayList();
	comps.add(view_);
	comps.add(separator_);
	comps.add(indicator_);
	_moveComponentsOnView(comps, areas, insets);
    }

    // LayoutManager
    public Dimension preferredLayoutSize(Container target) {
	Insets insets = target.getInsets();
	Dimension viewPref = view_.getPreferredSize();
	Dimension sepPref = separator_.getPreferredSize();
	Dimension indPref = indicator_.getPreferredSize();
	Rectangle viewArea = new Rectangle();
	Rectangle sepArea = new Rectangle();
	Rectangle indArea = new Rectangle();
	Dimension size = new Dimension(
	    Math.max(viewPref.width, indPref.width),
	    viewPref.height + sepPref.height + indPref.height + vInnerGap_
	);
	_adjustBorder(size, insets);
	return (size);
    }

    // LayoutManager
    public Dimension minimumLayoutSize(Container target) {
	return (preferredLayoutSize(target));
    }
}
