/*
 * SmartTable
 *  Copyright (C) 1999,2000  ASAMI, Tomoharu (tasami@ibm.net)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

package jp.gr.java_conf.jaba2.SmartTable;

import java.io.*;
import java.net.URL;
import jp.gr.java_conf.jaba2.j2fw.translator.*;
import jp.gr.java_conf.jaba2.text.UString;
import jp.gr.java_conf.jaba2.util.*;

/**
 * XMLImporter
 *
 * @since   Aug.  3, 1999
 * @version Jan. 17, 2000
 * @author  ASAMI, Tomoharu (tasami@ibm.net)
 */
public class XMLImporter extends AbstractImporter {
    public String getID() {
	return ("xml");
    }

    public String getName() {
	return ("XML Importer");
    }

    public boolean canImport(URL url) {
	return (USmartTable.isXMLFile(url));
    }

    public void importSource(URL url) throws IOException {
	SmartTableModel model = (SmartTableModel)model_;
	Metadata metadata = model.getMetadataIn();
	D2Array d2 = metadata.xml2D2Array(url);
	model.setData(d2);
    }
}
