/*
 * SmartDoc : Ultimate document format based on XML
 *  Copyright (C) 1998-2000  ASAMI, Tomoharu (asami@zeomtech.com)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

package jp.gr.java_conf.jaba2.SmartDoc.xslt;

import java.io.*;
import java.net.MalformedURLException;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;
import jp.gr.java_conf.jaba2.text.UString;
import jp.gr.java_conf.jaba2.text.updater.UUpdater;
import jp.gr.java_conf.jaba2.j2fw.generator.*;
import jp.gr.java_conf.jaba2.xml.UXML;
import jp.gr.java_conf.jaba2.xml.XSLTBeans;
import jp.gr.java_conf.jaba2.xml.IProcessor;
import jp.gr.java_conf.jaba2.xml.ProcessorFactory;
import jp.gr.java_conf.jaba2.SmartDoc.*;
import jp.gr.java_conf.jaba2.SmartDoc.pure.*;

/**
 * XSLTGenerator
 *
 * @since   Aug.  5, 2000
 * @version Dec.  3, 2000
 * @author  ASAMI, Tomoharu (asami@zeomtech.com)
 */
public class XSLTGenerator extends AbstractSmartDocGenerator {
    protected XSLTConfig xsltConfig_;
    protected PureGenerator pureGenerator_;
    protected XSLTBeans xslt_ = new XSLTBeans();

    public void init(SmartDocConfig config, SmartDocFormatConfig fconfig) {
	super.init(config, fconfig);
	xsltConfig_ = (XSLTConfig)fconfig;
	pureGenerator_ = (PureGenerator)xsltConfig_.getDelegationGenerator();
    }

    // AbstractYaGenerator
    public GeneratorResult generate(IGeneratorParameter iparam) {
	GeneratorParameter param = (GeneratorParameter)iparam;
	GeneratorResult result = pureGenerator_.generate(param);
	try {
	    GeneratorResult finalResult = new GeneratorResult();
	    xslt_.setXSLURI(xsltConfig_.getXSLURI());
	    String suffix = xsltConfig_.getSuffix();
	    String encoding = xsltConfig_.getEncoding(param.doc);
	    xslt_.setOutputEncoding(encoding);
	    GeneratorArtifact[] artifacts = result.getArtifacts();
	    for (int i = 0;i < artifacts.length;i++) {
		GeneratorArtifact artifact = artifacts[i];
		if (artifact instanceof TextArtifact) {
		    TextArtifact text = (TextArtifact)artifact;
		    String target = text.getString();
		    target = _applyPreRegex(target);
		    target = _applyPreTextRegex(target);
		    xslt_.setInputSource(target);
		    target = xslt_.getTargetDocumentAsString();
		    target = _applyRegex(target);
		    String fileName = text.getName();
		    finalResult.addArtifact(
			UString.changeSuffix(fileName, suffix),
			target,
			encoding
		    );
		} else {
		    finalResult.addArtifact(artifact);
		}
	    }
	    return (finalResult);
	} catch (MalformedURLException e) {
	    USmartDoc.error(e.getMessage());
	} catch (IOException e) {
	    USmartDoc.error(e.getMessage());
	} catch (SAXException e) {
	    USmartDoc.error(e.getMessage());
	}
	return (result);
    }

    protected String _applyPreRegex(String text)
	throws MalformedURLException, IOException {

	String uri = xsltConfig_.getPreRegexRule();
	if (uri == null) {
	    return (text);
	}
	return (UUpdater.replace(text, uri));
    }

    protected String _applyPreTextRegex(String text)
	throws MalformedURLException, IOException {

	String uri = xsltConfig_.getPreTextRegexRule();
	if (uri == null) {
	    return (text);
	}
	IProcessor processor = ProcessorFactory.getProcessor();
	Document doc = processor.parseDocumentByText(text);
	_replaceTextNode(doc, uri);
	return (UXML.doc2String4Data(doc));
    }

    protected String _applyRegex(String text)
	throws MalformedURLException, IOException {

	String uri = xsltConfig_.getRegexRule();
	if (uri == null) {
	    return (text);
	}
	return (UUpdater.replace(text, uri));
    }

    private void _replaceTextNode(Document doc, String uri) {
	return;			// XXX
    }
}
