/*
 * SmartDoc : Ultimate document format based on XML
 *  Copyright (C) 1998-2000  ASAMI, Tomoharu (asami@zeomtech.com)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

package jp.gr.java_conf.jaba2.SmartDoc.normalizer;

import java.util.*;
import org.apache.oro.text.perl.Perl5Util; // revised by asami
import jp.gr.java_conf.jaba2.text.UString;
import jp.gr.java_conf.jaba2.SmartDoc.*;

/**
 * HilightMaker
 * 
 * @since   Jul. 16, 2000
 * @version Mar. 16, 2001
 * @author  SAKURAI, Masashi (erwin@bb.mbn.or.jp)
 */
public class HilightMaker {

    List keywordList;

    /**
       Construct hilight class.
       Once construct this object, other routine can re-use to 
       call [makeHilight] method.

       @param keywords   keyword matrix [group][keywords]
       @param isRegex    is each group Regex? [group]
       @param keyClasses class name in charge of tag [group]
     */
    public HilightMaker(String [][] keywords,boolean [] isRegex,
			String [] keyClasses) {
	keywordList = new LinkedList();
	for (int i=0;i<keyClasses.length;i++) {
	    for (int j=0;j<keywords[i].length;j++) {
		Keyword m = new Keyword(keywords[i][j],!isRegex[i],
					keyClasses[i]);
		keywordList.add(m);
	    }
	}
    }

    /** 
	make syntax hilighting
	@param text input plain text
	@param list operated text list
     */
    public void makeHilight(String text,List list) {
	Perl5Util util = new Perl5Util();
	//ready
	TreeSet tree = new TreeSet();
	Iterator it = keywordList.iterator();
	while(it.hasNext()) {
	    Keyword key = (Keyword)it.next();
	    if (search(util,text,key)) tree.add(key);
	}
	ArrayList tempList = new ArrayList();

	while( !tree.isEmpty() ) {
	    Keyword res = (Keyword)tree.first();
	    if (res.ps == -1) 
		break;//error?
	    if (res.ps > 0)
		list.add(new CharBlock(text.substring(0, res.ps)));
	    list.add(res.getContent());
	    if (res.end < text.length()) 
		text = text.substring(res.end);
	    else 
		break;//error?

	    //update tree
	    tempList.clear();
	    int delta = res.end;//number of slide of text position
	    Iterator it2 = tree.iterator();
	    while(it2.hasNext()) {
		Keyword key = (Keyword)it2.next();
		if (key.ps < delta || res == key) {
		    it2.remove();
		    if (search(util,text,key)) 
			tempList.add(key);//next match
		    continue;
		}
		key.ps -= delta;
		key.end -= delta;
	    }
	    tree.addAll(tempList);//merge with tree
	}
	list.add(new CharBlock(text));
    }

    /** 
       @param util Perl5Util
       @param text source text
       @param matched keyword info set
    */
    protected boolean search(Perl5Util util,String text,Keyword matched) {
	String temp=null;
	boolean first = false;
	String head = "",tail ="";

	if (matched.mod) {
	    head = "(^|\\W)";
	    tail = "\\W";
	}

	if (util.match("#" + head + matched.keyword + tail + "#m", text)) {
	    matched.matchedWord = util.toString();
	    int curPs = text.indexOf(matched.matchedWord);

	    if (curPs == -1) throw (new InternalError());

	    matched.ps = curPs;
	    matched.end = curPs + matched.matchedWord.length();
	    if (matched.mod) {
		int rps = matched.matchedWord.indexOf(matched.keyword);
		if (rps <= -1) {
		    System.out.println("["+matched.matchedWord+"]["+matched.keyword+"] "+rps+" "+matched.ps);
		    throw new InternalError();
		}
		if (rps != 0) matched.ps += rps;
		matched.end -= matched.matchedWord.length()
		    - (rps+matched.keyword.length());
		matched.matchedWord = text.substring(matched.ps,matched.end);
	    }
	    return true;
	}
	return false;
    }


    class Keyword implements Comparable {
	
	int ps=-1; //matched start position
	int end=-1;//matched end position
	boolean mod = false;//if just keyword, true
	String keyClass=null;//keyword class
	String keyCSSClass=null;//keyword css class
	String keyword=null;//keyword string
	String matchedWord=null;//matched string
	
	Keyword(String s,boolean m,String t) {
	    mod = m; keyword = s;
	    int index = t.indexOf("#");
	    if (index == -1) {
		keyClass = t;
	    } else {
		keyClass = t.substring(0, index);
		keyCSSClass = t.substring(index + 1);
	    }
	}
	
	Content getContent() {
	    try {
		if (keyword != null) {
		    Container ct = 
			(Container)(Class.forName(keyClass).newInstance());
		    if (keyCSSClass != null) {
			ct.setClazz(keyCSSClass);
		    }
		    ct.addContent(new CharBlock(matchedWord));
		    return ct;
		}
	    } catch(Exception e) {
		throw new RuntimeException("Class "+keyClass+" not found.");
	    }
	    return new CharBlock(matchedWord);
	}
	
	public int compareTo(Object o) {
	    if (o instanceof Keyword) {
		Keyword t = (Keyword)o;
		return ps - t.ps;
	    }
	    throw new InternalError();
	}
	
    }
}

