/*
 * SmartDoc : Ultimate document format based on XML
 *  Copyright (C) 1998-2001  ASAMI, Tomoharu (asami@zeomtech.com)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

package jp.gr.java_conf.jaba2.SmartDoc.html4;

import java.util.*;
import java.io.*;
import jp.gr.java_conf.jaba2.util.ParameterInfo;
import jp.gr.java_conf.jaba2.util.AppParameterInfo;
import jp.gr.java_conf.jaba2.io.UURL;
import jp.gr.java_conf.jaba2.SmartDoc.*;
import jp.gr.java_conf.jaba2.SmartDoc.xhtml.IXHTMLDynamicHandler;

/**
 * HTML4Config
 *
 * @since   Oct. 27, 1998
 * @version Dec. 18, 2001
 * @author  ASAMI, Tomoharu (asami@zeomtech.com)
 */
public class HTML4Config extends AbstractSmartDocFormatConfig {
    protected IXHTMLDynamicHandler dynamicHandler_;
    protected String cssURL_;
    protected String cssInclude_;
    protected boolean cssCopy_;
    protected String[] imageCandidates_;
    protected boolean numberedTitle_;
    protected String dtdType_;
    protected boolean nnLink_;
    protected boolean ohp_;

    // SmartDocFormatConfig
    public void setup(SmartDocConfig config, String[] args)
	throws IOException {

	ParameterInfo info = new AppParameterInfo(
	    "jp.gr.java_conf.jaba2.SmartDoc",
	    args,
	    "jp.gr.java_conf.jaba2.SmartDoc.html4.HTML4Defaults",
	    new File("SmartDoc.properties")
	);
	info.addPackage("jp.gr.java_conf.jaba2.SmartDoc.html4");
	info.addPackage("jp.gr.java_conf.jaba2.SmartDoc.html4.handler");
	dynamicHandler_ = (IXHTMLDynamicHandler)info.getParameterAsNewInstance(
	    "html4.dynamic"
	);
	imageCandidates_ = info.getParameterAsStringList("html4.imageFormat");
	cssURL_ = info.getParameterAsString("html4.css.url");
	cssInclude_ = info.getParameterAsString("html4.css.include");
	cssCopy_ = info.getParameterAsBoolean("html4.css.copy");
	numberedTitle_ = info.getParameterAsBoolean("html4.titleNumber");
	if (numberedTitle_ == false) {
	    numberedTitle_ = info.getParameterAsBoolean("html4.numberedTitle");
	}
	dtdType_ =  info.getParameterAsString("html4.dtd.type");
	nnLink_ =  info.getParameterAsBoolean("html4.nnLink");
	ohp_ =  info.getParameterAsBoolean("html4.ohp");
	_init(config, "html4", info);
    }

    // SmartDocFormatConfig
    public String getID() {
	return ("html4");
    }

    // SmartDocFormatConfig
    public String getName() {
	return ("HTML4.0");
    }

    // SmartDocFormatConfig
    public String[] getImageCandidates() {
	return (imageCandidates_);
    }

    public IXHTMLDynamicHandler getDynamicHandler() {
	return (dynamicHandler_);
    }

    public String getCSSURL() {
	return (cssURL_);
    }

    public String getCSSInclude() {
	return (cssInclude_);
    }

    public boolean isCopyCSS() {
	return (cssCopy_);
    }

    public boolean isNumberedTitle() { // XXX : XHTMLFormatConfig?
	return (numberedTitle_);
    }

    public boolean isStrictDTD() {
	return ("strict".equals(dtdType_));
    }

    public boolean isNNLink() {
	return (nnLink_);
    }

    public boolean isOHP() {
	return (ohp_);
    }
}
