/*
 * SmartDoc : Ultimate document format based on XML
 *  Copyright (C) 1998-2001  ASAMI, Tomoharu (asami@zeomtech.com)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

package jp.gr.java_conf.jaba2.SmartDoc.adapter;

import java.util.*;
import java.io.*;
import java.net.URL;
import java.net.MalformedURLException;
import org.w3c.dom.*;
import jp.gr.java_conf.jaba2.xml.*;
import jp.gr.java_conf.jaba2.util.D2Array;
import jp.gr.java_conf.jaba2.text.UString;
import jp.gr.java_conf.jaba2.io.UURL;
import jp.gr.java_conf.jaba2.SmartDoc.*;

/**
 * MacroAdapter
 *
 * @since   Feb. 12, 2001
 * @version Feb. 12, 2001
 * @author  ASAMI, Tomoharu (asami@zeomtech.com)
 */
public class MacroAdapter extends AbstractAdapter {
    // AbstractAdapter
    protected Content[] _expand(
	String[] srcs,
	String param,
	Content content,
	Content[] contents,
	DocContext context
    ) {
	String src = srcs[0];
	if (src == null) {
	    return (new Content[0]);
	}
	String encoding = content.getEncoding();
	try {
	    URL url = UURL.getURLFromFileOrURLName(src);
	    SmartDocConfig config = SmartDocContext.getContext().getConfig();
	    IProcessor processor = config.getXMLProcessor();
	    Document xml = processor.parseDocument(url);
	    if (xml == null || xml.getDocumentElement() == null) {
		USmartDoc.error("XML syntax error");
	    }
	    SmartDocModel model = SmartDocContext.getContext().getModel();
	    return (model.buildMacroContents(xml.getDocumentElement()));
	} catch (MalformedURLException e) {
	    throw (new SmartDocWarningException(e));
	} catch (IOException e) {
	    throw (new SmartDocWarningException(e));
	}
    }
}
