/*
 * SmartDoc : Ultimate document format based on XML
 *  Copyright (C) 1998-2000  ASAMI, Tomoharu (asami@zeomtech.com)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

package jp.gr.java_conf.jaba2.SmartDoc;

import java.util.*;
import java.io.*;
import java.net.URL;
import jp.gr.java_conf.jaba2.j2fw.*;
import jp.gr.java_conf.jaba2.j2fw.generator.*;
import jp.gr.java_conf.jaba2.io.UFile;

/**
 * SmartDocController
 *
 * @since   Oct. 19, 1998
 * @version Jun. 27, 2000
 * @author  ASAMI, Tomoharu (asami@zeomtech.com)
 */
public class SmartDocController extends GeneratorController {
    protected SmartDocConfig config_;
    protected SmartDocModel model_;
//    protected SmartDocGenerator generator_;
    protected String[] formats_;

    public SmartDocController(SmartDocConfig config, SmartDocModel model) {
	this(config, model, null);
    }

    public SmartDocController(
	SmartDocConfig config,
	SmartDocModel model,
	TTYView view
    ) {
	super(config, model, view);
	config_ = config;
	model_ = model;
//	generator_ = config.getGenerator();
	formats_ = config.getFormats();
	J2Context.getJ2Context().getJ2Monitor().setConsole(view.getTTY());
    }

    public void showPropertiesConsole() {
	J2Monitor monitor = J2Context.getJ2Context().getJ2Monitor();
	String file = config_.getSource().toString();
	if (file != null) {
	    monitor.println("Source file\t: " + file);
	}
	String propertyFile = config_.getPropertyFile();
	if (propertyFile != null) {
	    monitor.println("Property file\t: " + propertyFile);
	}
	Locale[] locales = config_.getLocales();
	if (locales != null) {
	    monitor.print("Locales\t: ");
	    if (locales.length > 0) {
		monitor.print(locales[0].toString());
		for (int i = 1;i < locales.length;i++) {
		    monitor.print(", ");
		    monitor.print(locales[1].toString());
		}
	    }
	    monitor.println();
	}
    }

    // XXX : integrate GeneratorController
    public GeneratorResult[] generateFiles() throws IOException {
	List results = new ArrayList();
	J2Monitor monitor = J2Context.getJ2Context().getJ2Monitor();
	DocContext[] contexts = model_.getDocContexts();
	for (int i = 0;i < contexts.length;i++) {
	    DocContext context = contexts[i];
	    String format = context.getFormat();
	    Locale locale = context.getLocale();
	    SmartDocGenerator generator = context.getGenerator();
	    if (locale != null) {
		monitor.info(
		    "<<" +
		    context.getFormatName() +
		    "[" + locale + "]>>"
		);
		results.add(
		    _generateFile(
			generator,
			model_.getDoc(context),
			locale,
			model_
		    )
		);
	    } else {
		monitor.info(
		    "<<" + context.getFormatName() + ">>"
		);
		results.add(
		    _generateFile(
			generator,
			model_.getDoc(context),
			model_
		    )
		);
	    }
	}
	GeneratorResult[] array = new GeneratorResult[results.size()];
	return ((GeneratorResult[])results.toArray(array));
    }

    protected GeneratorResult _generateFile(
	SmartDocGenerator generator,
	Doc doc,
	Locale locale,
	SmartDocModel model
    ) throws IOException {
	J2Monitor monitor = J2Context.getJ2Context().getJ2Monitor();
	DocContext context = doc.getDocContext();
	GeneratorParameter param = new GeneratorParameter();
	param.doc = doc;
	param.model = model;
	param.deploy = config_.getDeploy(); // XXX
	param.project = config_.getProject();
	GeneratorResult result = generator.generate(param);
	GeneratorArtifact[] artifacts = result.getArtifacts();
	String format = context.getFormat();
	IPackager packager = config_.getPackager(format);
	packager.pack(artifacts, result, format, doc, new File("."));
	for (int i = 0;i < artifacts.length;i++) {
	    monitor.info("\tartifact = " + artifacts[i].getName());
	}
	return (result);
    }

    protected GeneratorResult _generateFile(
	SmartDocGenerator generator,
	Doc doc,
	SmartDocModel model
    ) throws IOException {
	return (_generateFile(generator, doc, null, model));
    }

/*
    public void generateFile() throws IOException {
	_generateFile(generator_);
    }

    public void generateFiles() throws IOException {
	J2Monitor monitor = J2Context.getJ2Context().getJ2Monitor();
	DocContext[] contexts = model_.getDocContexts();
	for (int i = 0;i < contexts.length;i++) {
	    DocContext context = contexts[i];
	    String format = context.getFormat();
	    Locale locale = context.getLocale();
	    SmartDocGenerator generator = context.getGenerator();
	    if (locale != null) {
		if (generator instanceof SimpleGenerator) {
		    _generateFile(
			(SimpleGenerator)generator,
			model_.getDoc(context),
			locale,
			model_
		    );
		} else if (generator instanceof MasterGenerator) {
		    _generateFile(
			(MasterGenerator)generator,
			model_.getDoc(context),
			locale,
			model_
		    );
		} else if (generator instanceof YaGenerator) {
		    YaGenerator ya = (YaGenerator)generator;
		    monitor.info(
			"<<" +
			context.getFormatName() +
			"[" + locale + "]>>"
		    );
		    _generateFile(
			ya,
			model_.getDoc(context),
			locale,
			model_
		    );
		} else {
		    throw (new InternalError());
		}
	    } else {
		if (generator instanceof SimpleGenerator) {
		    _generateFile(
			(SimpleGenerator)generator,
			model_.getDoc(context),
			model_
		    );
		} else if (generator instanceof MasterGenerator) {
		    _generateFile(
			(MasterGenerator)generator,
			model_.getDoc(context),
			model_
		    );
		} else if (generator instanceof YaGenerator) {
		    YaGenerator ya = (YaGenerator)generator;
		    monitor.info(
			"<<" + context.getFormatName() + ">>"
		    );
		    _generateFile(
			ya,
			model_.getDoc(context),
			model_
		    );
		} else {
		    throw (new InternalError());
		}
	    }
	}
    }

    public void generateFiles0() throws IOException {
	if (generator_ != null) {
	    generateFile();
	    return;
	}
	for (int i = 0;i < formats_.length;i++) {
	    SmartDocFormatConfig fc = config_.getFormatConfig(formats_[i]);
	    if (fc == null) {
		System.out.println("bad format : " + formats_[i]); // XXX
		continue;
	    }
	    _generateFile(fc.getGenerator());
	}
    }

    protected void _generateFile(Generator generator) throws IOException {
	Locale[] locales = model_.getLocales();
	if (locales != null && locales.length > 0) {
	    for (int i = 0;i < locales.length;i++) {
		Locale locale = locales[i];
		if (generator instanceof SimpleGenerator) {
		    _generateFile(
			(SimpleGenerator)generator,
			model_.getDoc(locale),
			locale,
			model_
		    );
		} else if (generator instanceof MasterGenerator) {
		    _generateFile(
			(MasterGenerator)generator,
			model_.getDoc(locale),
			locale,
			model_
		    );
		} else {
		    throw (new InternalError());
		}
	    }
	} else {
	    if (generator instanceof SimpleGenerator) {
		_generateFile(
		    (SimpleGenerator)generator,
		    model_.getDoc(),
		    model_
		);
	    } else if (generator instanceof MasterGenerator) {
		_generateFile(
		    (MasterGenerator)generator,
		    model_.getDoc(),
		    model_
		);
	    } else {
		throw (new InternalError());
	    }
	}
    }

    protected void _generateFile(
	MasterGenerator generator,
	Doc doc,
	Locale locale,
	SmartDocModel model
    ) throws IOException {
	generator.generate(
	    doc,
	    config_.getProject(),
	    locale,
	    config_.getDeploy(),
	    config_.getProjectDirectory(),
	    model
	);
    }

    protected void _generateFile(
	MasterGenerator generator,
	Doc doc,
	SmartDocModel model
    ) throws IOException {
	generator.generate(
	    doc,
	    config_.getProject(),
	    null,
	    config_.getDeploy(),
	    config_.getProjectDirectory(),
	    model
	);
    }

    protected void _generateFile(
	SimpleGenerator generator,
	Doc doc,
	Locale locale,
	SmartDocModel model
    ) throws IOException {
	String text = generator.generate(doc, locale, model_);
	URL source = model_.getSource();
	File sourceFile = new File(source.getFile());
	File targetFile = UFile.makeOutputFile(
	    sourceFile,
	    generator.getSuffix(),
	    locale
	);
	UFile.createFile(targetFile, text);
    }

    protected void _generateFile(
	SimpleGenerator generator,
	Doc doc,
	SmartDocModel model
    ) throws IOException {
	String text = generator.generate(doc, null, model_);
	URL source = model_.getSource();
	File sourceFile = new File(source.getFile());
	File targetFile = UFile.makeOutputFile(
	    sourceFile,
	    generator.getSuffix()
	);
	UFile.createFile(targetFile, text);
    }

    protected void _generateFile(
	YaGenerator generator,
	Doc doc,
	Locale locale,
	SmartDocModel model
    ) throws IOException {
	J2Monitor monitor = J2Context.getJ2Context().getJ2Monitor();
	DocContext context = doc.getDocContext();
	GeneratorParameter param = new GeneratorParameter();
	param.doc = doc;
	param.model = model;
	param.deploy = config_.getDeploy(); // XXX
	param.project = config_.getProject();
	GeneratorResult result = generator.generate(param);
	GeneratorArtifact[] artifacts = result.getArtifacts();
	String format = context.getFormat();
	IPackager packager = config_.getPackager(format);
	packager.pack(artifacts, doc, new File("."));
	for (int i = 0;i < artifacts.length;i++) {
	    monitor.info("\tartifact = " + artifacts[i].name);
	}
    }

    protected void _generateFile(
	YaGenerator generator,
	Doc doc,
	SmartDocModel model
    ) throws IOException {
	_generateFile(generator, doc, null, model);
    }
*/
}
