/*
 * SmartDoc : Ultimate document format based on XML
 *  Copyright (C) 1998-2001  ASAMI, Tomoharu (asami@zeomtech.com)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

package jp.gr.java_conf.jaba2.SmartDoc;

import java.util.*;
import org.w3c.dom.*;
import jp.gr.java_conf.jaba2.text.UString;

/**
 * Bibitem
 *
 * @since   Nov.  1, 1998
 * @version Jan. 15, 2001
 * @author  ASAMI, Tomoharu (asami@zeomtech.com)
 */
public class Bibitem extends Container {
    protected Bibitem(Element element) {
	super(element);
	if (sequenceNumber_ == null) {
	    sequenceNumber_ = new SequenceNumber("bibitem");
	}
	if (idref_ == null) {
	    String href = element.getAttribute("href");
	    if (UString.notNull(href)) {
		if (href.startsWith("#")) {
		    idref_ = href.substring(1);
		}
	    }
	}
    }

    // Content
    public int getEntityType() {
	return (ENTITY_BLOCK);
    }

    public static Bibitem getBibitem(Element element) {
	String tagName = element.getTagName();
	if ("book".equals(tagName)) {
	    return (new Book(element));
	} else if ("journal".equals(tagName)) {
	    return (new Journal(element));
	} else if ("article".equals(tagName)) {
	    return (new Article(element));
	} else {
	    USmartDoc.warning("bad tag : " + tagName);
	    return (null);
	}
    }

    public static Bibitem getBibitem(
	Element element,
	BibliographyDatabase bibDB
    ) {
	String tagName = element.getTagName();
	if ("book".equals(tagName)) {
	    return (new Book(element, bibDB));
	} else if ("journal".equals(tagName)) {
	    return (new Journal(element, bibDB));
	} else if ("article".equals(tagName)) {
	    return (new Article(element, bibDB));
	} else {
	    USmartDoc.warning("bad tag : " + tagName);
	    return (null);
	}
    }
}
