# SuperDateTime plugin.pm by Greg Brown Feb 2005
#	Copyright (c) 2005 
#	All rights reserved.
#
# DESCRIPTION
# SlimServer plugin screensaver datetime replacement. Graphically displays current weather conditions and forecasts.  
# Will also optionally display stock quotes and upcoming/current game information for MLB, NBA, NHL, NFL, and college 
# football and basketball teams at user-configurable intervals.
#
# REMOTE CONTROL
# Pressing up or down cycles the information shown on line one during time display.  It will also immediately
# display the time if it is not currently being shown.
# Pressing right or left cycles through the available games and long weather forecasts that normally cycle automatically.
# Pressing FWD or REW cycles through the long weather forecasts.
# Pressing '+' will force an immediate data refresh.
#
# This screen saver is based on the standard SlimServer DateTime screensaver written written by kdf.
# The graphical weather icons and the code to support them are based on the WeatherTime screensaver written by Martin Rehfeld.
#
# VERSION HISTORY
# 5.0.13 09/05/07  Updated weather.com international current condition parsing to handle HTML changes.
# 5.0.12 08/26/07  Updated weather.com international parsing to handle HTML changes.
#                  Added german language translations.  Thanks Jrgen!
# 5.0.10 07/19/07  Updated MLB web parsing to handle changes made by ESPN.
# 5.0.8  05/30/07  Added all remaing MLB icons.  Thanks B. Yudichak!
# 5.0.6  05/17/07  Added Minnesota, Tampa Bay, Boston, and Cleveland MLB icons.  Thanks M.Meyer!
# 5.0.5  04/02/07  Fixed ESPN MLB parsing to handle minor '07 season website changes.
#                  Divided up MLB processing to decrease HTML parsing hangs.
#                  Added a few additional MLB logos.
# 5.0.4  01/19/07  Fixed bug where Top-25 conference selection is overwritten on sever restart.
# 5.0.2  01/18/07  When a player is powered on SuperDateTime can be displayed/exited by holding the Size button for a couple
#                  seconds.  This requires a minor manual modification to the default.map file (see installation instructions).
#                  Yahoo Finance ticker symbols that do not provide volume information are now supported.
#                  Top-25 is now selectable as a conference for college basketball and football game information.
# 5.0.0  12/07/06  This version introduces 34 graphical weather icons based on code from Martin Rehfeld's WeatherTime screensaver.
#                  Pressing the up/down bottoms will scroll through the forecasts as well as various display options that
#                  include/omit the forecast icons.
#                  MLB, NBA, and NHL refreshing logic has been enhanced. The previous day's game information will continue
#                  to be shown/refreshed until 5am Eastern time. Refreshing will also stop on a given day once all the games 
#                  you are monitoring have completed.
#                  To save screen space Hi/Low and Precip information is no longer shown when the time is displayed with a 
#                  large font (non Transporters only). The $largeFontTimeIcon variable can be changed by the user if they 
#                  wish to show the hi/low and precip information or remove the current condition icon.
#                  Added support for college football and tweaked code to handle ranked team name shortening.
#                  Added experimental support for MLB and NFL team icons (must be enabled from plugin settings).
#                  Parsing and networking tweaks.
#                  Special thanks to Mike Meyer and Yannzola for contributing some of the weather icons.
# 4.1.2  09/06/06  Merged code provided by Omen Wild.  This adds server setting to show average temperature delta and 
#                  record temperature information on the top display line.
# 4.1.1  08/31/06  The top line text in screen one, as well as the top and bottom lines of screen 2 can now be customized.
#                  Minor networking bug fixes.
# 4.1.0  08/16/06  Updated to utilize new display framework introduced in SlimServer 6.5.
#                  Initial Transporter (dual screen) support.
#                  Failed http calls will automatically be retried three times before a '?' is displayed (indicating failure).
#                  Various bug/code enhancements.
#                  *** SlimServer 6.5 or later is required. ***
# 4.0.6  05/18/06  When using the large font, text will now automatically scroll.  Shortened weather data, previously
#                  only shown with smaller fonts on the top line, is now viewable by pressing the up and down remote buttons.
#                  To view the entire scrolling text please set your display times accordingly.
# 4.0.5	04/05/06  Updated MLB web parsing to handle 2006 format.
# 4.0.4  03/03/06  Added wunderground.com support.
#                  Added stock market support.
#                  Added "ticker" display mode.
# 4.0.1  01/09/06  Long weather forecasts are now always viewable via the FWD and REW remote control buttons.
#                  Updated NBA New Orleans city name to handle its temp location of NO\Oklahoma City.  Thanks sliph.
# 4.0.0  12/13/05  Line two display information can now be customized via a format string. (Thanks MrC)
#                  Added full text weather forecasts.
#                  Added college basketball support.
#                  Reworked background data refreshing.
#                  Reworked information display/remote control to make clients independent of each other.
#                  Added barometric pressure and dew point display.
#                  Wind speed can now be displayed in knots.
#                  Minor bug fixes.
# 3.6.4  11/13/05  Updated Server Settings text to include Latin American Spanish.  Much thanks Nstor.
# 3.6.3  11/05/05  Added kilometers/hour conversion option for wind speed.
# 3.6.1  10/26/05	 Fixed spelling of the NY Knicks (thanks SBB).
#                  Fixed bugs related to the NY Jets/Giants (thanks JL).
#                  Hopefully fixed bug in displaying double digit innings as single digits (thanks JL).
# 3.6.0  10/25/05  Added weather conditions/forecasts (shown on top line during two-line display mode).
#                  Plug-in is now interactive
#                  - Pressing up or down on remote will cycle weather forecast/condition information.
#                  - Pressing left or right will cycle each of the games being displayed.
#                  - Pressing + will force an immediate full data refresh.
#                  Added text scroll type in server plug-in settings.
#                  - Basic text scrolling updates the display immediately with no scrolling (original way).
#                  - Slide text scrolling updates the display by sliding information onto and off of the screen (default).
#                  Code clean up.
# 3.5.0  10/08/05  Added NHL support.
#                  Swapped order of wind speed and wind direction ("proper way"- Thanks Wojo).
# 3.4.3  09/27/05  Added wind speed support. - Thanks CMcKinnon
# 3.4.2  09/26/05  *** SlimServer 6.2 or later is most likely required. ***
#                  Fixed NFL parsing to handle regular season data format.
#                  Line one will now display the sport league pertaining to the game information in line two.
#                  Added status indicator in top right hand corner of display line one.
#                  - '*' is displayed while data is being refreshed.
#                  - If a data update fails the sport abbreviation, or 'W' for weather will be displayed
#                    until a successful update occurs.  Stale data from the last successful update will continue
#                    to be displayed.
#                  - An alarm bell indicator is displayed during the clock display if an alarm clock is set and
#                    no other status is being shown.
# 3.4.0  08/23/05  Added BETA NFL support (parses content successfully most of the time).
#                  Now utilizes Slim::Networking::SimpleAsyncHTTP for asynchronous/background network calls.  
#                  - This should decrease the chance of server freezes/crashes occuring while data is being retrieved.
#                  Network debugging information is sent to -d_plugin.
#                  Rewrote display algorithm to handle background data retrieval.
# 3.2.11 08/12/05  Fixed bug where teams would not save on some new installations.
# 3.2.10 06/22/05  Tweaked NBA web parsing.
# 3.2.9  06/17/05  Added support for displaying active and upcoming/complete games at different intervals.
#                  Added setting to enable/disable showing of the "feels like" temperature.
#                  Fixed bug where humidity setting wouldn't save.
#                  Tweaked NBA web parsing.
#                  Tweaked weather web parsing.
# 3.2.6  06/12/05  Shortened most teams to team name instead of city name to shorten their display character length.
#                  Tweaked NBA web parsing.
# 3.2.5  06/10/05  Added "BETA" NBA support.
# 3.2.0  06/09/05  Added support for tracking of multiple baseball teams.  Added option to display humidity level.
# 3.0.8  06/01/05  Minor bug/display fixes. No longer displays "feels like" temperature if the same.
# 3.0.7  05/20/05  Fixed timezone bug where a data refresh resets offset setting.
# 3.0.6  05/20/05  Fixed display bug when displaying final game scores that trigger scrolling.
# 3.0.5  05/20/05  Added celsius and fahrenheit support.  Added more time zone offsets.
# 3.0.0  03/19/05  Formal PUBLIC release. Fully configurable via plugins web interface.
#
# INSTALLATION
# 1. Unzip downloaded zip file into SlimServer\server\Plugins\ directory.  This should result in a SuperDateTime folder
#    being created within the Plugins folder that contains Plugin.pm.  The folder name is case sensitive.
# 2. Restart slimserver.
# 3. Ensure plugin is enabled from Server Settings / Plugins web page.
# 4. Configure custom plugin settings (city, teams, etc.) from Server Setttings / Plugins web page.
# 5. Enable screensaver for when a player is turned off from Player Settings web page.   
# 
# [OPTIONAL] SlimServer can be configured to temporarily display SuperDateTime when powered on by holding the
#            size button for a couple seconds.  The display is returned to it's previous state by holding the
#            size button again for a couple seconds.  This is useful to view sports/weather/etc information
#            while listening to music.
#
# 6. Open up \SlimServer\Server\IR\Default.map in your favorite raw text editor.
# 7. Scroll down to # textsize modes
# 8. Edit the text in that section to mirror:
#      size = dead
#      size.single = textsize_toggle
#      size.hold   = modefunction_PLUGIN.SuperDateTime::Plugin->showme
#      #size           = textsize_toggle
#      textsize_small  = textsize_small
#      textsize_medium = textsize_medium
#      textsize_large  = textsize_large
# 9. Restart SlimServer
#
# FEEDBACK
# Please direct all feedback to GoCubs on the Slim Devices public forums at forums.slimdevices.com
#
# KNOWN BUGS/ISSUES
# 1.) Text may get truncated if it does not fit on the screen.  Selecting a smaller font fixes the problem.
# 2.) When using the "slide" scroll option, time display may appear to skip a second when the display
# transitions from showing game information or long description forecast to the time.
# 3.) In celius mode, a long description forecast that contains a temperature group (ie mid to upper 30s) instead of
# a specific high/low value (Low 30F) may not make sense after the conversion (ie mid to upper -2s).
# 4.) When SuperDateTime is used as an offsaver in SoftSqueeze, data refreshes will continue to occur once SoftSqueeze is
# closed.  This is because SoftSqueeze is put in "off" state when it is closed, which activates the offsaver. 
#
#	This program is free software; you can redistribute it and/or modify
#	it under the terms of the GNU General Public License as published by
#	the Free Software Foundation; either version 2 of the License, or
#	(at your option) any later version.
#
#	This program is distributed in the hope that it will be useful,
#	but WITHOUT ANY WARRANTY; without even the implied warranty of
#	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#	GNU General Public License for more details.
#
#	You should have received a copy of the GNU General Public License
#	along with this program; if not, write to the Free Software
#	Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA
#	02111-1307 USA
#
# This code is derived from code with the following copyright message:
#
# SliMP3 Server Copyright (C) 2001 Sean Adams, Slim Devices Inc.
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License,
# version 2.

use strict;

package Plugins::SuperDateTime::Plugin;

use Slim::Utils::Misc;
use Slim::Utils::Strings qw (string);
use Slim::Networking::SimpleAsyncHTTP;

use vars qw($VERSION);
$VERSION = substr(q$Revision: 5.0.13 $,10);

sub getDisplayName {
	return 'PLUGIN_SCREENSAVER_SUPERDATETIME';
}

sub strings { return q!
PLUGIN_SCREENSAVER_SUPERDATETIME
	DE	Bildschirmschoner: Datum/Zeit (SuperDateTime)
	EN	SuperDateTime Screensaver
	FR	Ecran de veille Date/Heure
	ES	Salvapantalla SuperFechaHora
	
PLUGIN_SCREENSAVER_SUPERDATETIME_ENABLE
	DE	PLAY drcken zum Aktivieren des Bildschirmschoners
	EN	Press PLAY to enable this screensaver
	ES	Presionar PLAY para habilitar este salvapantalla
	FR	Appuyer sur PLAY pour activer

PLUGIN_SCREENSAVER_SUPERDATETIME_DISABLE
	DE	PLAY drcken zum Deaktivieren dieses Bildschirmschoners 
	EN	Press PLAY to disable this screensaver
	ES	Presionar PLAY para deshabilitar este salvapantalla
	FR	Appuyer sur PLAY pour dsactiver
	
PLUGIN_SCREENSAVER_SUPERDATETIME_ENABLING
	DE	Datum/Zeit Bildschirmschoner aktivieren
	EN	Enabling SuperDateTime as current screensaver
	ES	Habilitando SuperFechaHora como salvapantalla por defecto
	FR	Activation cran de veille Date/Heure

PLUGIN_SCREENSAVER_SUPERDATETIME_DISABLING
	DE	Standard-Bildschirmschoner aktivieren
	EN	Resetting to default screensaver
	ES	Restableciendo salvapantallas por defecto
	FR	Retour  cran de veille par dfaut

SETUP_GROUP_PLUGIN_SCREENSAVER_SUPERDATETIME
	DE	Einstellungen fr den Bildschirmschoner 'Datum/Zeit' (SuperDateTime)
	EN	SuperDateTime Screensaver

SETUP_GROUP_PLUGIN_SCREENSAVER_SUPERDATETIME_DESC
	DE	Zeigt die lokale Zeit, Datum, Wetter, Sport- und Brseninformationen an.<BR><B>Achtung: </B>Es kann bis zu 5min dauern bis Parameternderungen sich auf die Anzeige auswirken. Durch Drcken der +-Fernbedienungstaste wird eine direkte Aktualsierung der Anzeige angestoen. Abhngig von der gewhlten Schriftart und den anzuzeigenden Daten kann Text abgeschnitten oder die Anzeige durchgerollt werden.
	EN	Displays local time, date, weather, sports, and stocks information. <BR><B>Note:</B> Setting changes may take up to 5minutes before the display is updated accordingly. Pressing the + remote button will cause an immediate refresh.  Text scrolling or truncation may occur based on display font and content options chosen.
	ES	Muestra informacin sobre hora local, fecha, clima, y deportes. <BR><B>Nota:</B> Los cambios a la configuracin pueden tardar hata 10 segundos en verse reflejados en la pantalla. De acuerdo a la fuente elegida y la informacin a mostrar, puede producirse truncamiento o desplazamiento de texto.

SETUP_PLUGIN_SCREENSAVER_SUPERDATETIME_CITY
	DE	Stadt
	EN	City
	ES	Ciudad

SETUP_PLUGIN_SCREENSAVER_SUPERDATETIME_CITY_DESC
	DE	Ihre Postleitzahl oder ihr weather.com-Kennzeichen (z.B. Berlin = GMXX0007)
	EN	Your US Zip Code or Weather.com identifier (ie London = UKXX0085)
	ES	Tu cdigo Zip (en EEUU) o identificador en Weather.com (ie Buenos Aires = ARBA0009)

SETUP_PLUGIN_SCREENSAVER_SUPERDATETIME_CITY_CHOOSE
	DE	Postleitzahl oder weather.com-Kennzeichen:
	EN	Zip code or identifier:
	ES	Cdigo Zip o identificador:

SETUP_PLUGIN_SCREENSAVER_SUPERDATETIME_WUNDER
	DE	Underground-Wetter
	EN	Weather Underground

SETUP_PLUGIN_SCREENSAVER_SUPERDATETIME_WUNDER_DESC
	DE	Sie haben die Mglichkeit die Kennziffer einer Undergroud-Wetterstation (www.wunderground.com) anzugeben und die aktuell von weather.com zur Verfgung gestellten Informationen zu berschreiben (z.B. Prenzlauer Berg, Berlin = IBERLIN15)..<BR><B>Achtung: </B>Die Datenfelder von Wetterstationen knnen sich ndern. Wetterdaten von weather.com werden jedoch weiter zur Verfgung gestellt.
	EN	You have the option to supply a wunderground.com weather station to override weather.com current condition data (ie Lakeview, Chicago = KILCHICA42).<BR><B>Note: </B>Data fields supplied by weather stations will vary.  Forecast data will continue to be supplied by weather.com.

SETUP_PLUGIN_SCREENSAVER_SUPERDATETIME_WUNDER_CHOOSE
	DE	Kennzeichen der Underground-Wetterstation:
	EN	Weather station identifier:

SETUP_PLUGIN_SCREENSAVER_SUPERDATETIME_WEATHERFORMAT1T
	DE	Zeit-/Wetterformat Zeile 1
	EN	Line 1 Time/Weather Format String

SETUP_PLUGIN_SCREENSAVER_SUPERDATETIME_WEATHERFORMAT1T_DESC
	DE	Sie knnen hier die in Zeile 1 anzuzeigenden Informationen anpassen. Dies wird durch die Verwendung von speziellen Platzhaltern ermglicht:<BR>Zeit = %1 (nur Zeile 2)<BR>Temperatur (F) = %t<BR>Temperatur (C) = %T<BR>Gefhlte Temperatur (F) = %f<BR>Gefhlte Temperatur (C) = %F<BR>Luftfeuchtigkeit = %h<BR>Windgeschwindigkeit = %w<BR>Luftdruck (inHg) = %p<BR>Luftdruck (hPa) = %P<BR>Tiefsttemperatur (F) = %d<BR>Tiefsttemperatur (C) = %D<BR><BR>Standardformat: %w TP:%D LD:%p<BR><BR><B>Achtung: </B>Durch Drcken der hoch- und runter-Pfeiltasten kann die Informationensanzeige in Zeile 1 umgeschaltet werden.
	EN	You can customize the display of information shown on line one. This is accomplished using macro variables:<BR> Time = %1 (line 2 only)<BR>Temperature (F) = %t<BR>Temperature (C) = %T<BR>Feels-Like Temperature (F) = %f<BR>Feels-Like Temperature (C) = %F<BR>Humidity = %h<BR>Wind Speed = %w<BR>Barometric Pressure (inHg) = %p<BR>Barometric Pressure (hPa) = %P<BR>Dew Point (F) = %d<BR>Dew Point (C) = %D<BR><BR>The default format string is: %w DP:%d P:%p<BR><BR><B>Note:</B> Pressing the up and down remote control buttons will cycle display of custom and pre-defined top line information.

SETUP_PLUGIN_SCREENSAVER_SUPERDATETIME_WEATHERFORMAT1T_CHOOSE
	DE	Zeilenformat Zeile 1 (Anzeige 1):
	EN	Line 1 format string (display 1):

SETUP_PLUGIN_SCREENSAVER_SUPERDATETIME_WEATHERFORMAT1B
	DE	Zeit-/Wetterformat Zeile 2
	EN	Line 2 Time/Weather Format String

SETUP_PLUGIN_SCREENSAVER_SUPERDATETIME_WEATHERFORMAT1B_DESC
	DE	Sie knnen hier die in Zeile 2 anzuzeigenden Informationen anpassen. Dies wird durch die Verwendung der gleichen Platzhaltern wie bei Zeile 1 ermglicht.<BR><BR>Standardformat: %TC/%h     %1
	EN	You can customize the display of information shown on line two. This is accomplished using the same macro variables used on line one.<BR><BR>The default format string is: %t/%h     %1

SETUP_PLUGIN_SCREENSAVER_SUPERDATETIME_WEATHERFORMAT1B_CHOOSE
	DE	Zeilenformat Zeile 2 (Anzeige 1):
	EN	Line 2 format string (display 1):

SETUP_PLUGIN_SCREENSAVER_SUPERDATETIME_WEATHERFORMAT2T
	DE	Zeit-/Wetterformat Zeile 1
	EN	Line 1 Time/Weather Format String

SETUP_PLUGIN_SCREENSAVER_SUPERDATETIME_WEATHERFORMAT2T_DESC
	DE	Bei SqueezeBoxen mit mehreren Anzeigen knnen Sie hier die auf der zweiten Anzeige in Zeile 1 anzuzeigenden Informationen anpassen. Dies wird durch die Verwendung der gleichen Platzhalter wie bei der ersten Anzeige ermglicht.
	EN	For Squeeze Boxes with multiple displays, you can customize the display of information shown on line one of the second display.  This is accomplished using the same macro variables used in display one.

SETUP_PLUGIN_SCREENSAVER_SUPERDATETIME_WEATHERFORMAT2T_CHOOSE
	DE	Zeilenformat Zeile 1 (Anzeige 2):
	EN	Line 1 format string (display 2):

SETUP_PLUGIN_SCREENSAVER_SUPERDATETIME_WEATHERFORMAT2B
	DE	Zeit-/Wetterformat Zeile 2
	EN	Line 2 Time/Weather Format String

SETUP_PLUGIN_SCREENSAVER_SUPERDATETIME_WEATHERFORMAT2B_DESC
	DE	Bei SqueezeBoxen mit mehreren Anzeigen knnen Sie hier die auf der zweiten Anzeige in Zeile 2 anzuzeigenden Informationen anpassen. Dies wird durch die Verwendung der gleichen Platzhalter wie bei der ersten Anzeige ermglicht.
	EN	For Squeeze Boxes with multiple displays, you can customize the display of information shown on line two of the second display.  This is accomplished using the same macro variables used in display one.

SETUP_PLUGIN_SCREENSAVER_SUPERDATETIME_WEATHERFORMAT2B_CHOOSE
	DE	Zeilenformat:
	EN	Line 2 format string (display 2):

SETUP_PLUGIN_SCREENSAVER_SUPERDATETIME_TEMPERATURE
	DE	Temperatureinheit
	EN	Forecast Temperature Unit
	ES	Unidad de Temperatura

SETUP_PLUGIN_SCREENSAVER_SUPERDATETIME_TEMPERATURE_DESC
	DE	Gewhlte Temperatureineit in der Wettervorhersage.
	EN	You have a choice as to which temperature unit is displayed within weather forecasts.
	ES	Se puede elegir entre mostrar la temperatura en grados celsius o fahrenheit.

SETUP_PLUGIN_SCREENSAVER_SUPERDATETIME_TEMPERATURE_CHOOSE
	DE	Temperaturanzeigeeinheit:
	EN	Temperature display:
	ES	Mostrar Temperatura:

SETUP_PLUGIN_SCREENSAVER_SUPERDATETIME_WINDUNIT
	DE	Windgeschwindigkeitseinheit
	EN	Forecast Wind Speed Unit
	ES	Unidad para Velocidad del Viento

SETUP_PLUGIN_SCREENSAVER_SUPERDATETIME_WINDUNIT_DESC
	DE	Gewhlte Windgeschwindigkeitsanzeige in der Wettervorhersage.
	EN	You have a choice as to which wind speed unit is displayed within weather forecasts.
	ES	Se puede elegir entre mostrar la velocidad del viento en millas/hora o kilmetros/hour.

SETUP_PLUGIN_SCREENSAVER_SUPERDATETIME_WINDUNIT_CHOOSE
	DE	Windgeschwindigkeitseinheit:
	EN	Wind speed unit:
	ES	Unidad de velocidad de viento:

SETUP_PLUGIN_SCREENSAVER_SUPERDATETIME_AVERAGES
	DE	Durchschnittstemperaturanzeige
	EN	Show average temperatures

SETUP_PLUGIN_SCREENSAVER_SUPERDATETIME_AVERAGES_DESC
	DE	Durchschnittstemperatur und aufgezeichnete Temperatur in Zeile 1 anzeigen.
	EN	Show average temperature delta and record temperature on the top line.

SETUP_PLUGIN_SCREENSAVER_SUPERDATETIME_AVERAGES_CHOOSE
	DE	Durchschnittstemperaturen anzeigen:
	EN	Show average temperatures:

SETUP_PLUGIN_SCREENSAVER_SUPERDATETIME_OFFSET_CHOOSE
	DE	Zeitzonenoffset:
	EN	Time zone offset:
	ES	Diferencia de huso horario:

SETUP_PLUGIN_SCREENSAVER_SUPERDATETIME_OFFSET
	DE	Zeitzonenoffset
	EN	Time Zone Offset
	ES	Diferencia de Huso Horario

SETUP_PLUGIN_SCREENSAVER_SUPERDATETIME_OFFSET_DESC
	DE	Zeitdifferenz zwischen der lokalen Zeit und der US Eastern-Zeitzone festlegen. Diese Einstellung wird nur fr die Spielzeitanzeige verwendet.
	EN	The number of hours different your local time zone is from the US Eastern time zone.  This setting is only used for gametime display.
	ES	El nmero de horas que separan tu huso horario con el huso horario Este de EEUU. Esta configuracin se utiliza solo para mostrar el horario de los partidos.

SETUP_PLUGIN_SCREENSAVER_SUPERDATETIME_SCROLL
	DE	Textrollen
	EN	Text Scrolling
	ES	Desplazamiento de Texto

SETUP_PLUGIN_SCREENSAVER_SUPERDATETIME_SCROLL_DESC
	DE	Sie knnen entscheiden wie der Anzeigebergang zwischen zwei Spielen aussehen soll.<BR><B>Basic:</B> nderungen werden umgehend angezeigt ohne den Text rollen zu lassen.<BR><B>Slide:</B> nderungen werden in bzw. aus der Anzeige geschoben.<BR><B>Ticker:</B> nderungen werden in bzw. aus der Anzeige gerollt wie ein Aktienticker.
	EN	You have a choice as to how the display transitions from one game to the next.<BR><B>Basic:</B> Changes are immediately displayed with no scrolling.<BR><B>Slide:</B> Changes slide onto and off of the screen.<BR><B>Ticker:</B> Changes scroll onto and off of the screen like a stock ticker.
	ES	Se puede elegir cmo mostrar las transiciones de un partido a otro. <BR><B>Bsico:</B> Los cambios se muestran en forma inmediata sin desplazamiento.<BR><B>Desplazar:</B> Los cambios se desplazan hacia y afuera de la pantalla.

SETUP_PLUGIN_SCREENSAVER_SUPERDATETIME_SCROLL_CHOOSE
	DE	Rolltyp:
	EN	Scroll type:
	ES	Tipo de desplazamiento:

SETUP_PLUGIN_SCREENSAVER_SUPERDATETIME_STOCKS
	DE	Aktien
	EN	Stocks

SETUP_PLUGIN_SCREENSAVER_SUPERDATETIME_STOCKS_DESC
	DE	Sie knnen eine oder mehrere Aktien festlegen zu denen Informationen abgerufen werden sollen.  Trennen Sie mehrere Aktien durch Kommas voneinander.  Die Kursinformatien werden durch finance.yahoo.com zur Verfgung gestellt und jeweils mit einer Zeitverzgerung von 20 Minuten angezeigt.
	EN	You can specify one or more stocks to retrieve information about.  Separate each stock symbol with a comma.  Quotes are supplied by finance.yahoo.com and individual stocks quotes are delayed 20 minutes.

SETUP_PLUGIN_SCREENSAVER_SUPERDATETIME_STOCKS_CHOOSE
	DE	Aktien:
	EN	Stocks:

SETUP_PLUGIN_SCREENSAVER_SUPERDATETIME_STOCK1FORMAT
	DE	Aktienanzeigeformat Zeile 1
	EN	Stock Line 1 Format

SETUP_PLUGIN_SCREENSAVER_SUPERDATETIME_STOCK1FORMAT_DESC
	DE	Sie knnen hier die in Zeile 1 anzuzeigenden Aktieninformationen anpassen. Dies wird durch die Verwendung von speziellen Platzhaltern ermglicht:<BR> Aktiensymbol = %s<BR>Name = %n<BR>Letzter Kurs = %l<BR>Letztes Kursdatum (EST) = %d<BR>Letzte Kurszeit (EST) = %t<BR>Vorheriger Schlusskurs = %p<BR>nderung = %c<BR>Prozentuale nderung = %z<BR>Erffnungskurs = %o<BR>Hchster Kurs = %h<BR>Niedrigster Kurs = %w<BR>Volumen = %v<BR><BR>Standardformat: %n
	EN	You can customize the display of stock information shown on line one. This is accomplished using macro variables:<BR> Ticker Symbol = %s<BR>Name = %n<BR>Last Trade = %l<BR>Last Trade Date (EST) = %d<BR>Last Trade Time (EST) = %t<BR>Previous Close = %p<BR>Change = %c<BR>Percent Change = %z<BR>Open = %o<BR>High = %h<BR>Low = %w<BR>Volume = %v<BR><BR>The default format string is: %n

SETUP_PLUGIN_SCREENSAVER_SUPERDATETIME_STOCK1FORMAT_CHOOSE
	DE	Aktienformat Zeile 1:
	EN	Stock line 1 format string:

SETUP_PLUGIN_SCREENSAVER_SUPERDATETIME_STOCK2FORMAT
	DE	Aktienformat Zeile 2
	EN	Stock Line 2 Format

SETUP_PLUGIN_SCREENSAVER_SUPERDATETIME_STOCK2FORMAT_DESC
	DE	Sie knnen hier die in Zeile 2 anzuzeigenden Aktieninformationen anpassen. Dies wird durch die Verwendung der gleichen Platzhaltern wie bei Zeile 1 ermglicht.<BR><BR>Standardformat: %l %c %z %v
	EN	You can customize the display of stock information shown on line two. This is accomplished using the same macro variables used in line one.<BR><BR>The default format string is: %l %c %z %v

SETUP_PLUGIN_SCREENSAVER_SUPERDATETIME_STOCK2FORMAT_CHOOSE
	DE	Aktienanzeigeformat Zeile 2
	EN	Stock line 2 format string:

SETUP_PLUGIN_SCREENSAVER_SUPERDATETIME_TEAMLOGOS
	DE	BETA-FUNKTION: Mannschaftslogos
	EN	BETA FEATURE: Team Logos

SETUP_PLUGIN_SCREENSAVER_SUPERDATETIME_TEAMLOGOS_DESC
	DE	Sie knnen hier festlegen wann Mannschaftslogos angezeigt werden sollen.<BR><B>Anmerkung:</B> Aktuell werden alle MLB und einige NFL Mannschaften untersttzt. Im Zweizeilenmodus sieht die Anzeige am besten aus.  Falls ein Logo nicht verfgbar ist wird der Mannschaftsnahme angezeigt.
	EN	You have the option on when to display graphical team logos.<BR><B>Note:</B> Currently all MLB and some NFL teams are supported and look best in two line mode.  If an icon is not available the team name will be shown in text.

SETUP_PLUGIN_SCREENSAVER_SUPERDATETIME_TEAMLOGOS_CHOOSE
	DE	Mannschaftslogos:
	EN	Team Logos:

SETUP_PLUGIN_SCREENSAVER_SUPERDATETIME_MLB_DESC
	DE	Die MLB Baseball-Mannschaft(en) ber die sie Informationen emfangen mchten.  Whlen sie "None" um eine Mannschaft zu entfernen oder "All" um alle Manschaften zu beobachten.
	EN	The MLB baseball team(s) you would like to retrieve game data about.  Select "None" to remove a team, or "All" to monitor all teams.
	ES	El/los equipo/s de baseball de los que se quiere mostrar informacin. Elegir "Ninguno" para eliminar un equipo, o "Todos" para monitorear todos los equipos.

SETUP_PLUGIN_SCREENSAVER_SUPERDATETIME_MLB
	DE	MLB Baseball-Mannschaften
	EN	MLB Baseball Teams
	ES	Equipo de Baseball MLB

SETUP_PLUGIN_SCREENSAVER_SUPERDATETIME_MLB_CHOOSE
	DE	Baseball-Mannschaft:
	EN	Baseball team:
	ES	Equipo de baseball:

SETUP_PLUGIN_SCREENSAVER_SUPERDATETIME_NBA_DESC
	DE	Die NBA Basketball-Mannschaft(en) ber die sie Informationen emfangen mchten.  Whlen sie "None" um eine Mannschaft zu entfernen oder "All" um alle Manschaften zu beobachten.
	EN	The NBA basketball team(s) you would like to retrieve game data about.  Select "None" to remove a team, or "All" to monitor all teams.
	ES	El/los equipo/s de basketball de los que se quiere mostrar informacin. Elegir "Ninguno" para eliminar un equipo, o "Todos" para monitorear todos los equipos.

SETUP_PLUGIN_SCREENSAVER_SUPERDATETIME_NBA
	DE	NBA Basketball-Mannschaften
	EN	NBA Basketball Teams
	ES	Equipo de Basketball NBA

SETUP_PLUGIN_SCREENSAVER_SUPERDATETIME_NBA_CHOOSE
	DE	Basketball-Mannschaft:
	EN	Basketball team:
	ES	Equipo de basketball:

SETUP_PLUGIN_SCREENSAVER_SUPERDATETIME_NHL_DESC
	DE	Die NHL Eishockey-Mannschaft(en) ber die sie Informationen emfangen mchten.  Whlen sie "None" um eine Mannschaft zu entfernen oder "All" um alle Manschaften zu beobachten.
	EN	The NHL hockey team(s) you would like to retrieve game data about.  Select "None" to remove a team, or "All" to monitor all teams.
	ES	El/los equipo/s de hockey de los que se quiere mostrar informacin. Elegir "Ninguno" para eliminar un equipo, o "Todos" para monitorear todos los equipos.

SETUP_PLUGIN_SCREENSAVER_SUPERDATETIME_NHL
	DE	NHL Eishockey-Mannschaften
	EN	NHL Hockey Teams
	ES	Equipos de Hockey NHL

SETUP_PLUGIN_SCREENSAVER_SUPERDATETIME_NHL_CHOOSE
	DE	Eishockey-Mannschaft:
	EN	Hockey team:
	ES	Equipo de hockey:

SETUP_PLUGIN_SCREENSAVER_SUPERDATETIME_NFL_DESC
	DE	Die NFL American Football-Mannschaft(en) ber die sie Informationen emfangen mchten.  Whlen sie "None" um eine Mannschaft zu entfernen oder "All" um alle Manschaften zu beobachten.
	EN	The NFL football team(s) you would like to retrieve game data about.  Select "None" to remove a team, or "All" to monitor all teams.
	ES	El/los equipo/s de football americano de los que se quiere mostrar informacin. Elegir "Ninguno" para eliminar un equipo, o "Todos" para monitorear todos los equipos.

SETUP_PLUGIN_SCREENSAVER_SUPERDATETIME_NFL
	DE	NFL American Football-Mannschaften
	EN	NFL Football Teams
	ES	Equipo de Football americano NFL

SETUP_PLUGIN_SCREENSAVER_SUPERDATETIME_NFL_CHOOSE
	DE	American Football-Mannschaft:
	EN	Football team:
	ES	Equipo de football americano:

SETUP_PLUGIN_SCREENSAVER_SUPERDATETIME_CBBALLCONF
	DE	College-Basketball-Konferenz
	EN	College Basketball Conference

SETUP_PLUGIN_SCREENSAVER_SUPERDATETIME_CBBALLCONF_DESC
	DE	Sie knnen whlen zu welcher College-Basketball-Konferenz Datendateien abgerufen werden sollen.<BR><B>Anmerkung:</B> Die Auswahl von "all" kann zum Abruf von sehr groen Dateien fhren und Serverabstrze bei der Datenverarbeitung verursachen.
	EN	You have a choice as to which college basketball conference data file is retrieved.<BR><B>Note:</B> Selecting "all" can result in a large download which may cause brief server hangs while data is being processed.

SETUP_PLUGIN_SCREENSAVER_SUPERDATETIME_CBBALLCONF_CHOOSE
	DE	Konferenz:
	EN	Conference:

SETUP_PLUGIN_SCREENSAVER_SUPERDATETIME_CBB
	DE	College-Basketball-Mannschaften
	EN	College Basketball Teams

SETUP_PLUGIN_SCREENSAVER_SUPERDATETIME_CBB_DESC
	DE	Geben Sie die ESPN Mannschaftsnamen ein deren Spieldaten sie empfangen mchten.  Geben Sie eine Mannschaft pro Zeile ein oder "All" um alle Mannschaften anzuzeigen.
	EN	Enter the ESPN team name of the team(s) you would like to retrieve game data about.  Enter one team per line or "All" to display all teams.

SETUP_PLUGIN_SCREENSAVER_SUPERDATETIME_CFBALLCONF
	DE	College-American Football-Konferenz
	EN	College Football Conference

SETUP_PLUGIN_SCREENSAVER_SUPERDATETIME_CFBALLCONF_DESC
	DE	Sie knnen whlen zu welcher College-American Football-Konferenz Datendateien abgerufen werden sollen.<BR><B>Anmerkung:</B> Die Auswahl von "All Div I-A" oder "All Div I-AA" kann zum Abruf von sehr groen Dateien fhren und Serverabstrze bei der Datenverarbeitung verursachen.
	EN	You have a choice as to which college football conference data file is retrieved.<BR><B>Note:</B> Selecting "All Div I-A"  or "All Div I-AA" can result in a large download which may cause brief server hangs while data is being processed.

SETUP_PLUGIN_SCREENSAVER_SUPERDATETIME_CFBALLCONF_CHOOSE
	DE	Konferenz:
	EN	Conference:

SETUP_PLUGIN_SCREENSAVER_SUPERDATETIME_CFB
	DE	College-American Football-Mannschaften
	EN	College Football Teams

SETUP_PLUGIN_SCREENSAVER_SUPERDATETIME_CFB_DESC
	DE	Geben Sie die ESPN Mannschaftsnamen ein deren Spieldaten sie empfangen mchten.  Geben Sie eine Mannschaft pro Zeile ein oder "All" um alle Mannschaften anzuzeigen.
	EN	Enter the ESPN team name of the team(s) you would like to retrieve game data about.  Enter one team per line or "All" to display all teams.

SETUP_PLUGIN_SCREENSAVER_SUPERDATETIME_TIME
	DE	Zeitintervall
	EN	Time Interval
	ES	Intervalo de Tiempo

SETUP_PLUGIN_SCREENSAVER_SUPERDATETIME_TIME_DESC
	DE	Anzahl Sekunden nach denen zur Zeitanzeige gewechselt werden soll wenn kein Spiel aktiv ist.
	EN	Number of seconds to display time information before cycling when no games are active. 
	ES	Nmero de segundos durante los cuales mostrar la informacin antes de ciclar cuando no hay partidos disputndose.

SETUP_PLUGIN_SCREENSAVER_SUPERDATETIME_TIME_CHOOSE
	DE	Zeitintervall in Sekunden:
	EN	Time interval in seconds:
	ES	Intervalo de Tiempo en segundos:

SETUP_PLUGIN_SCREENSAVER_SUPERDATETIME_ATIME
	DE	Zeitintervall (aktives Spiel)
	EN	Time Interval (Active Game)
	ES	Intervalo de Tiempo (Partido Disputndose)

SETUP_PLUGIN_SCREENSAVER_SUPERDATETIME_ATIME_DESC
	DE	Anzahl Sekunden nach denen zur Zeitanzeige gewechselt werden soll wenn ein Spiel aktiv ist.
	EN	Number of seconds to display time information before cycling when a game is active. 
	ES	Nmero de segundos durante los cuales mostrar la informacin antes de ciclar cuando hay algn partido disputndose.

SETUP_PLUGIN_SCREENSAVER_SUPERDATETIME_ATIME_CHOOSE
	DE	Zeitintervall in Sekunden:
	EN	Time interval in seconds:
	ES	Intervalo de Tiempo en segundos:

SETUP_PLUGIN_SCREENSAVER_SUPERDATETIME_SCORE
	DE	Zeitintervall kommender und beendeter Spiele
	EN	Upcoming/Completed Game Interval
	ES	Intervalo para Partidos Terminados/Por empezar

SETUP_PLUGIN_SCREENSAVER_SUPERDATETIME_SCORE_DESC
	DE	Anzahl Sekunden whrend denen Informationen ber zuknftige oder bereits beendete Spiele angezeigt werden sollen bevor die Anzeige gewechselt wird.
	EN	Number of seconds to display upcoming or completed game information before cycling. 
	ES	Nmero de segundos durante los cuales mostrar la informacin sobre partidos terminados o por empezar, antes de ciclar.

SETUP_PLUGIN_SCREENSAVER_SUPERDATETIME_SCORE_CHOOSE
	DE	Zeitintervall in Sekunden:
	EN	Time interval in seconds:
	ES	Intervalo de Tiempo en segundos:

SETUP_PLUGIN_SCREENSAVER_SUPERDATETIME_ASCORE
	DE	Interval der Ergebnisanzeige bei aktiven Spielen
	EN	Active Game Score Interval
	ES	Intervalo para Tanteador de Partido en Juego

SETUP_PLUGIN_SCREENSAVER_SUPERDATETIME_ASCORE_DESC
	DE	Anzahl Sekunden whrend denen das Ergebnis eines aktiven Spiels angezeigt werden soll bevor die Anzeige gewechselt wird.
	EN	Number of seconds to display an active game's score information before cycling. 
	ES	Nmero de segundos durante los cuales mostrar la informacin del tanteador del partido en juego, antes de ciclar.

SETUP_PLUGIN_SCREENSAVER_SUPERDATETIME_ASCORE_CHOOSE
	DE	Zeitintervall in Sekunden:
	EN	Time interval in seconds:
	ES	Intervalo de Tiempo en segundos:

SETUP_PLUGIN_SCREENSAVER_SUPERDATETIME_REFRESH
	DE	Datenaktualisierungsintervall
	EN	Data Refresh Interval
	ES	Intervalo de Refresco de Datos

SETUP_PLUGIN_SCREENSAVER_SUPERDATETIME_REFRESH_DESC
	DE	Anzahl der Minuten bevor externe Daten aktualsiert werden.
	EN	Number of minutes before external data is refreshed. 
	ES	Nmero de minutos antes que se refresque la informacin del clima y deportiva.

SETUP_PLUGIN_SCREENSAVER_SUPERDATETIME_REFRESH_CHOOSE
	DE	Aktualisierungsintervall in Minuten:
	EN	Refresh interval in minutes:
	ES	Intervalo de refresco en minutos:

SETUP_PLUGIN_SCREENSAVER_SUPERDATETIME_LWEATHER
	DE	Anzeige der ausfhrlichen Wettervorhersage
	EN	Long Weather Forecast Display

SETUP_PLUGIN_SCREENSAVER_SUPERDATETIME_LWEATHER_DESC
	DE	Sie knnen whlen wann die ausfhrliche Wettervorhersage angezeigt werden soll.<BR><B>Anmerkung:</B> Ungeachtet dieser Einstellung kann die ausfhrliche Wettervorhersage jederzeit durch Drcken des FWD und REW Knopfes auf der Fernbedienung angezeigt werden.
	EN	You have a choice as to when long weather forecasts are displayed.<BR><B>Note:</B> Regardless of this setting, long weather forecasts are always viewable via the FWD and REW remote control buttons.

SETUP_PLUGIN_SCREENSAVER_SUPERDATETIME_LWEATHER_CHOOSE
	DE	Ausfhrliche Wettervorhersage:
	EN	Long Weather Forecasts:
	ES	Intervalo de Tiempo en segundos:

!};

##################################################
### Super Variables ###  DEFAULT VALUES
##################################################

#What icon information should be used when the time is shown on a non-Transporter using the large font.
#Set to 7 for current condition icon only
#Set to 1 for current condition and hi/low and precip. info
#Set to 12 for no icons or hi/low and precip info.
my $largeFontTimeIcon = 7;

my $weatherFormat1t = '%w DP:%d P:%p';	# default Weather display format - Line 1 display 1
my $weatherFormat1b = '%t/%h     %1';	# default Weather display format - Line 2 display 1
my $weatherFormat2t = 'DP:%d P:%p';	   # default Weather display format - Line 1 display 2
my $weatherFormat2b = '%t/%h/%w';	# default Weather display format - Line 2 display 2

my $stockFormat1 = '%n';
my $stockFormat2 = '%l %c %z %v';

my $line1; #Used to store previous value of display line 1 during ticker display
my $killTicker = 0; #Flag used to exit out of ticker mode

my $windspeedUnit = 0; #0 for miles, 1 for kilometers
my $show_averages = 0; #Show averages
my $temptype = 0;
my $status = '';  #Used for the status indicator
my $overlay = ''; #Used to show alarm indicator
my $timeoffset = 0; #Time zone offset from eastern time
my $city = 60614; #Defaults to Chicago
my $wunderIdent = ''; #wundgerground identifier
my $showtime = 5; #How long to show the time when no games are active
my $showgame = 3; #How long to show an upcoming/completed game
my $showactivetime = 5; #How long to show the time when games are active
my $showactivegame = 3; #How long to show an active game
my $activeGames = 0; #Flag set if any games are active
my $newActiveGames; #Flag set during a data refresh if any games are active
my $lweather = 1; #Used to determine when long forecasts are displayed
my $scrollType = 'Slide'; #Type of display scrolling between games
my $cbballconf = 0; #NCAA BBALL conference file to retrieve
my $cfballconf = 0; #NCAA FBALL conference file to retrieve
my $stocks; #Stocks being tracked by ticker

my $errorCount = 0; #Used to keep track of network errors

my $refreshint = 5; #Time interval between data refreshes (in minutes)
my $refreshCounter; #How many data refreshes are still active
my $activeClients = 0; #Number of players currently displaying SuperDateTime

my %nowshowing;
my %weathershowing; #Used for when the user chooses to just view the long weather forecasts via remote
my %topNowShowing; #Which item is being shown on top line during time display
my %displayGameID; #Current game number displaying by sport
my %displayLine1; #What is currently being shown on the display line 1
my %displayLine2; #What is currently being shown on the display line 2

my $weatherString1b = '%1'; #Display the time initially
my $weatherString2t = '';
my $weatherString2b = '';

my $showGraphics = 1;

#Track the average high/low for today/tomorrow
my %averages = ();
$averages{'last'} = "";			# prep for data reload

my $teamLogos = '0'; #Show graphical team logos

#Arrays to contain bottom display lines for each sport
my @MLBdisplayItems1 = ();
my @MLBdisplayItems2 = ();
my @divideMLB = (); #Array used to divide MLB processing
my @NBAdisplayItems1 = ();
my @NBAdisplayItems2 = ();
my @NHLdisplayItems1 = ();
my @NHLdisplayItems2 = ();
my @NFLdisplayItems1 = ();
my @NFLdisplayItems2 = ();
my @CBBdisplayItems1 = ();
my @CBBdisplayItems2 = ();
my @CFBdisplayItems1 = ();
my @CFBdisplayItems2 = ();
my @WETdisplayItems1 = (); #Not currently used.  Convert TOPdisplayItems to use this?
my @WETdisplayItems2 = ();
my @STKdisplayItems1 = (); #Line 1 for stocks
my @STKdisplayItems2 = (); #Line 2 for stocks

my @displayItems2;
$displayItems2[0] =\@MLBdisplayItems2;
$displayItems2[1] =\@NBAdisplayItems2;
$displayItems2[2] =\@NHLdisplayItems2;
$displayItems2[3] =\@NFLdisplayItems2;
$displayItems2[4] =\@CBBdisplayItems2;
$displayItems2[5] =\@CFBdisplayItems2;
$displayItems2[6] =\@STKdisplayItems2;
$displayItems2[7] =\@WETdisplayItems2;

my @displayItems1;
$displayItems1[0] =\@MLBdisplayItems1;
$displayItems1[1] =\@NBAdisplayItems1;
$displayItems1[2] =\@NHLdisplayItems1;
$displayItems1[3] =\@NFLdisplayItems1;
$displayItems1[4] =\@CBBdisplayItems1;
$displayItems1[5] =\@CFBdisplayItems1;
$displayItems1[6] =\@STKdisplayItems1;
$displayItems1[7] =\@WETdisplayItems1;

my @TOPdisplayItems = (); #Array for top line display items shown with time
my @precipItems = ();
my @btmLinePreSpace = (); #Array of blank spaces to append before bottom line text
my $iconPreSpace  = '                   '; #Blank spaces to append before bottom line text when displaying an icon w/3line txt
my $icon2PreSpace = '        ';   #Blank spaces to append before bottom line text when displaying an icon wo/3line txt

#Arrays to contain the display intervals for corresponding display lines
my @MLBdisplayIntervals = ();
my @NBAdisplayIntervals = ();
my @NHLdisplayIntervals = ();
my @NFLdisplayIntervals = ();
my @CBBdisplayIntervals = ();
my @CFBdisplayIntervals = ();
#my @WETdisplayIntervals = (); #STUB --NOT CURRENTLY USED
my @STKdisplayIntervals = ();

my @displayIntervals;
$displayIntervals[0] =\@MLBdisplayIntervals;
$displayIntervals[1] =\@NBAdisplayIntervals;
$displayIntervals[2] =\@NHLdisplayIntervals;
$displayIntervals[3] =\@NFLdisplayIntervals;
$displayIntervals[4] =\@CBBdisplayIntervals;
$displayIntervals[5] =\@CFBdisplayIntervals;
$displayIntervals[6] =\@STKdisplayIntervals;
#$displayIntervals[7] =\@WETdisplayIntervals; #STUB --NOT CURRENTLY USED

my @refreshTracker = (); #Used to keep track of which fields to continue to refresh
my $lastRefresh = ''; #Date that pertains to @refreshTracker data

#Arrays to contain the user selected teams to monitor for each sport
my @MLBteams = ();
my %MLBmap = ('Cubs'  => 10, 'White Sox'  => 11, 'Atlanta' => 12, 'San Francisco' => 13, 'LA Angels' => 14, 'Detroit' => 15, 'Houston' => 16, 'Cincinnati' => 17, 'Arizona' => 18, 'Minnesota' => 19, 'Tampa Bay' => 20, 'Boston' => 21, 'Cleveland' => 22, 'Texas' => 24, 'NY Yankees' => 25, 'Baltimore' => 26, 'Toronto' => 27, 'Kansas City' => 28, 'Oakland' => 29, 'Seattle' => 30, 'Pittsburgh' => 31, 'NY Mets' => 32, 'Philadelphia' => 33, 'Florida' => 34, 'Washington' => 35, "Milwaukee" => 36, 'St. Louis' => 37, 'LA Dodgers' => 38, 'San Diego' => 39, 'Colorado' => 40 ); #Graphical icon mapping
my @NBAteams = ();
my @NHLteams = ();
my @NFLteams = ();
my %NFLmap = ('Chicago'  => 10, 'Detroit'  => 11, 'Green Bay' => 12);
my @CBBteams = ();
my @CFBteams = ();


#Graphical display stuff
my %xmax = ();
my %ymax = ();
my @forecastG = ();
my @forecastIcon = ();
my %hashDisp;

my $gxwidth = 125;

#
# Map ASCII characters to custom @Charset elements
#
my %Codepage = ( ' ' =>  0, '1' =>  1, '2' =>  2, '3' =>  3, '4' =>  4,
                 '5' =>  5, '6' =>  6, '7' =>  7, '8' =>  8, '9' =>  9,
                 '0' => 10, '-' => 11, 'g' => 12, '.' => 13, '%' => 14,
                 'A' => 15, 'B' => 16, 'C' => 17, 'D' => 18, 'E' => 19,
                 'F' => 20, 'G' => 21, 'H' => 22, 'I' => 23, 'J' => 24,
                 'K' => 25, 'L' => 26, 'M' => 27, 'N' => 28, 'O' => 29,
                 'P' => 30, 'Q' => 31, 'R' => 32, 'S' => 33, 'T' => 34,
                 'U' => 35, 'V' => 36, 'W' => 37, 'X' => 38, 'Y' => 39,
                 'Z' => 40, '/' => 41 );

#
# Custom 7x5 mono charset for 3-line forecast display on Squeezebox2
#
my @Charset = ('







','
  *
 **
* *
  *
  *
  *
*****
','
 ***
*   *
    *
   *
  *
 *
*****
','
 ***
*   *
    *
  **
    *
*   *
 ***
','
   *
  **
 * *
*****
   *
   *
   *
','
*****
*
*
****
    *
*   *
 ***
','
 ***
*
*
****
*   *
*   *
 ***
','
*****
    *
    *
   *
  *
 *
*
','
 ***
*   *
*   *
 ***
*   *
*   *
 ***
','
 ***
*   *
*   *
 ****
    *
    *
 ***
','
 ***
*   *
*   *
*   *
*   *
*   *
 ***
','



 ****



','
 **
*  *
*  *
 **



','





  **
  **
','
**   
**  *
   *
  *
 *
*  **
   **
','
 ***
*   *
*   *
*****
*   *
*   *
*   *
','
****
*   *
*   *
****
*   *
*   *
****
','
 ***
*   *
*
*
*
*   *
 ***
','
****
*   *
*   *
*   *
*   *
*   *
****
','
*****
*
*
****
*
*
*****
','
*****
*
*
****
*
*
*
','
 ***
*   *
*
* ***
*   *
*   *
 ***
','
*   *
*   *
*   *
*****
*   *
*   *
*   *
','
 ***
  *
  *
  *
  *
  *
 ***
','
    *
    *
    *
    *
    *
*   *
 ***
','
*   *
*  *
* *
**
* *
*  *
*   *
','
*
*
*
*
*
*
*****
','
*   *
** **
* * *
*   *
*   *
*   *
*   *
','
*   *
*   *
**  *
* * *
*  **
*   *
*   *
','
 ***
*   *
*   *
*   *
*   *
*   *
 ***
','
****
*   *
*   *
****
*
*
*
','
 ***
*   *
*   *
*   *
*   *
* * *
*  **
 ** *
','
****
*   *
*   *
****
* *
*  *
*   *
','
 ****
*
*
 ***
    *
    *
****
','
*****
  *
  *
  *
  *
  *
  *
','
*   *
*   *
*   *
*   *
*   *
*   *
 *** 
','
*   *
*   *
*   *
*   *
*   *
 * *
  *
','
*   *
*   *
*   *
*   *
* * *
** **
*   *
','
*   *
*   * 
 * * 
  *  
 * * 
*   * 
*   *
','
*   *
*   *
 * *
  *
  *
  *
  *
','
*****
    *
   *
  *
 *
*
*****
','

    *
   *
  *
 *
*

');

#
# map standard weather.com icons to custom icons
#
my %Iconmap = ( '1'  => 2, '2'  => 2, '3'  => 2, '4'  => 2, '5'  => 23, 
                '6'  => 27,'7'  => 24,'8'  => 3, '9'  => 1, '10' => 3, 
                '11' => 25,'12' => 1, '13' => 18,'14' => 3, '15' => 19, 
                '16' => 20,'17' => 2, '18' => 26,'19' => 32,'20' => 33, 
                '21' => 10,'22' => 9, '23' => 11,'24' => 11,'25' => 30, 
                '26' => 0, '27' => 14,'28' => 6, '29' => 13,'30' => 5, 
                '31' => 12,'32' => 4, '33' => 13,'34' => 5, '35' => 2, 
                '36' => 31,'37' => 8, '38' => 8, '39' => 7, '40' => 28, 
                '41' => 21,'42' => 22,'43' => 22,'44' => 9, '45' => 15, 
                '46' => 16,'47' => 17,'48' => 29, '0' => 2, 'na' => 9,
                'NA' => 9, 'N/A' => 9 );

#
# Custom weather condition icons (40x32 pixel)
#
#234567890123456789012345678901234567890 - icon 0
my @Icons = ('





              ****
           ****  ****
        ****        **
       **            **
      **              **
     **                ** ***
     *                  *** **
  ****                   *   **
 **                           *
**                            **
*                              ***
*                                **
*                                 *
**                               **
 ***                            **
   ******************************
',
#234567890123456789012345678901234567890 - icon 1
'





              ****
           ****  ****
        ****        **
       **            **
      **              **
     **                ** ***
     *                  *** **
  ****                   *   **
 **                           *
**                            **
*                              ***
*                                **
*                                 *
**                               **
 ***                            **
   ******************************

     *         *        *
     *         *   *    *
    *    *    *    *   *
    *    *    *   *    *    *
   *    *    *    *    *    *
   *         *        *    *
  *         *         *    *
',
#234567890123456789012345678901234567890 - icon 2
'





              ****
           ****  ****
        ****        **
       **            **
      **              **
     **     **         ** ***
     *      **          *** **
  ****     **            *   **
 **        **                 *
**        **                  **
*         **                   ***
*        ** **                   **
*        ******                   *
**       *** **                  **
 ***        **                  **
   ******************************
           **
          **
     *    **   *        *
     * * **    *   *    *
    *  ****   *    *   *
    *  *****  *   *    *    *
   *    **   *    *    *    *
   *    *    *        *    *
  *         *         *    *
',
#234567890123456789012345678901234567890 - icon 3
'





              ****
           ****  ****
        ****        **
       **            **
      **              **
     **                ** ***
     *                  *** **
  ****                   *   **
 **                           *
**                            **
*                              ***
*                                **
*                                 *
**                               **
 ***                            **
   ******************************

                           * *
      * *                *  *  *
    *  *  *               * * *
     * * *      * *      * *** *
    * *** *   *  *  *     * * *
     * * *     * * *     *  *  *
    *  *  *   * *** *      * *
      * *      * * *
              *  *  *
                * *
',
#234567890123456789012345678901234567890 - icon 4
'
                     *
        *            *
         *          *
          *         *
          *         *
           *       *          *
            *      *         *
                           **
                          *
 *            *****      *
  **        *********
    **     ***********
      *   *************
          *************
         ***************
         ***************
         ***************  *******
         ***************
         ***************
    ***   *************
****      *************
           ***********
            *********
              *****      *
                          *
           *               **
          *       *          *
         *        *           *
         *        *
        *          *
       *           *
                   *
',
#234567890123456789012345678901234567890 - icon 5
'
                     *
        *            *
         *          *
          *         *
          *         *
           *       *          *
            *      *         *
                           **
                          *
 *            *****      *
  **        *********
    **     *********** ****
      *   **********  **   *
          *********         **
         *********           * **
         *******              *  *
         ******                  **
         *****                    **
         *****                     *
    ***   *****                    *
****      *************************
           ***********
            *********
              *****      *
                          *
           *               **
          *       *          *
         *        *           *
         *        *
        *          *
       *           *
                   *
',
#234567890123456789012345678901234567890 - icon 6
'
                  *       *        *
                   *      *       *
                   *      *       *
                    *     *      *
                                *
              ****     *******
           ****  **** *********
        ****        ************     **
       **            ************  **
      **              ***********
     **                **********
     *                  *** *****
  ****                   *   ****
 **                           *** *
**                            ***  **
*                              ***   **
*                                **
*                                 *
**                               **
 ***                            **
   ******************************
',
#234567890123456789012345678901234567890 - icon 7
'
                  *       *        *
                   *      *       *
                   *      *       *
                    *     *      *
                                *
              ****     *******
           ****  **** *********
        ****        ************     **
       **            ************  **
      **              ***********
     **                **********
     *                  *** *****
  ****                   *   ****
 **                           *** *
**                            ***  **
*                              ***   **
*                                **
*                                 *
**                               **
 ***                            **
   ******************************

     *         *        *
     *         *   *    *
    *    *    *    *   *
    *    *    *   *    *    *
   *    *    *    *    *    *
   *         *        *    *
  *         *         *    *
',
#234567890123456789012345678901234567890 - icon 8
'
                  *       *        *
                   *      *       *
                   *      *       *
                    *     *      *
                                *
              ****     *******
           ****  **** *********
        ****        ************     **
       **            ************  **
      **              ***********
     **     **         **********
     *      **          *** *****
  ****     **            *   ****
 **        **                 *** *
**        **                  ***  **
*         **                   ***   **
*        ** **                   **
*        ******                   *
**       *** **                  **
 ***        **                  **
   ******************************
           **
          **
     *    **   *        *
     * * **    *   *    *
    *  ****   *    *   *
    *  *****  *   *    *    *
   *    **   *    *    *    *
   *    *    *        *    *
  *         *         *    *
',
#234567890123456789012345678901234567890 - icon 9
'






                *****
              *********
             ***    ***
             *       ***
                     ***
                     ***
                    ****
                   ****
                  ****
                 ****
                 ***
                ***
                ***
                ***
                ***


                ***
                ***
                ***
',
#234567890123456789012345678901234567890 - icon 10
'




    
 
                               
**   **    *     ****** **   **
**   **   ***        ** **   **
**   **   * *       **   ** **
*******  **  *     **     ***
**   **  *****    **       *
**   **  *   *   **        *
**   ** *     * **         *
**   ** *     * ********   *
  
  *     *     *    *     *                
    *      *     *    *      *  
 *     *  *       *       * 
     *       *         *    *      
      *            *        
    *       *           *

  *       *       *        *              
                
      *       *        *          
                 
           *       *         
',
#234567890123456789012345678901234567890 - icon 11 - Windy - Thanks Yannzola
'
                       *
        *****          **
       **   **         **
      **     *         ******
      *      ****      ******
      *         **     ******
   ****          *     ******
  **           ******* **********
 **                    **********
 *                     **********
 *          ********** **********
 **                    **************
  ***                  **************
    ****************** **************
                       **************
                       ****************
         *******       *****************
        **     **     **
        *       **   **
       **    *   *  **
       *    **     **
       *    *     **
   *****    **   **
  **         ** **   ************
 **           ***
 *
 *
 *             ************************
 *
 **
  ***
    *****************************
',
#234567890123456789012345678901234567890 - icon 12
'
                     
        
         
          
          
           
          
                     
                          
              *****      
            **     **
           *     *   *
          *     * **  *
          *           *
         *          *  *
         *    *        *
         *   **   *    *  
         **   *  ***   *
         ***     *    *
          **    **    *
          ** ***      *
           ****   *  *
            **  ** **
              *****      
                          
          
         
      
        
        
       
                   
',
#234567890123456789012345678901234567890 - icon 13
'
                     
        
         
          
          
           
          
                     
                          
              *****      
            **     **
           *        ** ****
          *        *  **   *
          *       *         **
         *      **           * **
         *     *              *  *
         *    *                  **
         *   *                    **
         *   *                     *
          *   *                    *
          *   *********************
           *         *
            **     **
              *****      
                          
          
         
      
        
        
       
                   
',
#234567890123456789012345678901234567890 - icon 14
'
                  
                   
                   
                               
                         *****       
              ****     **     **
           ****  **** *         *
        ****        **           *     
       **            **          *  
      **              **         *
     **                ** ***    *
     *                  *** **   *
  ****                   *   *  *
 **                           ** 
**                            **   
*                              ***   
*                                **
*                                 *
**                               **
 ***                            **
   ******************************
',
#234567890123456789012345678901234567890 - icon 15
'
                  
                   
                   
                               
                         *****       
              ****     **     **
           ****  **** *         *
        ****        **           *     
       **            **          *  
      **              **         *
     **                ** ***    *
     *                  *** **   *
  ****                   *   *  *
 **                           ** 
**                            **   
*                              ***   
*                                **
*                                 *
**                               **
 ***                            **
   ******************************

     *         *        *
     *         *   *    *
    *    *    *    *   *
    *    *    *   *    *    *
   *    *    *    *    *    *
   *         *        *    *
  *         *         *    *
',
#234567890123456789012345678901234567890 - icon 16
'
                  
                   
                   
                               
                         *****       
              ****     **     **
           ****  **** *         *
        ****        **           *     
       **            **          *  
      **              **         *
     **                ** ***    *
     *                  *** **   *
  ****                   *   *  *
 **                           ** 
**                            **   
*                              ***   
*                                **
*                                 *
**                               **
 ***                            **
   ******************************

                           * *
      * *                *  *  *
    *  *  *               * * *
     * * *      * *      * *** *
    * *** *   *  *  *     * * *
     * * *     * * *     *  *  *
    *  *  *   * *** *      * *
      * *      * * *
              *  *  *
                * *
',
#234567890123456789012345678901234567890 - icon 17
'
                  
                   
                   
                               
                         *****       
              ****     **     **
           ****  **** *         *
        ****        **           *     
       **            **          *  
      **              **         *
     **     **         ** ***    *
     *      **          *** **   *
  ****     **            *   *  *
 **        **                 ** 
**        **                  **   
*         **                   ***   
*        ** **                   **
*        ******                   *
**       *** **                  **
 ***        **                  **
   ******************************
           **
          **
     *    **   *        *
     * * **    *   *    *
    *  ****   *    *   *
    *  *****  *   *    *    *
   *    **   *    *    *    *
   *    *    *        *    *
  *         *         *    *
',
#234567890123456789012345678901234567890 - icon 18
'





              ****
           ****  ****
        ****        **
       **            **
      **              **
     **                ** ***
     *                  *** **
  ****                   *   **
 **                           *
**                            **
*                              ***
*                                **
*                                 *
**                               **
 ***                            **
   ******************************

                         * *
                       *  *  *
                        * * *
                       * *** *
                        * * *
                       *  *  *
                         * *
                    
                     
                   
',
#234567890123456789012345678901234567890 - icon 19
'












                    * *
                  *  *  *
                   * * *
                  * *** *
                   * * *
                  *  *  * 
                    * *    * *
      * *                *  *  *
    *  *  *               * * *
     * * *      * *      * *** *
    * *** *   *  *  *     * * *
     * * *     * * *     *  *  *
    *  *  *   * *** *      * *
      * *      * * *
              *  *  *
                * *




',
#234567890123456789012345678901234567890 - icon 20
'




              ****
           ****  ****
        ****        **
       **            **
      **              **
     **                ** ***
     *                  *** **
  ****                   *   **
 **                           *
**                            **
*                              ***
*                                **
*                                 *
**                               **
 ***                            **
   ******************************
        *  *  *     * * *
         * * *     *  *  *
        * *** *      * *    * *
   * *   * * *            *  *  *
 *  *  **  *  *            * * *
  * * *   * *   * *       * *** *
 * *** *      *  *  *      * * *
  * * *        * * *      *  *  *
 *  *  *      * *** *       * *
   * *         * * *
              *  *  *
                * *
',
#234567890123456789012345678901234567890 - icon 21
'
                  *       *        *
                   *      *       *
                   *      *       *
                    *     *      *
                                *
              ****     *******
           ****  **** *********
        ****        ************     **
       **            ************  **
      **              ***********
     **                **********
     *                  *** *****
  ****                   *   ****
 **                           *** *
**                            ***  **
*                              ***   **
*                                **
*                                 *
**                               **
 ***                            **
   ******************************

                           * *
      * *                *  *  *
    *  *  *               * * *
     * * *      * *      * *** *
    * *** *   *  *  *     * * *
     * * *     * * *     *  *  *
    *  *  *   * *** *      * *
      * *      * * *
              *  *  *
                * *   
',
#234567890123456789012345678901234567890 - icon 22
'

              ****
           ****  ****
        ****        **
       **            **
      **              **
     **                ** ***
     *                  *** **
  ****                   *   **
 **                           *
**                            **
*                              ***
*                                **
*                                 *
**                               **
 ***                            **
   ******************************
  * *** *         *  *  *   * * *
   * * *           * * *   *  *  *
  *  *  *         * *** *    * *
    * *  *  *  *   * * *
          * * *   *  *  *
         * *** *    * *     * *
   * *    * * *           *  *  *
 *  *  * *  *  *           * * *
  * * *    * *  * *       * *** *
 * *** *      *  *  *      * * *
  * * *        * * *      *  *  *
 *  *  *      * *** *       * *
   * *         * * *
              *  *  *
                * *
',
#234567890123456789012345678901234567890 - icon 23
'

              ****
           ****  ****
        ****        **
       **            **
      **              **
     **                ** ***
     *                  *** **
  ****                   *   **
 **                           *
**                            **
*                              ***
*                                **
*                                 *
**                               **
 ***                            **
   ******************************
   * *** *    *    *  *  *       
    * * *     *     * * *     *        
   *  *  *   *     * *** *   *         
     * *     *      * * *    *      
  *         *      *  *  *  *    
 *          *        * *    *
    * *                   
  *  *  *    *             
   * * *    *    * *       
  * *** *   *  *  *  *   *
   * * *   *    * * *    *
  *  *  *  *   * *** *  *    
 *  * *   *     * * *   *     
*         *    *  *  * *      
*                * *   *     
',
#234567890123456789012345678901234567890 - icon 24
'

              ****
           ****  ****
        ****        **
       **            **
      **              **
     **                ** ***
     *                  *** **
  ****                   *   **
 **                           *
**                            **
*                              ***
*                                **
*                                 *
**                               **
 ***                            **
   ******************************
      *                 *  *         
      *  *  *  *  *          *          
  *  *   *   * * *     *  * *  *
 *   *  *   * *** *         *  *    
 *      *    * * *   *  *  *  *
*      *    *  *  *        *    
*  *   *      * *   *  *  *  
   *  *                      *
  *       * *      *  *     *
  *   * *  *  *         *   * 
 *    *  * * *   *  *  *   *  
 *   *  * *** *        *   *  
*    *   * * *  *  *  *   *
    *   *  *  *       *     
    *     * *  *  *  *       
',
#234567890123456789012345678901234567890 - icon 25
'





              ****
           ****  ****
        ****        **
       **            **
      **              **
     **                ** ***
     *                  *** **
  ****                   *   **
 **                           *
**                            **
*                              ***
*                                **
*                                 *
**                               **
 ***                            **
   ******************************
       *    *    *    *    *         
                             
       *    *    *    *    * 
                           
     *    *    *    *    *  
                           
     *    *    *    *    *  
                           
    *         *        *   
                                             
                      
',
#234567890123456789012345678901234567890 - icon 26
'




              ****
           ****  ****
        ****        **
       **            **
      **              **
     **                ** ***
     *                  *** **
  ****                   *   **
 **                           *
**                            **
*                              ***
*                                **
*                                 *
**                               **
 ***                            **
   ******************************
     *     *     *     *     *         
        *     *     *     *      
     *     *     *     *     * 
        *     *     *     *    
     *     *     *     *     *  
        *     *     *     *   
     *     *     *     *     *  
        *     *     *     *   
     *     *     *     *     *   
        *     *     *     *    
                       
                      
',
#234567890123456789012345678901234567890 - icon 27
'





              ****
           ****  ****
        ****        **
       **            **
      **              **
     **                ** ***
     *                  *** **
  ****                   *   **
 **                           *
**                            **
*                              ***
*                                **
*                                 *
**                               **
 ***                            **
   ******************************
         *   *  *   *     *   *
     *     *   * *    * *
     * *     * *   *    *  * *
    *    * *  * *  *   *
    * *  *    *   * *  *  * *
   *    *  * *  * *    *    *
   *         *        *    *
  *  *   *  *   *  *  *  * *                    
',
#234567890123456789012345678901234567890 - icon 28
'





              ****
           ****  ****
        ****        **
       **            **
      **              **
     **                ** ***
     *                  *** **
  ****                   *   **
 **                           *
**                            **
*                              ***
*                                **
*                                 *
**                               **
 ***                            **
   ******************************
       *    *    *    *     *
    *  *    *    *    * *   *
    * *    *  * * *  *  *  *
   *  * *  * *  * *  * *   *
   * *  * *  * * *  *  *  *  *
  *  * *  * *  * *  *  *  *  *
  * *  *    *   *  *  *  *  *
 *    *    *    *     *     *
',
#234567890123456789012345678901234567890 - icon 29
'
                  *       *        *
                   *      *       *
                   *      *       *
                    *     *      *
                                *
              ****     *******
           ****  **** *********
        ****        ************     **
       **            ************  **
      **              ***********
     **                **********
     *                  *** *****
  ****                   *   ****
 **                           *** *
**                            ***  **
*                              ***   **
*                                **
*                                 *
**                               **
 ***                            **
   ******************************
       *    *    *    *     *
    *  *    *    *    * *   *
    * *    *  * * *  *  *  *
   *  * *  * *  * *  * *   *
   * *  * *  * * *  *  *  *  *
  *  * *  * *  * *  *  *  *  *
  * *  *    *   *  *  *  *  *
 *    *    *    *     *     *
',
#234567890123456789012345678901234567890 - icon 30 Frigid - Thanks Yannzola
'


    *****                 *
   **   **                *
   *     *            *   *   *
   * *** *            *** * ***
   * *   *         *    *****    *
   * **  *         *     ***     *
   * *   *         *      *      *
   * *** *    ***  *      *      *  ***
   * *   *      ****      *      ****
   * **  *        ***     *      **
   * *   *      *** ***   *   *** ***
   * *** *    ***     *** * ***     ***
   * *   *              *****
   * **  *               ***
   * *   *              *****
   * *** *    ***     *** * ***     ***
   * *   *      *** ***   *   *** ***
   * **  *        ***     *     ***
   * *   *      ****      *      ****
   * *** *    ***  *      *      *  ***
  ** *** **        *      *      *
  * ***** *        *     ***     *
  * ***** *        *    *****    *
  * ***** *           *** * ***
  ** *** **           *   *   *
   **   **                *
    *****                 *
',
#234567890123456789012345678901234567890 - icon 31 HOT - Thanks Yannzola
'

                         *
    *****                *
   **   **               *
   *     *    *          *          *
   * *** *     *         *         *
   * *   *      *        *        *
   * *** *       *               *
   * *** *        *    *****    *
   * *** *           *********
   * *** *          ***********
   * *** *         *************
   * *** *         *************
   * *** *        ***************
   * *** *        ***************
   * *** * ****** *************** ******
   * *** *        ***************
   * *** *        ***************
   * *** *         *************
   * *** *         *************
   * *** *          ***********
   * *** *           *********
  ** *** **       *    *****    *
  * ***** *      *               *
  * ***** *     *        *        *
  * ***** *    *         *         *
  ** *** **   *          *          *
   **   **               *
    *****                *
                         *
',
#234567890123456789012345678901234567890 - icon 32 Dust - Thanks Yannzola
'

                 *******
                **     **
               **  *    *
               *        **
          ****** *  *    *
         **            * *
        **         *     *****
        *    *   *   *       **
        *  *             *    **
    *****                   *  *
   **        *   ******  *     *
  **   *  *     **    **       *
  *            **      **      *
  *       *  * *   *    *  *****
  *  *  *      *        ****   **
  *         ****    *           **
  **   *   **     *    *  *   *  *
   ***    **  *             *    *
     ******           *   *      ****
          *     * *           *     **
          **            *            **
           ***      *     *       *   *
             ******          *        *
                  *    *        *    **
                  *  *     ****    ***
                  **   *  **  ******
                   **    **
                    ******
',
#234567890123456789012345678901234567890 - icon 33 Fog - Thanks Yannzola
'
   ***********************************



   ***********************************



   ***********************************
                *********
               ***********

   ***********************************
             ***************
             ***************

   ***********************************
             ***************
   ***********************************

   ***********************************
                *********
   ***********************************

   ***********************************

   ***********************************

   ***********************************

   ***********************************
');

my $TWClogo = '
       ************************
       ************************
       ************************
       ************************
       ************************
       ************************
       *    *******************
       ** *  *** **************
       ** * * *   *************
       ** * * * ***************
       ** * * **  *************
       ************************
       * * * ****** ** ********
       * * * * *  *  *  ** *  *
       * * *    **  ** *     **
       ** * * **    ** *  ** **
       ** * **       * * *   **
       ************************
       **   **************** **
       * **  *  *   *   * ** **
       * ** * **  * * *    * **
       * ** *     * * *  *** **
       **   *     * * * *  ** *
       ************************



            * *
* * * * ** *****   *  **   **  * ** *
* * ****  * * * * *** *   *   * ** * *
** ***  *** * * * *   *   *   * ** * *
 * *  ***** *** *  ** * ** **  * * * *
';







##################################################
### Super Functions ###
##################################################
sub initPlugin {

	# Get previous settings or set default
	if (Slim::Utils::Prefs::get("plugin_screensaver_superdatetime_city") eq "") {
		Slim::Utils::Prefs::set("plugin_screensaver_superdatetime_city", $city);
	}

	if (Slim::Utils::Prefs::get("plugin_screensaver_superdatetime_wunder") eq "") {
		Slim::Utils::Prefs::set("plugin_screensaver_superdatetime_wunder", $wunderIdent);
	}

	if (Slim::Utils::Prefs::get("plugin_screensaver_superdatetime_weatherformat1t") eq "") {
		Slim::Utils::Prefs::set("plugin_screensaver_superdatetime_weatherformat1t", $weatherFormat1t);
	}
	
	if (Slim::Utils::Prefs::get("plugin_screensaver_superdatetime_weatherformat1b") eq "") {
		Slim::Utils::Prefs::set("plugin_screensaver_superdatetime_weatherformat1b", $weatherFormat1b);
	}

	if (Slim::Utils::Prefs::get("plugin_screensaver_superdatetime_weatherformat2t") eq "") {
		Slim::Utils::Prefs::set("plugin_screensaver_superdatetime_weatherformat2t", $weatherFormat2t);
	}
	
	if (Slim::Utils::Prefs::get("plugin_screensaver_superdatetime_weatherformat2b") eq "") {
		Slim::Utils::Prefs::set("plugin_screensaver_superdatetime_weatherformat2b", $weatherFormat2b);
	}	

	if (Slim::Utils::Prefs::get("plugin_screensaver_superdatetime_stock1format") eq "") {
		Slim::Utils::Prefs::set("plugin_screensaver_superdatetime_stock1format", $stockFormat1);
	}

	if (Slim::Utils::Prefs::get("plugin_screensaver_superdatetime_stock2format") eq "") {
		Slim::Utils::Prefs::set("plugin_screensaver_superdatetime_stock2format", $stockFormat2);
	}

	if (Slim::Utils::Prefs::get("plugin_screensaver_superdatetime_refresh") eq "") {
		Slim::Utils::Prefs::set("plugin_screensaver_superdatetime_refresh", $refreshint);
	}

	if (Slim::Utils::Prefs::get("plugin_screensaver_superdatetime_time") eq "") {
		Slim::Utils::Prefs::set("plugin_screensaver_superdatetime_time", $showtime);
	}

	if (Slim::Utils::Prefs::get("plugin_screensaver_superdatetime_score") eq "") {
		Slim::Utils::Prefs::set("plugin_screensaver_superdatetime_score", $showgame);
	}

	if (Slim::Utils::Prefs::get("plugin_screensaver_superdatetime_atime") eq "") {
		Slim::Utils::Prefs::set("plugin_screensaver_superdatetime_atime", $showactivetime);
	}

	if (Slim::Utils::Prefs::get("plugin_screensaver_superdatetime_ascore") eq "") {
		Slim::Utils::Prefs::set("plugin_screensaver_superdatetime_ascore", $showactivegame);
	}

	if (Slim::Utils::Prefs::get("plugin_screensaver_superdatetime_offset") eq "") {
		Slim::Utils::Prefs::set("plugin_screensaver_superdatetime_offset", $timeoffset);
	}

	if (Slim::Utils::Prefs::get("plugin_screensaver_superdatetime_temperature") eq "") {
		Slim::Utils::Prefs::set("plugin_screensaver_superdatetime_temperature", $temptype);
	}

	if (Slim::Utils::Prefs::get("plugin_screensaver_superdatetime_windunit") eq "") {
		Slim::Utils::Prefs::set("plugin_screensaver_superdatetime_windunit", $windspeedUnit);
	}
	if (Slim::Utils::Prefs::get("plugin_screensaver_superdatetime_averages") eq "") {
		Slim::Utils::Prefs::set("plugin_screensaver_superdatetime_averages", $show_averages);
	}

	if (Slim::Utils::Prefs::get("plugin_screensaver_superdatetime_scroll") eq "") {
		Slim::Utils::Prefs::set("plugin_screensaver_superdatetime_scroll", $scrollType);
	}

	if (Slim::Utils::Prefs::get("plugin_screensaver_superdatetime_teamlogos") eq "") {
		Slim::Utils::Prefs::set("plugin_screensaver_superdatetime_teamlogos", $teamLogos);
	}

	if (Slim::Utils::Prefs::get("plugin_screensaver_superdatetime_stocks") eq "") {
		Slim::Utils::Prefs::set("plugin_screensaver_superdatetime_stocks", $stocks);
	}

	if (Slim::Utils::Prefs::get("plugin_screensaver_superdatetime_lweather") eq "") {
		Slim::Utils::Prefs::set("plugin_screensaver_superdatetime_lweather", $lweather);
	}

	if (Slim::Utils::Prefs::get("plugin_screensaver_superdatetime_cbballconf") eq "") {
		Slim::Utils::Prefs::set("plugin_screensaver_superdatetime_cbballconf", $cbballconf);
	}
	
	if (Slim::Utils::Prefs::get("plugin_screensaver_superdatetime_cfballconf") eq "") {
		Slim::Utils::Prefs::set("plugin_screensaver_superdatetime_cfballconf", $cfballconf);
	}

	#Set local variables 
	$city = Slim::Utils::Prefs::get("plugin_screensaver_superdatetime_city");

	$wunderIdent = Slim::Utils::Prefs::get("plugin_screensaver_superdatetime_wunder");

	$weatherFormat1t = Slim::Utils::Prefs::get("plugin_screensaver_superdatetime_weatherformat1t");
	$weatherFormat1b = Slim::Utils::Prefs::get("plugin_screensaver_superdatetime_weatherformat1b");
	$weatherFormat2t = Slim::Utils::Prefs::get("plugin_screensaver_superdatetime_weatherformat2t");
	$weatherFormat2b = Slim::Utils::Prefs::get("plugin_screensaver_superdatetime_weatherformat2b");

	$stockFormat1 = Slim::Utils::Prefs::get("plugin_screensaver_superdatetime_stock1format");
	$stockFormat2 = Slim::Utils::Prefs::get("plugin_screensaver_superdatetime_stock2format");

	$timeoffset = Slim::Utils::Prefs::get("plugin_screensaver_superdatetime_offset");

	$temptype = Slim::Utils::Prefs::get("plugin_screensaver_superdatetime_temperature");

	$windspeedUnit = Slim::Utils::Prefs::get("plugin_screensaver_superdatetime_windunit");	
	$show_averages = Slim::Utils::Prefs::get("plugin_screensaver_superdatetime_averages");	

	$showtime = Slim::Utils::Prefs::get("plugin_screensaver_superdatetime_time");
	$showactivetime = Slim::Utils::Prefs::get("plugin_screensaver_superdatetime_atime");

	$showgame = Slim::Utils::Prefs::get("plugin_screensaver_superdatetime_score");
	$showactivegame = Slim::Utils::Prefs::get("plugin_screensaver_superdatetime_ascore");

	$lweather = Slim::Utils::Prefs::get("plugin_screensaver_superdatetime_lweather");

	$refreshint = Slim::Utils::Prefs::get("plugin_screensaver_superdatetime_refresh");
	
	$scrollType = Slim::Utils::Prefs::get("plugin_screensaver_superdatetime_scroll");

	$stocks = Slim::Utils::Prefs::get("plugin_screensaver_superdatetime_stocks");

	$teamLogos = Slim::Utils::Prefs::get("plugin_screensaver_superdatetime_teamlogos");

	$cbballconf = Slim::Utils::Prefs::get("plugin_screensaver_superdatetime_cbballconf");
	$cfballconf = Slim::Utils::Prefs::get("plugin_screensaver_superdatetime_cfballconf");
	
	
	@MLBteams = Slim::Utils::Prefs::getArray("plugin_screensaver_superdatetime_mlb");
	if (scalar(@MLBteams) == 0) {
		Slim::Utils::Prefs::set("plugin_screensaver_superdatetime_mlb", \@MLBteams);
    }

	@NBAteams = Slim::Utils::Prefs::getArray("plugin_screensaver_superdatetime_nba");
	if (scalar(@NBAteams) == 0) {
		Slim::Utils::Prefs::set("plugin_screensaver_superdatetime_nba", \@NBAteams);
    }

	@NHLteams = Slim::Utils::Prefs::getArray("plugin_screensaver_superdatetime_nhl");
	if (scalar(@NHLteams) == 0) {
		Slim::Utils::Prefs::set("plugin_screensaver_superdatetime_nhl", \@NHLteams);
    }

	@NFLteams = Slim::Utils::Prefs::getArray("plugin_screensaver_superdatetime_nfl");
	if (scalar(@NFLteams) == 0) {
		Slim::Utils::Prefs::set("plugin_screensaver_superdatetime_nfl", \@NFLteams);
	}

	@CBBteams = Slim::Utils::Prefs::getArray("plugin_screensaver_superdatetime_cbb");
	if (scalar(@CBBteams) == 0) {
		Slim::Utils::Prefs::set("plugin_screensaver_superdatetime_cbb", \@CBBteams);
	}

	@CFBteams = Slim::Utils::Prefs::getArray("plugin_screensaver_superdatetime_cfb");
	if (scalar(@CFBteams) == 0) {
		Slim::Utils::Prefs::set("plugin_screensaver_superdatetime_cfb", \@CFBteams);
	}

}

sub FtoC {
	my $temp = shift;

	$temp = ($temp-32)*5/9;
	$temp = int($temp + .5 * ($temp <=> 0)); #Funky round	
	
	return $temp;
}

sub getAverages {  #Set up Async HTTP request for averages
  my $days_advance = shift || 0;
  
  my $dayNum = "";
  if ($days_advance > 0) {
	$dayNum = "?dayNum=$days_advance";
  }
	
  my $url = 'http://www.weather.com/weather/wxdetail/' . $city . $dayNum;
  # tomorrow ### http://www.weather.com/weather/wxdetail/95616?dayNum=1

  my $http = Slim::Networking::SimpleAsyncHTTP->new(\&gotAverages,
													\&gotErrorViaHTTP,
													{
													 caller => 'getAverages'});
  $::d_plugins && msg("SuperDateTime: async request: $url\n");
  $http->get($url);
}

sub gotAverages {  #Average data was received
  my $http = shift;
	
  $::d_plugins && msg("SuperDateTime: got " . $http->url() . "\n");

  my $dayNum = 0;
  if ($http->url() =~ m/\?dayNum=(\d+)/) {
	$dayNum = $1;
  }

  my $content = $http->content();
	
  #<TD CLASS="blueFont10" ALIGN="LEFT">Avg. High:</TD>
  #<TD CLASS="blueFont10" ALIGN="LEFT"><B>75F</B></TD>
  #</TR>
  #<TR>
  #<TD CLASS="blueFont10" ALIGN="LEFT">Record High:</TD>
  #<TD CLASS="blueFont10" ALIGN="LEFT"><B>95F (2004)</B></TD

  #my @vbgA = grep(/CLASS="vbgA".*<B CLASS="blueText">/, split("\n", $content));
  #$::d_plugins && msg("SuperDateTime: " . join("\n", @vbgA) . "\n");
  
  if ($content =~ m/CLASS="blueFont10" ALIGN="LEFT">Avg. High:<\/TD>.*?<B>(\d+)(F|C)<\/B><\/TD>/s) {
	$averages{$dayNum}{'average_high_F'} = $1;
  }

  if ($content =~ m/CLASS="blueFont10" ALIGN="LEFT">Record High:<\/TD>.*?<B>(\d+)(F|C) \((\d+)\)<\/B><\/TD>/s) {
	$averages{$dayNum}{'record_high_F'} = $1;
	$averages{$dayNum}{'record_high_year'} = $3;
  }
  
  if ($content =~ m/CLASS="blueFont10" ALIGN="LEFT">Avg. Low:<\/TD>.*?<B>(\d+)(F|C)<\/B><\/TD>/s) {
	$averages{$dayNum}{'average_low_F'} = $1;
  }
  
  if ($content =~ m/CLASS="blueFont10" ALIGN="LEFT">Record Low:<\/TD>.*?<B>(\d+)(F|C) \((\d+)\)<\/B><\/TD>/s) {
	$averages{$dayNum}{'record_low_F'} = $1;
	$averages{$dayNum}{'record_low_year'} = $3;
  }
}

sub getWeather {  #Set up Async HTTP request for Weather
	my $timerObj = shift; #Should be undef
	my $client = shift;
	
	my $url = 'http://www.weather.com/weather/local/' . $city;
	my $http = Slim::Networking::SimpleAsyncHTTP->new(\&gotWeather,
							  \&gotErrorViaHTTP,
							  {caller => 'getWeather',
							   client => $client});
	$::d_plugins && msg("SuperDateTime: async request: $url\n");
	$http->get($url);
}

sub gotWeather {  #Weather data was received
	my $http = shift;
	
	my $params = $http->params();
	my $client = $params->{'client'};
	
	#$::d_plugins && msg("SuperDateTime: GOTWEATHER CLIENT: $client\n");
	
	my $temperatureF;
	my $temperatureC;
	my $feelslikeF;
	my $feelslikeC;
	my $dewpointF;
	my $dewpointC;
	
	my $humidity;
	my $pressureIN;
	my $pressureMB;
	my $pressureT; #Pressure trend
	my $windspeed;

	$::d_plugins && msg("SuperDateTime: got " . $http->url() . "\n");
	#$::d_plugins && msg("SuperDateTime: content type is " . $http->headers()->{'Content-Type'} . "\n");

	my $content = $http->content();
	my @ary=split /\n/,$content; #break large string into array

   my @forecastTemps = (); #Temperature numeric values
   my @skyConditions = (); #Cloudy/etc
   my @forecastTypes = (); #High/low
	my @forecastNames = (); #Today/tonight/etc
   my @forecastDescs = (); #Long text forecast
   my $skyCondition = ''; #Current sky condition (cloudy/etc)
   
   @TOPdisplayItems = ();
   @precipItems = (); #Wipe old precip values
   @forecastIcon = (); #Wipe old icons
   @forecastG = (); #Wipe old forecast graphics			
   @btmLinePreSpace = (); #Wipe old bottom line pre spaces (although they probably wont change)
   
	for (@ary) {
		if (/obsTempTextA>(-*\d+)\s*&deg\;F.+Feels Like<BR>\s*(-*\d+)\s*\&d/) {
			$temperatureF = $1;
			$feelslikeF = $2;
			$temperatureC = FtoC($temperatureF);       
			$feelslikeC = FtoC($feelslikeF);
		}
		elsif (/obsTempTextA"*>(-*\d+)\s*&deg\;F/) { #Some html has actual/feels like separated
			$temperatureF = $1;
			$temperatureC = FtoC($temperatureF);       
		}
		elsif (/Feels Like<br\/*>\s*(-*\d+)\s*\&d/) { #Some html has actual/feels like separated
			$feelslikeF = $1;
			$feelslikeC = FtoC($feelslikeF);
		}		
		elsif (/<TD VALIGN="top"  CLASS="obsTextA">(\d+%)<\/td>/) {
			$humidity = $1;
		}
		elsif (/class="crowval">(\d+%)<\/div>/) {
			$humidity = $1;
		}			
		elsif (/From (.+) at (\d+) mph/) {
			if ($windspeedUnit == 0) { #miles/hr
				$windspeed = $1 . $2;
			}
			elsif ($windspeedUnit == 1) { #km/hr
				$windspeed = $2*1.609344;
				$windspeed = $1 . int($windspeed + .5 * ($windspeed <=> 0)); #Funky round
			}
			elsif ($windspeedUnit == 3) { #m/s
				$windspeed = $2*16.09344/36;
				$windspeed = $1 . int($windspeed + .5 * ($windspeed <=> 0)); #Funky round
			}
			else { #kt/hr
				$windspeed = $2/1.1515;
				$windspeed = $1 . int($windspeed + .5 * ($windspeed <=> 0)); #Funky round
			}
		}
		elsif (/CLASS="obsTextA">CALM/) {
			$windspeed = "Calm";		
		}
		elsif (/Wind:<\/div><div class="crowval">CALM/) {
			$windspeed = "Calm";		
		}
		elsif (/wxicons\/52\/(\d+).png.*class="obsTextA">(.+)<\/strong/) {
			$skyCondition = $2; #Text
			$forecastIcon[0] = $1; #Date
			$forecastIcon[1] = $1; #Current		
		}
		elsif (/wxicons\/52\/(\d+).gif.*<BR><B CLASS=obsTextA>(.+)<\/B><\/TD>/) {
			$skyCondition = $2; #Text
			$forecastIcon[0] = $1; #Date
			$forecastIcon[1] = $1; #Current
      }
		elsif (/>(\d+.\d+)&nbsp\;in..*\/(.*)_pressure/) { #Bar. pressure value
			$pressureIN = $1;
			$pressureMB = $1 * 33.8639;
			$pressureMB = int($pressureMB + .5 * ($pressureMB <=> 0)); #Funky round	
      
      	if ($2 eq 'steady') {
      		$pressureT = '~';
      	}
      	elsif ($2 eq 'down') {
      		$pressureT = '-';
      	}
      	else {
      		$pressureT = '+';
      	}
      }      
		elsif (/>(\d+.\d+)&nbsp\;in./) { #Bar. pressure value
			$pressureIN = $1;
			$pressureMB = $1 * 33.8639;
			$pressureMB = int($pressureMB + .5 * ($pressureMB <=> 0)); #Funky round	
      }
		elsif (/up_pressure/) { #Bar. pressure trend
			$pressureT = '+';
      }
		elsif (/steady_pressure/) { #Bar. pressure trend
			$pressureT = '~';
      }
      elsif (/down_pressure/) { #Bar. pressure trend
			$pressureT = '-';
		}
		elsif (/<TD VALIGN="top"  CLASS="obsTextA">(\d+)&deg\;F<\/td>/) { #Dew point
				$dewpointF = $1;
				$dewpointC = FtoC($dewpointF);
		}
		elsif (/Dew Point:<\/div><div class="crowval">(-?\d+)&deg\;F/) { #Dew point
			$dewpointF = $1;
			$dewpointC = FtoC($1);
		}		
  		elsif (/<font class="obsTemp"><nobr>(\d+)&deg; F<\/nobr><\/font><\/td>/) {
			if ($temptype == 0) {  #Fahrenheit
				push(@forecastTemps, $1);
			}
			else { #Celsius
				my $temp = ($1-32)*5/9;       
				$temp = int($temp + .5 * ($temp <=> 0)); #Funky round
				push(@forecastTemps, $temp);
			}
		}      
		elsif (/wxicons\/31\/(\d+).gif/) {
			push(@forecastIcon, $1);
      }		
		elsif (/<font CLASS="blueFont10">(.+)<\/font><\/td>/) {
			push(@skyConditions, $1);
		}
		elsif (/<font CLASS="blueVerdanaText11">(.+)<br>/) {
			push(@forecastTypes, uc($1));
		}
		elsif (/class="whiteArialLink11"><B>(.+)<\/font><\/B><\/A>/) {
			push(@forecastNames, $1);
		}
		elsif (/<FONT CLASS="blueFont10"><DIV STYLE="padding:5px 5px 5px 0px;">(.+ )(\d+)(F|s)(.*\.+)/) {
			my $tempSymbol;
			my $firstHalf;
			
			#Temperature will either be a specific number (50F) or a group (50s)
			if ($3 eq 'F') {
				$tempSymbol = '';
			}
			else {
				$tempSymbol = 's';
			}

			if ($temptype == 0) {  #Fahrenheit
				$firstHalf = $1 . $2 . $tempSymbol;

				#push(@forecastDescs, $1 . $2 . $tempSymbol . $4 . $wind . $7);
			}
			else { #Celsius
				my $temp = ($2-32)*5/9;       
				$temp = int($temp + .5 * ($temp <=> 0)); #Funky round
				
				$firstHalf = $1 . $temp . $tempSymbol;
				#push(@forecastDescs, $1 . $temp . $tempSymbol . $4 . $wind . $7);
			}			

			if ($4 =~ /(.*at )(\d+) to (\d+) mph(.*\.+)/) { #Wind portion
				my $wind;
						
				if ($windspeedUnit== 0) { #miles/hr
					$wind = $2 . ' to ' . $3 . ' mph';
				}
				elsif ($windspeedUnit == 1) { #km/hr
					my $wind1;
					my $wind2;
					$wind1 = $2*1.609344;
					$wind1 = int($wind1 + .5 * ($wind1 <=> 0)); #Funky round
					$wind2 = $3*1.609344;
					$wind2 = int($wind2 + .5 * ($wind2 <=> 0)); #Funky round
					$wind = $wind1 . ' to ' . $wind2 . ' km/hr';
				}
				elsif ($windspeedUnit == 3) { #m/s
					my $wind1;
					my $wind2;
					$wind1 = $2*16.09344/36;
					$wind1 = int($wind1 + .5 * ($wind1 <=> 0)); #Funky round
					$wind2 = $3*16.09344/36;
					$wind2 = int($wind2 + .5 * ($wind2 <=> 0)); #Funky round
					$wind = $wind1 . ' to ' . $wind2 . ' m/s';
				}				
				else { #kt/hr
					my $wind1;
					my $wind2;
					$wind1 = $2/1.1515;
					$wind1 = int($wind1 + .5 * ($wind1 <=> 0)); #Funky round
					$wind2 = $3/1.1515;
					$wind2 = int($wind2 + .5 * ($wind2 <=> 0)); #Funky round
	 				$wind = $wind1 . ' to ' . $wind2 . ' kt';
				}
				
				push(@forecastDescs, $firstHalf . $1 . $wind . $4);
			}
			else { #No wind numbers to convert
				push(@forecastDescs, $firstHalf . $4);
			}
		}
		elsif (/blueVerdanaText.*">(\d+%)<\/td>/) { #Precip
			if (scalar @precipItems ==0) {
				$precipItems[0] = 'PREC '.$1; #Date
				$precipItems[1] = 'PREC '.$1; #Current
				$precipItems[2] = 'PREC '.$1;
			}
			else {
				push(@precipItems, 'PREC '.$1);	
			}	
		}
		elsif (/<FONT CLASS="blueFont10"><DIV STYLE="padding:5px 5px 5px 0px;">(.+\.)/) { #Description didn't parse
			$::d_plugins && msg("SuperDateTime: Error parsing weather forecast desc. \nTEXT:" . $1 . "\n");

			push(@forecastDescs, $1 . '*');			
      }
	}

	my @minmax = ();
	if ($show_averages) {
	  if ($forecastNames[0] ne $averages{'last'}) {
		$::d_plugins && msg("SuperDateTime: Average data refresh started.\n");
		# average data is out of date, refresh
		getAverages(0);			# for today/tonight
		getAverages(1);			# for tomorrow/tomorrow night
		$averages{'last'} = $forecastNames[0];
	  }

	  for (my $i = 0; $i <= $#forecastNames; $i++) {
		$minmax[$i] = "";
		my $name = $forecastNames[$i];

		sub buildMinMax {
		  my ($average, $record, $record_year, $forecast) = @_;
		  if (!$average || !$record || !$record_year || !$forecast) {
			return "";
		  }

		  if ($temptype != 0) { #!Fahrenheit
			my $average = FtoC($average);
			my $record = FtoC($record);
			my $forecast = FtoC($forecast);
		  }			
		
		  my $diff = $forecast - $average;
		  if ($diff > 0) {
			$diff = "+$diff";	# force a leading +
		  }
		  return " (${diff}) (${record} $record_year)"
		}

		if ($name eq 'Today') {
		  $minmax[$i] = buildMinMax($averages{0}{'average_high_F'}, 
									$averages{0}{'record_high_F'}, 
									$averages{0}{'record_high_year'}, 
									$forecastTemps[$i]);
		} elsif ($name eq 'Tonight') {
		  $minmax[$i] = buildMinMax($averages{0}{'average_low_F'}, 
									$averages{0}{'record_low_F'}, 
									$averages{0}{'record_low_year'}, 
									$forecastTemps[$i]);
		} elsif ($name eq 'Tomorrow') {
		  $minmax[$i] = buildMinMax($averages{1}{'average_high_F'}, 
									$averages{1}{'record_high_F'}, 
									$averages{1}{'record_high_year'}, 
									$forecastTemps[$i]);
		} elsif ($name eq 'Tomorrow Night') {
		  $minmax[$i] = buildMinMax($averages{1}{'average_low_F'}, 
									$averages{1}{'record_low_F'}, 
									$averages{1}{'record_low_year'}, 
									$forecastTemps[$i]);
		} else {
		  $::d_plugins && msg("SuperDateTime: ERROR, unknown name: $name\n");
		}
	  }
	}

	#Draw/cache icons for each top line mode
	my $hilow;
	# Top location *0 and 1*
	if ($forecastTypes[0] eq "LOW") {
		$hilow = ' LOW ';
	}
	else {
		$hilow = $forecastTypes[0].' ';
	}
	clearCanvas($client);
	drawIcon($client,0,$ymax{$client}-1, $Icons[$Iconmap{$forecastIcon[0]}]);
	drawText($client,42,$ymax{$client}-25,$precipItems[0]);
	drawText($client,42,$ymax{$client}-13,$hilow.$forecastTemps[0].'g');
	$btmLinePreSpace[0] = $iconPreSpace;
	$forecastG[0] = getFramebuf($client,$gxwidth); #Date
	$forecastG[1] = $forecastG[0]; #Current
	#push(@TOPdisplayItems, Slim::Utils::Misc::longDateF()); #Long date
	push(@TOPdisplayItems, Slim::Utils::DateTime::longDateF(undef,Slim::Utils::Prefs::get('dateFormat')));
	push(@TOPdisplayItems, 'Currently: '.$skyCondition); #Current conditions
	$btmLinePreSpace[0] = $iconPreSpace;
	$btmLinePreSpace[1] = $iconPreSpace;
	
	# Top location *2*
	clearCanvas($client);
	drawIcon($client,0,$ymax{$client}-1, $Icons[$Iconmap{$forecastIcon[2]}]);
	drawText($client,42,$ymax{$client}-25,$precipItems[2]);
	drawText($client,42,$ymax{$client}-13,$hilow.$forecastTemps[0].'g');
	$forecastG[2] = getFramebuf($client,$gxwidth);
	push(@TOPdisplayItems, $forecastNames[0].': '.$skyConditions[0].$minmax[0]);
	$btmLinePreSpace[2] = $iconPreSpace;

	# Top location *3*
	if ($forecastTypes[1] eq "LOW") {
		$hilow = ' LOW ';
	}
	else {
		$hilow = $forecastTypes[1].' ';
	}
	clearCanvas($client);
	drawIcon($client,0,$ymax{$client}-1, $Icons[$Iconmap{$forecastIcon[3]}]);
	drawText($client,42,$ymax{$client}-25,$precipItems[3]);
	drawText($client,42,$ymax{$client}-13,$hilow.$forecastTemps[1].'g');
	$forecastG[3] = getFramebuf($client,$gxwidth);
	push(@TOPdisplayItems, $forecastNames[1].': '.$skyConditions[1].$minmax[1]);
	$btmLinePreSpace[3] = $iconPreSpace;

	# Top location *4*
	if ($forecastTypes[2] eq "LOW") {
		$hilow = ' LOW ';
	}
	else {
		$hilow = $forecastTypes[2].' ';
	}
	clearCanvas($client);
	drawIcon($client,0,$ymax{$client}-1, $Icons[$Iconmap{$forecastIcon[4]}]);
	drawText($client,42,$ymax{$client}-25,$precipItems[4]);
	drawText($client,42,$ymax{$client}-13,$hilow.$forecastTemps[2].'g');
	$forecastG[4] = getFramebuf($client,$gxwidth);
	push(@TOPdisplayItems, $forecastNames[2].': '.$skyConditions[2].$minmax[2]);
	$btmLinePreSpace[4] = $iconPreSpace;	
	
	# Top location *5*	
	#Custom top line with icon
	my $weatherString1t = $weatherFormat1t;
	for ($weatherString1t) {
		s/%t/$temperatureF/;
		s/%T/$temperatureC/;
		s/%w/$windspeed/;
		s/%h/$humidity/;
		s/%p/$pressureIN$pressureT/;
		s/%P/$pressureMB$pressureT/;
		s/%d/$dewpointF/;
		s/%D/$dewpointC/;
		s/%f/$feelslikeF/;
		s/%F/$feelslikeC/;
	}	
	push(@TOPdisplayItems, $weatherString1t);
	$forecastG[5] = $forecastG[1]; #Custom line forecast is same as current conditions
	$btmLinePreSpace[5] = $iconPreSpace;	


	# Icon but no 3line text
	# Top location *6 and 7*
	if ($forecastTypes[0] eq "LOW") {
		$hilow = ' LOW ';
	}
	else {
		$hilow = $forecastTypes[0].' ';
	}
	clearCanvas($client);
	drawIcon($client,0,$ymax{$client}-1, $Icons[$Iconmap{$forecastIcon[0]}]);
	$btmLinePreSpace[6] = $iconPreSpace;
	$forecastG[6] = getFramebuf($client,$gxwidth); #Date
	$forecastG[7] = $forecastG[6]; #Current no 3line
	#push(@TOPdisplayItems, Slim::Utils::Misc::longDateF()); #Long date
	push(@TOPdisplayItems, Slim::Utils::DateTime::longDateF(undef,Slim::Utils::Prefs::get('dateFormat')));
	push(@TOPdisplayItems, 'Currently: '.$skyCondition); #Current conditions
	$btmLinePreSpace[6] = $icon2PreSpace;
	$btmLinePreSpace[7] = $icon2PreSpace;
	
	# Top location *8*
	clearCanvas($client);
	drawIcon($client,0,$ymax{$client}-1, $Icons[$Iconmap{$forecastIcon[2]}]);
	$forecastG[8] = getFramebuf($client,$gxwidth);
	push(@TOPdisplayItems, $forecastNames[0].': '.$skyConditions[0].$minmax[0]);
	$btmLinePreSpace[8] = $icon2PreSpace;

	# Top location *9*
	if ($forecastTypes[1] eq "LOW") {
		$hilow = ' LOW ';
	}
	else {
		$hilow = $forecastTypes[1].' ';
	}
	clearCanvas($client);
	drawIcon($client,0,$ymax{$client}-1, $Icons[$Iconmap{$forecastIcon[3]}]);
	$forecastG[9] = getFramebuf($client,$gxwidth);
	push(@TOPdisplayItems, $forecastNames[1].': '.$skyConditions[1].$minmax[1]);
	$btmLinePreSpace[9] = $icon2PreSpace;

	# Top location *10*
	if ($forecastTypes[2] eq "LOW") {
		$hilow = ' LOW ';
	}
	else {
		$hilow = $forecastTypes[2].' ';
	}
	clearCanvas($client);
	drawIcon($client,0,$ymax{$client}-1, $Icons[$Iconmap{$forecastIcon[4]}]);
	$forecastG[10] = getFramebuf($client,$gxwidth);
	push(@TOPdisplayItems, $forecastNames[2].': '.$skyConditions[2].$minmax[2]);
	$btmLinePreSpace[10] = $icon2PreSpace;	
	
	# Top location *11*	
	#Custom top line with no 3line
	my $weatherString1t = $weatherFormat1t;
	for ($weatherString1t) {
		s/%t/$temperatureF/;
		s/%T/$temperatureC/;
		s/%w/$windspeed/;
		s/%h/$humidity/;
		s/%p/$pressureIN$pressureT/;
		s/%P/$pressureMB$pressureT/;
		s/%d/$dewpointF/;
		s/%D/$dewpointC/;
		s/%f/$feelslikeF/;
		s/%F/$feelslikeC/;
	}	
	push(@TOPdisplayItems, $weatherString1t);
	clearCanvas($client);
	drawIcon($client,0,$ymax{$client}-1, $Icons[$Iconmap{$forecastIcon[0]}]);
	$btmLinePreSpace[11] = $icon2PreSpace;
	$forecastG[11] = getFramebuf($client,$gxwidth); #Current
	
	#Top lines without icons
	# Top location *12*	
	push(@TOPdisplayItems, $forecastNames[0].': '.$skyConditions[0].' - '.$forecastTypes[0].' '.$forecastTemps[0].''.$minmax[0]);
	# Top location *13*	
	push(@TOPdisplayItems, $forecastNames[1].': '.$skyConditions[1].' - '.$forecastTypes[1].' '.$forecastTemps[1].''.$minmax[1]);
	# Top location *14*	
	push(@TOPdisplayItems, $forecastNames[2].': '.$skyConditions[2].' - '.$forecastTypes[2].' '.$forecastTemps[2].''.$minmax[2]);
	# Top location *15*	
	push(@TOPdisplayItems, $weatherString1t); #Custom top line, no icon
	
	@WETdisplayItems2 = ();
	push(@WETdisplayItems2, $forecastDescs[0]);
	push(@WETdisplayItems2, $forecastDescs[1]);
	push(@WETdisplayItems2, $forecastDescs[2]);

	if ($wunderIdent eq "") {
		$weatherString1b = $weatherFormat1b;

		for ($weatherString1b) {
			s/%t/$temperatureF/;
			s/%T/$temperatureC/;
			s/%w/$windspeed/;
			s/%h/$humidity/;
			s/%p/$pressureIN$pressureT/;
			s/%P/$pressureMB$pressureT/;
			s/%d/$dewpointF/;
			s/%D/$dewpointC/;
			s/%f/$feelslikeF/;
			s/%F/$feelslikeC/;
		}
		
		$weatherString2b = $weatherFormat2b;

		for ($weatherString2b) {
			s/%t/$temperatureF/;
			s/%T/$temperatureC/;
			s/%w/$windspeed/;
			s/%h/$humidity/;
			s/%p/$pressureIN$pressureT/;
			s/%P/$pressureMB$pressureT/;
			s/%d/$dewpointF/;
			s/%D/$dewpointC/;
			s/%f/$feelslikeF/;
			s/%F/$feelslikeC/;
		}		

		$weatherString2t = $weatherFormat2t;

		for ($weatherString2t) {
			s/%t/$temperatureF/;
			s/%T/$temperatureC/;
			s/%w/$windspeed/;
			s/%h/$humidity/;
			s/%p/$pressureIN$pressureT/;
			s/%P/$pressureMB$pressureT/;
			s/%d/$dewpointF/;
			s/%D/$dewpointC/;
			s/%f/$feelslikeF/;
			s/%F/$feelslikeC/;
		}	
	}
	
	$refreshCounter--;
	checkRefreshStatus();
}

sub getWunderground {  #Set up Async HTTP request for Weather
	my $url = 'http://www.wunderground.com/weatherstation/WXDailyHistory.asp?ID=' . $wunderIdent . '&format=1';
	my $http = Slim::Networking::SimpleAsyncHTTP->new(\&gotWunderground,
						  \&gotErrorViaHTTP,
						  {caller => 'getWunderground'});
	$::d_plugins && msg("SuperDateTime: async request: $url\n");
	$http->get($url);

}

sub gotWunderground {  #Weather data was received
	my $http = shift;
	
	my $temperatureF;
	my $temperatureC;
	my $dewpointF;
	my $dewpointC;
	my $humidity;
	my $pressureIN;
	my $pressureMB;
	my $pressureT; #Pressure trend
	my $windspeed;
	my $winddir; #Wind from direction

	$::d_plugins && msg("SuperDateTime: got " . $http->url() . "\n");

	my $content = $http->content();
	my @ary=split /\n/,$content; #break large string into array

	#$::d_plugins && msg("WU DATA: ".$ary[scalar(@ary)-3]."\n");

	if($ary[scalar(@ary)-3] =~ /.*,(.*),(.*),(.*),(.*),.*,(.*),.*,(.*),.*,(.*),(.*),.*,.*,/) {
		$temperatureF = $1;
		$temperatureC = FtoC($temperatureF); 
		
		$dewpointF = $2;
		$dewpointC = FtoC($dewpointF);
		
		$pressureIN = $3;
		$pressureMB = $3 * 33.8639;
		$pressureMB = int($pressureMB + .5 * ($pressureMB <=> 0)); #Funky round	
		
		if ($5==0) {
			$windspeed = "Calm";
		}
		else {
			$winddir = $4;
			if ($winddir eq "South") {
				$winddir = "S";
			}
			elsif ($winddir eq "North") {
				$winddir = "N";
			}
			elsif ($winddir eq "East") {
				$winddir = "E";
			}
			elsif ($winddir eq "West") {
				$winddir = "W";
			}
			
			if ($windspeedUnit == 0) { #miles/hr
				$windspeed = $winddir . $5;
			}
			elsif ($windspeedUnit == 1) { #km/hr
				$windspeed = $5*1.609344;
				$windspeed = $winddir . int($windspeed + .5 * ($windspeed <=> 0)); #Funky round
			}
			elsif ($windspeedUnit == 3) { #m/s
				$windspeed = $5*16.09344/36;
				$windspeed = $winddir . int($windspeed + .5 * ($windspeed <=> 0)); #Funky round
			}			
			else { #kt/hr
				$windspeed = $5/1.1515;
				$windspeed = $winddir . int($windspeed + .5 * ($windspeed <=> 0)); #Funky round
			}		
		}
		
		$humidity = $6 . '%';
		
		#Current conditions is 7, clouds 8
	
	}
	
	$weatherString1b = $weatherFormat1b;

	for ($weatherString1b) {
		s/%t/$temperatureF/;
		s/%T/$temperatureC/;
		s/%w/$windspeed/;
		s/%h/$humidity/;
		s/%p/$pressureIN$pressureT/;
		s/%P/$pressureMB$pressureT/;
		s/%d/$dewpointF/;
		s/%D/$dewpointC/;
	}

	$weatherString2b = $weatherFormat2b;

	for ($weatherString2b) {
		s/%t/$temperatureF/;
		s/%T/$temperatureC/;
		s/%w/$windspeed/;
		s/%h/$humidity/;
		s/%p/$pressureIN$pressureT/;
		s/%P/$pressureMB$pressureT/;
		s/%d/$dewpointF/;
		s/%D/$dewpointC/;
	}

	$weatherString2t = $weatherFormat2t;

	for ($weatherString2t) {
		s/%t/$temperatureF/;
		s/%T/$temperatureC/;
		s/%w/$windspeed/;
		s/%h/$humidity/;
		s/%p/$pressureIN$pressureT/;
		s/%P/$pressureMB$pressureT/;
		s/%d/$dewpointF/;
		s/%D/$dewpointC/;
	}		

	$refreshCounter--;
	checkRefreshStatus();
}

sub getStocks {  #Set up Async HTTP request for Stocks

	my ($sec,$min,$hour,$mday,$mon,$year,$wday,$yday,$isdst) = localtime(time);
		
	my $offset = $timeoffset;	
	while ($offset != 0) {
		if ($offset >0) {
			$offset = $offset -1;
			$hour = $hour -1;
			if ($hour == -1) {
				$hour = 23;
				$wday--;
			}
		}
		else {
			$offset = $offset +1;
			$hour = $hour +1;
			if ($hour == 24) {
				$hour = 0;
				$wday++;
			}
		}
	} 	
               #Market hours                                                                     #After market hours but no market data from the day
	if (($stocks ne "" && $wday >0 && $wday <6 && $hour <18 && $hour >8)|| ($stocks ne "" && $wday >0 && $wday <6 && $hour >17 && (scalar @STKdisplayItems1 == 0))) { #Make sure stocks data is needed.  Update from 9am to 5pm.
		my $url = 'http://finance.yahoo.com/d/quotes.csv?s=' . $stocks . '&f=sl1d1t1c1ohgvpn&e=.csv';
		my $http = Slim::Networking::SimpleAsyncHTTP->new(\&gotStocks,
							  \&gotErrorViaHTTP,
							  {caller => 'getStocks'});
		$::d_plugins && msg("SuperDateTime: async request: $url\n");
		$http->get($url);
	}
	else {
		$refreshCounter--;
		checkRefreshStatus();

		if ($hour <9 || $wday == 0 || $wday == 6) {
			#Make sure stock arrays are empty
			@STKdisplayItems1 = ();
			@STKdisplayItems2 = ();
			@STKdisplayIntervals = ();
		}
	}

}

sub gotStocks {  #Stock data was received
	my $http = shift;
	
	@STKdisplayItems1 = ();
	@STKdisplayItems2 = ();
	@STKdisplayIntervals = ();
    
	$::d_plugins && msg("SuperDateTime: got " . $http->url() . "\n");

	my $content = $http->content();
	my @ary=split /\n/,$content; #break large string into array

	#$::d_plugins && msg("STOCK DATA: ".$ary[0]."\n");
	
	for (@ary) {  
		if(/"(.*)",(.*),"(.*)","(.*)",(.*),(.*),(.*),(.*),(.*),(.*),"(.*)"/) {
			my $ticker;
			my $name;
			my $lasttrade;
			my $lastdate;
			my $lasttime;
			my $change;
			my $open;
			my $high;
			my $low;
			my $volume;
			my $prev;
		   my $pchange;
   			
			$ticker = $1;
			$lasttrade = Slim::Utils::Misc::delimitThousands($2);
			$lastdate = $3;
			$lasttime = $4;

			$change = $5;

			$open = Slim::Utils::Misc::delimitThousands($6);
			$high = Slim::Utils::Misc::delimitThousands($7);
			$low = Slim::Utils::Misc::delimitThousands($8);
			
			$volume = $9;
			
			$prev = Slim::Utils::Misc::delimitThousands($10);
			
			if ($volume >1000000) {
			  $volume = $volume / 1000000;
			  
			  $volume = sprintf("%.2f", $volume);
			  
			  $volume = Slim::Utils::Misc::delimitThousands($volume);
			  $volume = $volume . 'M';
			}
			else {
				$volume = Slim::Utils::Misc::delimitThousands($volume);
			}
						
			if ($ticker eq "^IXIC") {  #Volume is not reported for Nasdaq composite
				$volume = '';
			}
						
			if ($10 > 0) {
				$pchange = ($5/$10)*100;
				$pchange = sprintf("%.2f%", $pchange);
			}
			
			$name = $11;			

			my $line1 = $stockFormat1;
			my $line2 = $stockFormat2;
			
			for ($line1) {
				s/%s/$ticker/;
				s/%l/$lasttrade/;
				s/%d/$lastdate/;
				s/%t/$lasttime/;
				s/%c/$change/;
				s/%o/$open/;
				s/%h/$high/;
				s/%w/$low/;
				s/%v/$volume/;
				s/%n/$name/;
				s/%p/$prev/;
				s/%z/$pchange/;
			}
			
			for ($line2) {
				s/%s/$ticker/;
				s/%l/$lasttrade/;
				s/%d/$lastdate/;
				s/%t/$lasttime/;
				s/%c/$change/;
				s/%o/$open/;
				s/%h/$high/;
				s/%w/$low/;
				s/%v/$volume/;
				s/%n/$name/;
				s/%p/$prev/;
				s/%z/$pchange/;				
			}

			push(@STKdisplayItems1, $line1);
			push(@STKdisplayItems2, $line2);
			push(@STKdisplayIntervals, 5);
		}
	}

	$refreshCounter--;
	checkRefreshStatus();
}

sub refreshSoon { #Disabled for now
	my $client = shift;

	#Clear previous display info
	#What about clearing line 1?
	@MLBdisplayItems2 =();
	@NFLdisplayItems2 =();
	@CBBdisplayItems2 =();
	@CFBdisplayItems2 =();
	@NBAdisplayItems2 =();
	@NHLdisplayItems2 =();
	@WETdisplayItems2 =();
	@STKdisplayItems1 =();
	@STKdisplayItems2 =();
	
	@MLBdisplayIntervals =();
	@NFLdisplayIntervals =();
	@CBBdisplayIntervals =();
	@CFBdisplayIntervals =();
	@NBAdisplayIntervals =();
	@NHLdisplayIntervals =();
	@STKdisplayIntervals = ();
	
	#No need to refresh data unless there are active clients
	if ($activeClients >0) {
		Slim::Utils::Timers::killTimers(undef, \&refreshData);
		#Refresh in 7 seconds.  Ensures settings are updated...
		Slim::Utils::Timers::setTimer(undef, Time::HiRes::time() + 7, \&refreshData, $client);
	}
	
}

sub refreshData {
	$::d_plugins && msg("SuperDateTime: Data refresh in progress...\n");

	my $timerObj = shift; #Should be undef
	my $client = shift;

	$errorCount = 0; #Reset network error counter for new refresh

	#Update status indicator to show that a data refresh is in progress
	$status = '*';

	$refreshCounter = 9; 	#Counter to keep track of how many items could be refreshing
	my $refreshDelay = 1.5;	#Number of seconds to space inbetween timers to prevent hangs.
	my $cumlativeDelay = Time::HiRes::time() + $refreshDelay; #Incrementer for spacing timers.

	#Is this okay since old data is still being displayed?
	$newActiveGames = 0; #Reset active game flag for upcoming sports data refresh

	#Use timers to spread load to prevent server hangs
	#Weather.com
	Slim::Utils::Timers::setTimer(undef, $cumlativeDelay, \&getWeather, $client);

	#Do we need to take into account $isdst???  How do we figure out if East Coast is observing if located in timezone that doesnt observe?
	my ($mday,$mon,$year,$hour, $isdst) = (gmtime(time-(60*60*4)))[3,4,5,2,8];	#Figure out EST based on GMT time
	if ($mday < 10) {
		$mday = '0' . $mday;
	}

	$mon++; #Starts at 0
	if ($mon < 10) {
		$mon = '0' . $mon;
	}
	$year = $year + 1900;
	
	$::d_plugins && msg("SuperDateTime: Eastern Hour/Date:$hour/$mday\n");
	if ((($lastRefresh ne ($year . $mon . $mday)) && $hour >4) || $lastRefresh eq '') { #5AM EST start refreshing a new day
		@refreshTracker = ();
		$refreshTracker[0] = 1; #Need to refresh MLB again
		$refreshTracker[1] = 1; #Need to refresh NBA again
		$refreshTracker[2] = 1; #Need to refresh NHL again
		$lastRefresh = $year.$mon.$mday;
	}

	#WUnderground
	if ($wunderIdent ne "") { #Make sure wunderground data is needed  
		$cumlativeDelay = $cumlativeDelay + $refreshDelay;
		Slim::Utils::Timers::setTimer(undef, $cumlativeDelay, \&getWunderground);
	}
	else {
		$refreshCounter--;
	}

	#MLB	
	if (scalar(@MLBteams)>0 && $mon <11 && $mon >3 && $refreshTracker[0] !=0) { #Make sure a baseball team is chosen and its baseball season
		$cumlativeDelay = $cumlativeDelay + $refreshDelay;
		Slim::Utils::Timers::setTimer(undef, $cumlativeDelay, \&getMLB, $client);
	}
	else {
		$refreshCounter--;
	}

	#NFL	
	if (scalar(@NFLteams)>0) { #Make sure a NFL team is chosen  
		$cumlativeDelay = $cumlativeDelay + $refreshDelay;
		Slim::Utils::Timers::setTimer(undef, $cumlativeDelay, \&getNFL, $client);
	}
	else {
		$refreshCounter--;
	}

	#NBA
	if (scalar(@NBAteams)>0 && $refreshTracker[1] !=0) { #Make sure a basketball team is chosen
		$cumlativeDelay = $cumlativeDelay + $refreshDelay;
		Slim::Utils::Timers::setTimer(undef, $cumlativeDelay, \&getNBA);
	}
	else {
		$refreshCounter--;
	}

	#NHL
	if (scalar(@NHLteams)>0 && $refreshTracker[2] !=0) { #Make sure a hockey team is chosen  
		$cumlativeDelay = $cumlativeDelay + $refreshDelay;
		Slim::Utils::Timers::setTimer(undef, $cumlativeDelay, \&getNHL);
	}
	else {
		$refreshCounter--;
	}

	#CBB	
	if ((scalar(@CBBteams)>0) && ($cbballconf ne '0')) { #Make sure a college basketball team is chosen  
		$cumlativeDelay = $cumlativeDelay + $refreshDelay;
		Slim::Utils::Timers::setTimer(undef, $cumlativeDelay, \&getCBB);
	}
	else {
		$refreshCounter--;
	}

	#CFB
	if (scalar(@CFBteams)>0 && ($cfballconf ne '0')) { #Make sure a team is chosen  
		$cumlativeDelay = $cumlativeDelay + $refreshDelay;
		Slim::Utils::Timers::setTimer(undef, $cumlativeDelay, \&getCFB, $client);
	}
	else {
		$refreshCounter--;
	}

	#Stocks --Has more complex logic, leave this way for now...
	$cumlativeDelay = $cumlativeDelay + $refreshDelay;
	Slim::Utils::Timers::setTimer(undef, $cumlativeDelay, \&getStocks);
	
	Slim::Utils::Timers::killTimers(undef, \&refreshData); #Paranoia check
	Slim::Utils::Timers::setTimer(undef, Time::HiRes::time() + ($refreshint * 60), \&refreshData, $client);

	checkRefreshStatus(); #See if anything is still refreshing...
}

sub checkRefreshStatus {
	if ($newActiveGames == 1) {
		$activeGames = 1;
	}
	
	if ($refreshCounter == 0) {	#Data refresh complete
		if ($status eq '*') {
			$::d_plugins && msg("SuperDateTime: Data refresh completed.\n");
			$status = '';
		}
		else {
			$::d_plugins && msg("SuperDateTime: Data refresh completed with errors.\n");
		}
		
		$activeGames = $newActiveGames;
	}
}

sub getMLB {  #Set up Async HTTP request for MLB
	my $timerObj = shift; #Should be undef
	my $client = shift;
		    
	#my $url ='http://sports.espn.go.com/mlb/scoreboard?date=20060404';
	my $url = 'http://scores.espn.go.com/mlb/scoreboard?date=' . $lastRefresh;
	#my $url = 'http://sports-ak.espn.go.com/mlb/scoreboard/printable/scoreboard_1_0_0?date=' . $year . $mon . $mday;
	
	my $http = Slim::Networking::SimpleAsyncHTTP->new(\&gotMLB,
							  \&gotErrorViaHTTP,
							  {caller => 'getMLB',
							   client => $client});							  
		
	$::d_plugins && msg("SuperDateTime: async request: $url\n");
	$http->get($url);
		
}

sub gotMLB {
	my $http = shift;
	my $params = $http->params();
	my $client = $params->{'client'};
	
	@MLBdisplayItems1 = ();
	@MLBdisplayItems2 = ();
	@MLBdisplayIntervals = ();
	@divideMLB = ();
	
	$refreshTracker[0] = 0;
	
	$::d_plugins && msg("SuperDateTime: got " . $http->url() . "\n");
	#$::d_plugins && msg("SuperDateTime: content type is " . $http->headers()->{'Content-Type'} . "\n");

	my $content = $http->content();
   
	#my @ary=split /teamTop/,$content; #break large string into array of games
	@divideMLB = split /teamTop/,$content; #break large string into array of games

	Slim::Utils::Timers::killTimers(undef, \&processMLB); #Just in case there's a rogue timer
	Slim::Utils::Timers::setTimer(undef, Time::HiRes::time() + .1, \&processMLB, $client);
}

sub processMLB {
	$::d_plugins && msg("SuperDateTime: Processing MLB game...\n");
	my $timerObj = shift; #Should be undef
	my $client = shift;

	my $line = pop @divideMLB;

	my @todaysGames = split /\n/, $line;  #break down to speed up regexp processing

	for (@todaysGames) {		
		if (/>(\d+:\d+ .?M ET)<.+class="teamLine".+\d+">(.+)<\/a>.+teamLine".+id=\d+">(.+)<\/a><\/strong>/) { #Upcoming game
			#my $gametime = $1; my $team1 = $2; my $team2 = $3;
				
			if ((teamCheck($2, \@MLBteams)==1) || (teamCheck($3, \@MLBteams)==1)) {
				MLBdisplayLines($client,$1, $2, $3, '', '');
			}				
		}
		elsif (/\d">(.+)<\/td><\/tr><tr><td class="teamLine".+\d+">(.+)<\/a><\/strong>.+teamLine".+id=\d+">(.+)<\/a><\/strong>.+awayRunsTotal.+".*>(\d+)<\/td><td.+awayTeamHits.+homeRunsTotal.+".*>(\d+)<\/td><td.+homeTeamHits/) { #Completed/Active game
			#my $gametime = $1; my $team1 = $2; my $team2 = $3; my $team1score = $4; my $team2score = $5;
			
			if ((teamCheck($2, \@MLBteams)==1) || (teamCheck($3, \@MLBteams)==1)) {	
				MLBdisplayLines($client,$1, $2, $3, $4, $5);
			}				
		}			
	}

	$::d_plugins && msg("SuperDateTime: Done processing MLB game.\n");
   
	if (scalar @divideMLB > 0) {
		#Slim::Utils::Timers::killTimers(undef, \&processMLB); #No way there are any right!?!?
		Slim::Utils::Timers::setTimer(undef, Time::HiRes::time() + .1, \&processMLB, $client);	
	}
	else {
		$refreshCounter--;
		checkRefreshStatus();
	}
}

sub teamCheck {
	my $teamToCheck  = shift;
	my $teamArrayRef = shift;

	#Get rid of any ranking, if present (college).
	if ($teamToCheck =~ /(\(\d+\)) (.+)/) {
		$teamToCheck = $2;
	}
	
  	my $endingValue = scalar(@$teamArrayRef);

	for(my $counter=0 ; $counter < $endingValue; $counter++)
	{
		if (($teamToCheck eq @$teamArrayRef[$counter]) || (@$teamArrayRef[$counter] eq '1') || (@$teamArrayRef[$counter] eq 'All') || (@$teamArrayRef[$counter] eq 'all')) {
			return 1;
		}
	}
	
	return 0;
}


sub MLBdisplayLines {
	#Figure out/Format display lines
	my ($client, $MLBgametime, $MLBteam1, $MLBteam2, $MLBscore1, $MLBscore2) = @_;

	$MLBgametime = convertTime($MLBgametime);  #Clean up time display and convert to local time zone

	my $team1 = '';
	my $team2 = '';
	
	if ($teamLogos == 0) { #No logos
		$team1 = shortenMLB($MLBteam1);
		$team2 = shortenMLB($MLBteam2) 
	}
	elsif ($teamLogos == 1) { #Logo no text
		if (defined $MLBmap{$MLBteam1}) { #Are there logos for team1?
			$team1 = $client->symbols('mlb-'.$MLBmap{$MLBteam1});
		}
		else { #No logo available
			$team1 = shortenMLB($MLBteam1);
		}
			
		if (defined $MLBmap{$MLBteam2}) { #Are there logos for team2
			$team2 = $client->symbols('mlb-'.$MLBmap{$MLBteam2});
		}
		else { #No logo available
			$team2 = shortenMLB($MLBteam2);
		}		
	}
	else { #Logo and text
		if (defined $MLBmap{$MLBteam1}) { #Are there logos for team1?
			$team1 = $client->symbols('mlb-'.$MLBmap{$MLBteam1});
		}
			
		if (defined $MLBmap{$MLBteam2}) { #Are there logos for team2
			$team2 = $client->symbols('mlb-'.$MLBmap{$MLBteam2});
		}	
		
		$team1 = $team1 . shortenMLB($MLBteam1);
		$team2 = $team2 . shortenMLB($MLBteam2);
	}
	
	
	if ($MLBscore1 eq '' && $showgame>0) {  #upcoming game
		$refreshTracker[0] = 1;
		push(@MLBdisplayItems1, 'MLB');
		push(@MLBdisplayItems2, $team1 . ' @ ' . $team2 . '-' . $MLBgametime);
		push(@MLBdisplayIntervals, $showgame);
	}
	elsif ($MLBgametime eq 'F' && $showgame>0) {  #Finished game
		push(@MLBdisplayItems1, 'MLB');
		push(@MLBdisplayItems2, $team1 . ' ' . $MLBscore1 . ' @ ' . $team2 . ' ' . $MLBscore2 . ' -' . $MLBgametime);
		push(@MLBdisplayIntervals, $showgame);
	}
	elsif ($MLBgametime ne 'F' && $showactivegame >0 && $MLBscore1 ne '') { #active game
		$refreshTracker[0] = 1;
		$newActiveGames = 1;
		push(@MLBdisplayItems1, 'MLB');
		push(@MLBdisplayItems2, $team1 . ' ' . $MLBscore1 . ' @ ' . $team2 . ' ' . $MLBscore2 . ' -' . $MLBgametime);
		push(@MLBdisplayIntervals, $showactivegame);
	}

}

sub getNBA {  #Set up Async HTTP request for NBA
	#my $url ='http://sports.espn.go.com/nba/scoreboard?date=20050623';
	#my $url = 'http://sports.espn.go.com/nba/scoreboard?date=' . $year . $mon . $mday;
	my $url = 'http://sports.espn.go.com/nba/scoreboard?date=' . $lastRefresh;

	my $http = Slim::Networking::SimpleAsyncHTTP->new(\&gotNBA,
														  \&gotErrorViaHTTP,
														  {caller => 'getNBA'});
	$::d_plugins && msg("SuperDateTime: async request: $url\n");
	$http->get($url);

}

sub gotNBA {
	@NBAdisplayItems1 = ();
	@NBAdisplayItems2 = ();
	@NBAdisplayIntervals = ();
	$refreshTracker[1] = 0;
   
	my $team1 = '';
	my $team2 = '';
	my $gametime = '';
    
	my $team1score ='';
	my $team2score ='';
       
	my $http = shift;
	#my $params = $http->params();

	$::d_plugins && msg("SuperDateTime: got " . $http->url() . "\n");
	#$::d_plugins && msg("SuperDateTime: content type is " . $http->headers()->{'Content-Type'} . "\n");

	my $content = $http->content();
    
	my @ary=split /\n/,$content; #break large string into array

	for (@ary) {
		if (/<div><div id="LSTeams_Clock">.+-clock">(.+)<\/div><\/div><!-- away/) {
			$gametime = $1;
		}
		elsif (/<div><div id="LSTeams_Clock">.+-clock">(.+)<\/div><\/div>/) {
			$gametime = $1;
		}
		elsif (/<div class="game"/) {
			if ($team2 ne "") {  #Save previously found game
				if ((teamCheck($team1,\@NBAteams)==1) || (teamCheck($team2,\@NBAteams)==1)) {
					NBAdisplayLines($gametime, $team1, $team2, $team1score, $team2score);
				}
			}
			$team1 = "";
			$team1score = '';
			$team2 = "";
			$team2score = '';
		}
		elsif (/-- leave empty --><div class="lsData" align="center".*>(\d+)<\/div><div class/) {
			if ($team1score eq '') {
				$team1score = $1;
			}
			elsif ($team2score eq '') {
				$team2score = $1;
			}
		}

		if (/clubhouse\?team=.+">(.*)<\/a><\/div><\/div><!-- home.+clubhouse\?team=.+">(.*)<\/a><\/div><\/div/){
			$team1 = $1;
			$team2 = $2;
		}   
		elsif (/clubhouse\?team=.+">(.*)<\/a>/){
			if ($team1 eq "") {
				$team1 = $1;
			}
			else {
				$team2 = $1;
			}
		}   
	} #end for

	if ($team2 ne "") {  #Save previously found game
		if (teamCheck($team1,\@NBAteams) || teamCheck($team2,\@NBAteams)) {
			NBAdisplayLines($gametime, $team1, $team2, $team1score, $team2score);
		}
	}

	$refreshCounter--;
	checkRefreshStatus();
	
}

sub NBAdisplayLines {
  #Figure out/Format display lines
  my ($NBAgametime, $NBAteam1, $NBAteam2, $NBAscore1, $NBAscore2) = @_;

  $NBAgametime = convertTime($NBAgametime);  #Clean up time display and convert to local time zone

  if ($NBAscore1 eq '' && $showgame>0) {  #upcoming game
	 $refreshTracker[1] = 1;
    push(@NBAdisplayItems1, 'NBA');
    push(@NBAdisplayItems2, shortenNBA($NBAteam1) . ' @ ' . shortenNBA($NBAteam2) . '-' . $NBAgametime);
    push(@NBAdisplayIntervals, $showgame);
  }
  elsif ($NBAgametime ne 'F' && $showactivegame >0 && $NBAscore1 ne '') { #active game
    $refreshTracker[1] = 1;
    $newActiveGames = 1;
    push(@NBAdisplayItems1, 'NBA');
    push(@NBAdisplayItems2, shortenNBA($NBAteam1) . ' ' . $NBAscore1 . ' @ ' . shortenNBA($NBAteam2) . ' ' . $NBAscore2 . ' -' . $NBAgametime);
    push(@NBAdisplayIntervals, $showactivegame);
  }
  else {  #Must be finished game?
    push(@NBAdisplayItems1, 'NBA');
    push(@NBAdisplayItems2, shortenNBA($NBAteam1) . ' ' . $NBAscore1 . ' @ ' . shortenNBA($NBAteam2) . ' ' . $NBAscore2 . ' -' . $NBAgametime);
    push(@NBAdisplayIntervals, $showgame);
  }
}

sub getCBB {  #Set up Async HTTP request for CBB
	my ($mday,$mon,$year) = (localtime(time))[3,4,5];
 
	if ($mday < 10) {
		$mday = '0' . $mday;
	}
	$mon++;

	if ($mon < 10) {
		$mon = '0' . $mon;
	}
	$year = $year + 1900;
    
	#my $url = 'http://sports.espn.go.com/ncb/scoreboard?confId=50&date=20051210';
	my $url;
	if ($cbballconf != 1000) { #Top 25
		$url = "http://sports.espn.go.com/ncb/scoreboard?confId=".$cbballconf."&cast=false";
	}
	else {
		$url = 'http://sports.espn.go.com/ncb/scoreboard';
	}

	my $http = Slim::Networking::SimpleAsyncHTTP->new(\&gotCBB,
													  \&gotErrorViaHTTP,
													  {caller => 'getCBB'});
	$::d_plugins && msg("SuperDateTime: async request: $url\n");
	$http->get($url);
}

sub gotCBB {
   @CBBdisplayItems1 = (); 
	@CBBdisplayItems2 = ();
	@CBBdisplayIntervals = ();
   
	my $team1 = '';
	my $team2 = '';
	my $gametime = '';
    
	my $team1score = '';
	my $team2score = '';
       
	my $http = shift;
	#my $params = $http->params();

	$::d_plugins && msg("SuperDateTime: got " . $http->url() . "\n");
	#$::d_plugins && msg("SuperDateTime: content type is " . $http->headers()->{'Content-Type'} . "\n");

	my $content = $http->content();
        
	my @ary=split /\n/,$content; #break large string into array

	for (@ary) {
		if (/<div class="game"/) { #New game
			if ($team2 ne "") {  #Save previously found game
				if ((teamCheck($team1,\@CBBteams)==1) || (teamCheck($team2,\@CBBteams)==1)) {
					CBBdisplayLines($gametime, $team1, $team2, $team1score, $team2score);
				}
			}
			$gametime = "";
			$team1 = "";
			$team1score = '';
			$team2 = "";
			$team2score = '';
		}
		elsif (/\d-clock">(.*)<\/div><\/div><!-- a.*house\?teamId=\d+">(.*)<\/a>/) {
			$gametime = $1;
			$team1 = $2;
		}
		elsif (/house\?teamId=\d+">(.*)<\/a>/){ #HOME TEAM
			$team2 = $1;
		}   
		elsif (/\d-asT">(\d+)</) {
			$team1score = $1;
			#$::d_plugins && msg("SuperDateTime: AWAY SCORE=".$1."\n");
		}
		elsif (/\d-hsT">(\d+)</) {
			$team2score = $1;
			#$::d_plugins && msg("SuperDateTime: HOME SCORE=".$1."\n");
		}
	} #end for

	if ($team2 ne "") {  #Save previously found game
		if (teamCheck($team1,\@CBBteams) || teamCheck($team2,\@CBBteams)) {
			CBBdisplayLines($gametime, $team1, $team2, $team1score, $team2score);
		}
	}

	$refreshCounter--;
	checkRefreshStatus();
	
}

sub CBBdisplayLines {
  #Figure out/Format display lines
  my ($CBBgametime, $CBBteam1, $CBBteam2, $CBBscore1, $CBBscore2) = @_;

  $CBBgametime = convertTime($CBBgametime);  #Clean up time display and convert to local time zone

  if ($CBBscore1 eq '' && $showgame>0) {  #upcoming game
    push(@CBBdisplayItems1, 'College Basketball');
    push(@CBBdisplayItems2, shortenCBB($CBBteam1) . ' @ ' . shortenCBB($CBBteam2) . '-' . $CBBgametime);
    push(@CBBdisplayIntervals, $showgame);
  }
  elsif ($CBBgametime ne 'F' && $showactivegame >0 && $CBBscore1 ne '') { #active game
    $newActiveGames = 1;
	 push(@CBBdisplayItems1, 'College Basketball');
    push(@CBBdisplayItems2, shortenCBB($CBBteam1) . ' ' . $CBBscore1 . ' @ ' . shortenCBB($CBBteam2) . ' ' . $CBBscore2 . ' -' . $CBBgametime);
    push(@CBBdisplayIntervals, $showactivegame);
  }
  else {  #Must be finished game?
	 push(@CBBdisplayItems1, 'College Basketball');
    push(@CBBdisplayItems2, shortenCBB($CBBteam1) . ' ' . $CBBscore1 . ' @ ' . shortenCBB($CBBteam2) . ' ' . $CBBscore2 . ' -' . $CBBgametime);
    push(@CBBdisplayIntervals, $showgame);
  }
}

sub getCFB {  #Set up Async HTTP request for college football
	my $timerObj = shift; #Should be undef
	my $client = shift;
	
	#my $url = 'http://sports-ak.espn.go.com/ncf/scoreboard?confId=80';
	my $url;
	if ($cfballconf != 1000) { #Top 25
		$url = 'http://sports-ak.espn.go.com/ncf/scoreboard?confId='.$cfballconf;
	}
	else {
		$url = 'http://sports-ak.espn.go.com/ncf/scoreboard';
	}
	
	my $http = Slim::Networking::SimpleAsyncHTTP->new(\&gotCFB,
											  \&gotErrorViaHTTP,
											  {caller => 'getCFB',
											   client => $client});							  
														  
	$::d_plugins && msg("SuperDateTime: async request: $url\n");
	$http->get($url);
}

sub gotCFB {
	my $http = shift;
	my $params = $http->params();
	my $client = $params->{'client'};

	@CFBdisplayItems1 = ();
	@CFBdisplayItems2 = ();
	@CFBdisplayIntervals = ();

   $::d_plugins && msg("SuperDateTime: got " . $http->url() . "\n");
	#$::d_plugins && msg("SuperDateTime: content type is " . $http->headers()->{'Content-Type'} . "\n");

	my $content = $http->content();

	my @ary=split /"dateChange">-/,$content; #break large string into day array

	for (@ary) {
		if (m/Today/) { #Find today's games 
			#my @todaysGames=split /teamTop/,$1;  #break large string into individual games
			my @todaysGames=split /teamTop/;  #break large string into individual games

			for (@todaysGames) {
				if(/>(.*) ET<\/td>.*teamId=\d.*"> ?(.*)<\/a>.*teamId=\d.*"> ?(.*)<\/a> <s/) { #upcoming game
					#$gametime = $1; $team1 = $2; $team2 = $3;
					if ((teamCheck($2,\@CFBteams)==1) || (teamCheck($3,\@CFBteams)==1)) {
						CFBdisplayLines($client, $1, $2, $3, '', '');
					}
				}
				elsif(/>(.*)<\/td>.*teamId=\d.*"> ?(.*)<\/a>.*teamId=\d.*"> ?(.*)<\/a> .*tScoreLine.*>(\d.*)<\/td>.*tScoreLine.*>(\d.*)<\/td>/s) { #active game
					#$gametime = $1; $team1 = $2; $team2 = $3; $team1score = $4; $team2score = $5;
					if ((teamCheck($2,\@CFBteams)==1) || (teamCheck($3,\@CFBteams)==1)) {
						CFBdisplayLines($client, $1, $2, $3, $4, $5);
					}
				}
			}	 
		}
	}

	$refreshCounter--;
	checkRefreshStatus();
}

sub CFBdisplayLines {
	#Figure out/Format display lines
	my ($client, $CFBgametime, $CFBteam1, $CFBteam2, $CFBscore1, $CFBscore2) = @_;

	my $rank1 = '';
	my $rank2 = '';
	
	if ($CFBteam1 =~ /(\(\d+\)) (.+)/) {
		$rank1 = $1;
		$CFBteam1 = $2;
	}

	if ($CFBteam2 =~ /(\(\d+\)) (.+)/) {
		$rank2 = $1;
		$CFBteam2 = $2;
	}

	$CFBgametime = convertTime($CFBgametime);  #Clean up time display and convert to local time zone

	#Add team icons
	my $icon1='';
	my $icon2='';
	#if (defined $CFBmap{$CFBteam1}) { #Are there icons for each team?
	#	$icon1 = $client->symbols('cfb-'.$CFBmap{$CFBteam1});
	#}
					
	#if (defined $CFBmap{$CFBteam2}) {
	#	$icon2 = $client->symbols('cfb-'.$CFBmap{$CFBteam2});
	#}

  if ($CFBscore1 eq '' && $showgame>0) {  #upcoming game
    push(@CFBdisplayItems1, 'College Football');
    push(@CFBdisplayItems2, $icon1.$rank1.shortenCFB($CFBteam1) . ' @ ' . $icon2.$rank2.shortenCFB($CFBteam2) . '-' . $CFBgametime);
    push(@CFBdisplayIntervals, $showgame);
  }
  elsif ($CFBgametime ne 'F' && $showactivegame >0 && $CFBscore1 ne '') { #active game
    $newActiveGames = 1;
    push(@CFBdisplayItems1, 'College Football');    
    push(@CFBdisplayItems2, $icon1.$rank1.shortenCFB($CFBteam1) . ' ' . $CFBscore1 . ' @ ' . $icon2.$rank2.shortenCFB($CFBteam2) . ' ' . $CFBscore2 . ' -' . $CFBgametime);
    push(@CFBdisplayIntervals, $showactivegame);
  }
  else {  #Must be finished game?
    push(@CFBdisplayItems1, 'College Football');
    push(@CFBdisplayItems2, $icon1.$rank1.shortenCFB($CFBteam1) . ' ' . $CFBscore1 . ' @ ' . $icon2.$rank2.shortenCFB($CFBteam2) . ' ' . $CFBscore2 . ' -' . $CFBgametime);
    push(@CFBdisplayIntervals, $showgame);
  }

}

sub getNHL {  #Set up Async HTTP request for NHL
	#my $url ='http://sports.espn.go.com/nhl/scoreboard?date=20051009';
	#my $url = 'http://sports.espn.go.com/nhl/scoreboard?date=' . $year . $mon . $mday;
	my $url = 'http://sports.espn.go.com/nhl/scoreboard?date=' . $lastRefresh;

	my $http = Slim::Networking::SimpleAsyncHTTP->new(\&gotNHL,
														  \&gotErrorViaHTTP,
														  {caller => 'getNHL'});
	$::d_plugins && msg("SuperDateTime: async request: $url\n");
	$http->get($url);

}

sub gotNHL {
   @NHLdisplayItems1 = (); 
	@NHLdisplayItems2 = ();
	@NHLdisplayIntervals = ();
	$refreshTracker[2] = 0;

	my $http = shift;
	#my $params = $http->params();

	$::d_plugins && msg("SuperDateTime: got " . $http->url() . "\n");
	#$::d_plugins && msg("SuperDateTime: content type is " . $http->headers()->{'Content-Type'} . "\n");

	my $content = $http->content();
        
	my @ary=split /\n/,$content; #break large string into array

	for (@ary) {
		if (/-st">(.+)<\/td><.+team=\w+">(.+)<\/a>.+team=\w+">(.+)<\/a> <span id=".+-atot">(\d+)<\/td>.+-htot">(\d+)</) { #Active or complete game
			#$gametime = $1; $team1 = $2; $team2 = $3; $team1score = $4; $team2score = $5;

			if ((teamCheck($2,\@NHLteams)==1) || (teamCheck($3,\@NHLteams)==1)) {
				NHLdisplayLines($1, $2, $3, $4, $5);
			}
		}
		elsif (/-st">(.+)<\/td><.+team=\w+">(.+)<\/a>.+team=\w+">(.+)<\/a> <span id="/) { #Upcoming game
			#$gametime = $1; $team1 = $2; $team2 = $3;

			if ((teamCheck($2,\@NHLteams)==1) || (teamCheck($3,\@NHLteams)==1)) {
				NHLdisplayLines($1, $2, $3, undef, undef);
			}
		}
	}

	$refreshCounter--;
	checkRefreshStatus();
	
}

sub NHLdisplayLines {
  #Figure out/Format display lines
  my ($NHLgametime, $NHLteam1, $NHLteam2, $NHLscore1, $NHLscore2) = @_;

  $NHLgametime = convertTime($NHLgametime);  #Clean up time display and convert to local time zone

  if ($NHLscore1 eq '' && $showgame>0) {  #upcoming game
	 $refreshTracker[2] = 1;
    push(@NHLdisplayItems1, 'NHL');
    push(@NHLdisplayItems2, shortenNHL($NHLteam1) . ' @ ' . shortenNHL($NHLteam2) . '-' . $NHLgametime);
    push(@NHLdisplayIntervals, $showgame);
  }
  elsif ($NHLgametime ne 'F' && $showactivegame >0 && $NHLscore1 ne '') { #active game
    $newActiveGames = 1;
	 $refreshTracker[2] = 1;
    push(@NHLdisplayItems1, 'NHL');
    push(@NHLdisplayItems2, shortenNHL($NHLteam1) . ' ' . $NHLscore1 . ' @ ' . shortenNHL($NHLteam2) . ' ' . $NHLscore2 . ' -' . $NHLgametime);
    push(@NHLdisplayIntervals, $showactivegame);
  }
  else {  #Must be finished game?
    push(@NHLdisplayItems1, 'NHL');
    push(@NHLdisplayItems2, shortenNHL($NHLteam1) . ' ' . $NHLscore1 . ' @ ' . shortenNHL($NHLteam2) . ' ' . $NHLscore2 . ' -' . $NHLgametime);
    push(@NHLdisplayIntervals, $showgame);
  }
}

sub getNFL {  #Set up Async HTTP request for NFL
	my $timerObj = shift; #Should be undef
	my $client = shift;
	
	my $url = 'http://sports.espn.go.com/nfl/scoreboard';
	
	my $http = Slim::Networking::SimpleAsyncHTTP->new(\&gotNFL,
												  \&gotErrorViaHTTP,
												  {caller => 'getNFL',
												   client => $client});							  
														  
	$::d_plugins && msg("SuperDateTime: async request: $url\n");
	$http->get($url);
}

sub gotNFL {
	my $http = shift;
	my $params = $http->params();
	my $client = $params->{'client'};

	@NFLdisplayItems1 = ();
	@NFLdisplayItems2 = ();
	@NFLdisplayIntervals = ();

   $::d_plugins && msg("SuperDateTime: got " . $http->url() . "\n");
	#$::d_plugins && msg("SuperDateTime: content type is " . $http->headers()->{'Content-Type'} . "\n");

	my $content = $http->content();

	my @ary=split /"dateChange">-/,$content; #break large string into day array

	for (@ary) {
		if (m/Today's/) { #Find today's games 
			#my @todaysGames=split /teamTop/,$1;  #break large string into individual games

			my @todaysGames=split /teamTop/;  #break large string into individual games

			for (@todaysGames) {
				if(/>(.*) ET<\/td>.*teamId=\d.*">(.*)<\/a>.*teamId=\d.*">(.*)<\/a> /) { #upcoming game
					#$gametime = $1;
					#$team1 = $2;
					#$team2 = $3;
					if ((teamCheck($2,\@NFLteams)==1) || (teamCheck($3,\@NFLteams)==1)) {
						NFLdisplayLines($client, $1, $2, $3, '', '');
					}
				}
				elsif(/>(.*)<\/td>.*teamId=\d.*">(.*)<\/a>.*teamId=\d.*">(.*)<\/a> .*tScoreLine.*>(\d.*)<\/td>.*tScoreLine.*>(\d.*)<\/td>/s) { #active game
					#$gametime = $1;
					#$team1 = $2;
					#$team2 = $3;
					#$team1score = $4;
					#$team2score = $5;
					if ((teamCheck($2,\@NFLteams)==1) || (teamCheck($3,\@NFLteams)==1)) {
						NFLdisplayLines($client, $1, $2, $3, $4, $5);
					}
				}
			}	 
		}
	}

	$refreshCounter--;
	checkRefreshStatus();
}

sub NFLdisplayLines {
	#Figure out/Format display lines
	my ($client, $NFLgametime, $NFLteam1, $NFLteam2, $NFLscore1, $NFLscore2) = @_;

	$NFLgametime = convertTime($NFLgametime);  #Clean up time display and convert to local time zone

	my $team1 = '';
	my $team2 = '';
	
	if ($teamLogos == 0) { #No logos
		$team1 = shortenNFL($NFLteam1);
		$team2 = shortenNFL($NFLteam2) 
	}
	elsif ($teamLogos == 1) { #Logo no text
		if (defined $NFLmap{$NFLteam1}) { #Are there logos for team1?
			$team1 = $client->symbols('nfl-'.$NFLmap{$NFLteam1});
		}
		else { #No logo available
			$team1 = shortenNFL($NFLteam1);
		}
			
		if (defined $NFLmap{$NFLteam2}) { #Are there logos for team2
			$team2 = $client->symbols('nfl-'.$NFLmap{$NFLteam2});
		}
		else { #No logo available
			$team2 = shortenNFL($NFLteam2);
		}		
	}
	else { #Logo and text
		if (defined $NFLmap{$NFLteam1}) { #Are there logos for team1?
			$team1 = $client->symbols('nfl-'.$NFLmap{$NFLteam1});
		}
			
		if (defined $NFLmap{$NFLteam2}) { #Are there logos for team2
			$team2 = $client->symbols('nfl-'.$NFLmap{$NFLteam2});
		}	
		
		$team1 = $team1 . shortenNFL($NFLteam1);
		$team2 = $team2 . shortenNFL($NFLteam2);
	}


	if ($NFLscore1 eq '' && $showgame>0) {  #upcoming game
		push(@NFLdisplayItems1, 'NFL');
		push(@NFLdisplayItems2, $team1 . ' @ ' . $team2 . '-' . $NFLgametime);
		push(@NFLdisplayIntervals, $showgame);
	}
	elsif ($NFLgametime ne 'F' && $showactivegame >0 && $NFLscore1 ne '') { #active game
		$newActiveGames = 1;
		push(@NFLdisplayItems1, 'NFL');    
		push(@NFLdisplayItems2, $team1 . ' ' . $NFLscore1 . ' @ ' . $team2 . ' ' . $NFLscore2 . ' -' . $NFLgametime);
		push(@NFLdisplayIntervals, $showactivegame);
	}
	else {  #Must be finished game?
		push(@NFLdisplayItems1, 'NFL');
		push(@NFLdisplayItems2, $team1 . ' ' . $NFLscore1 . ' @ ' . $team2 . ' ' . $NFLscore2 . ' -' . $NFLgametime);
		push(@NFLdisplayIntervals, $showgame);
	}

}

sub convertTime {

  my $gametime = shift;

  my $hour = 0;
  my $minute = 0;
  my $ampm = '';
  my $offset = $timeoffset;

  if ($gametime =~ /(\d+:\d+), (\d+).*Period/) { #Active NHL game
		$gametime = $1 . '/' . $2;
  }
  elsif ($gametime =~ /(\d+) Period, End/) { #NHL game, end of period
		$gametime = 'E'.$1;
  }
  elsif ($gametime =~ /(\D)\D+(\d+)/) { #Active MLB game, shorten inning info
		$gametime = $1 . $2;
  }
  elsif ($gametime =~ /(\d*\d+:\d\d) (\d)\w\w/) { #Active NBA/NFL game
		$gametime = $1 . '/' . $2;
  }
  elsif ($gametime =~ /(\d+):(\d+) (\w\w)/) { #Future game, convert timezone
    $hour = $1;
    $minute = $2;
    $ampm = lc($3);

    while ($offset != 0) {
      if ($offset >0) {
        $offset = $offset -1;
        $hour = $hour +1;
        if ($hour == 13) {
          $hour = 1;
        }
        elsif ($hour == 12) {
          if ($ampm eq 'am') {
            $ampm = 'pm';
          }
          else {
            $ampm = 'am';
          }
        }
      }
      else {
        $offset = $offset +1;
        $hour = $hour -1;
        if ($hour == 0) {
          $hour = 12;
        }
        elsif ($hour == 11) {
          if ($ampm eq 'am') {
            $ampm = 'pm';
          }
          else {
            $ampm = 'am';
          }
        }
      }
    } 
     
    $gametime = $hour . ':' . $minute . $ampm;
  }
  elsif ($gametime =~ /Final - OT/) { #NBA OT Final
    $gametime = 'FOT';
  }
  elsif ($gametime =~ /(\D)\D.*/) { #Final or Delayed MLB game
    $gametime = $1;
  }

  return $gametime;
}


sub shortenMLB {
  my $long = shift;
  
  if ($long =~ m/^Chicago Cubs/) { $long = 'Cubs';}
  elsif ($long=~ m/^NY Yankees/) { $long = 'Yankees';}
  elsif ($long =~ m/^San Francisco/) { $long = 'Giants';}
  elsif ($long =~ m/^White Sox/) { $long = 'WSox';}
  elsif ($long =~ m/^LA Dodgers/) { $long = 'Dodgers';}
  elsif ($long =~ m/^LA Angels/) { $long = 'Angels';}
  elsif ($long =~ m/^Kansas City/) { $long = 'Royals';}
  elsif ($long =~ m/^Tampa Bay/) { $long = 'TB';}
  elsif ($long =~ m/^Cincinnati/) { $long = 'Reds';}
  elsif ($long =~ m/^Philadelphia/) { $long = 'Phillies';}
  elsif ($long =~ m/^Washington/) { $long = 'Nationals';}
  elsif ($long =~ m/^Cleveland/) { $long = 'Indians';}
  elsif ($long =~ m/^Baltimore/) { $long = 'Orioles';}
  elsif ($long =~ m/^Florida/) { $long = 'Marlins';}
  elsif ($long =~ m/^Atlanta/) { $long = 'Braves';}
  elsif ($long =~ m/^Colorado/) { $long = 'Rockies';}
  elsif ($long =~ m/^Detroit/) { $long = 'Tigers';}
  elsif ($long =~ m/^Pittsburgh/) { $long = 'Pirates';}
  elsif ($long =~ m/^NY Mets/) { $long = 'Mets';}
  elsif ($long =~ m/^Houston/) { $long = 'Astros';}
  elsif ($long =~ m/^St. Louis/) { $long = 'Cardinals';}
    
  return $long;
}

sub shortenNBA {
  my $long = shift;
  
  if ($long =~ m/^San Antonio/) { $long = 'Spurs';}
  elsif ($long=~ m/^Washington/) { $long = 'Wizards';}
  elsif ($long =~ m/^Philadelphia/) { $long = '76ers';}
  elsif ($long =~ m/^Sacramento/) { $long = 'Kings';}
  elsif ($long =~ m/^LA Clippers/) { $long = 'Clippers';}
  elsif ($long =~ m/^LA Lakers/) { $long = 'Lakers';}
  elsif ($long =~ m/^Golden State/) { $long = 'Warriors';}
  elsif ($long =~ m/^New Orleans/) { $long = 'Hornets';}
  elsif ($long =~ m/^NO\/Oklahoma City/) { $long = 'Hornets';}
  elsif ($long =~ m/^Minnesota/) { $long = 'TWolves';}
  elsif ($long =~ m/^Charlotte/) { $long = 'Bobcats';}
  elsif ($long =~ m/^Cleveland/) { $long = 'Cavaliers';}
  elsif ($long =~ m/^Milwaukee/) { $long = 'Bucks';}
  elsif ($long =~ m/^New Jersey/) { $long = 'Nets';}
  elsif ($long =~ m/^New York/) { $long = 'Knicks';}
  elsif ($long =~ m/^Chicago/) { $long = 'Bulls';}
  elsif ($long =~ m/^Toronto/) { $long = 'Raptors';}
  elsif ($long =~ m/^Houston/) { $long = 'Rockets';}
  elsif ($long =~ m/^Utah/) { $long = 'Jazz';}
  elsif ($long =~ m/^Phoenix/) { $long = 'Suns';}
  elsif ($long =~ m/^Orlando/) { $long = 'Magic';}
  elsif ($long =~ m/^Atlanta/) { $long = 'Hawks';}
  elsif ($long =~ m/^Miami/) { $long = 'Heat';}

  return $long;
}

sub shortenCBB {
	my $long = shift;
  
#	YOU CAN MODIFY THIS LIKE THE EXAMPLE BELOW TO SHORTEN YOUR TEAM NAMES...
	if ($long =~ m/^Illinois/) { $long = 'Illini';}
#  elsif ($long=~ m/^Washington/) { $long = 'Wizards';}
#  elsif ($long =~ m/^Philadelphia/) { $long = '76ers';}

	return $long;
}

sub shortenCFB {
	my $long = shift;
  
#	YOU CAN MODIFY THIS LIKE THE EXAMPLES BELOW TO SHORTEN YOUR TEAM NAMES...
	if ($long =~ m/^Illinois/) { $long = 'Illini';}
	elsif ($long=~ m/^Notre Dame/) { $long = 'ND';}
	elsif ($long=~ m/^Southern Methodist/) { $long = 'SMU';}
	elsif ($long=~ m/^Ohio State/) { $long = 'OSU';}
	elsif ($long=~ m/^Washington State/) { $long = 'WSU';}
	elsif ($long=~ m/^Boston College/) { $long = 'BC';}
	elsif ($long=~ m/^Wisconsin/) { $long = 'Wisc.';}
	elsif ($long=~ m/^Bowling Green/) { $long = 'BGSU';}
	elsif ($long=~ m/^Brigham Young/) { $long = 'BYU';}
	elsif ($long=~ m/^Northwestern/) { $long = 'NW';}
	elsif ($long=~ m/^San Diego State/) { $long = 'SDSU';}
	elsif ($long=~ m/^San Jose State/) { $long = 'SJSU';}

	return $long;
}

sub shortenNHL {
	my $long = shift;
  
	if ($long =~ m/^Vancouver/) { $long = 'Canucks';}
	elsif ($long=~ m/^Edmonton/) { $long = 'Oilers';}
	elsif ($long =~ m/^New Jersey/) { $long = 'Devils';}
	elsif ($long =~ m/^NY Rangers/) { $long = 'Rangers';}
	elsif ($long =~ m/^Philadelphia/) { $long = 'Flyers';}
	elsif ($long =~ m/^NY Islanders/) { $long = 'Islanders';}
	elsif ($long =~ m/^Pittsburgh/) { $long = 'Penguins';}
	#elsif ($long =~ m/^Montreal/) { $long = 'Canadiens';}
	#elsif ($long =~ m/^Ottawa/) { $long = 'Senators';}
	elsif ($long =~ m/^Buffalo/) { $long = 'Sabres';}
	elsif ($long =~ m/^Boston/) { $long = 'Bruins';}
	#elsif ($long =~ m/^Toronto/) { $long = 'Maple Leafs';}
	#elsif ($long =~ m/^Florida/) { $long = 'Panthers';}
	#elsif ($long =~ m/^Atlanta/) { $long = 'Thrashers';}
	#elsif ($long =~ m/^Tampa Bay/) { $long = 'Lightning';}
	elsif ($long =~ m/^Washington/) { $long = 'Capitals';}
	#elsif ($long =~ m/^Carolina/) { $long = 'Hurricanes';}
	#elsif ($long =~ m/^Detroit/) { $long = 'Red Wings';}
	#elsif ($long =~ m/^Nashville/) { $long = 'Predators';}
	#elsif ($long =~ m/^Chicago/) { $long = 'Black Hawks';}
	#elsif ($long =~ m/^Columbus/) { $long = 'Blue Jackets';}
  	elsif ($long =~ m/^St. Louis/) { $long = 'Blues';}
	elsif ($long =~ m/^Minnesota/) { $long = 'Wild';}
	#elsif ($long =~ m/^Colorado/) { $long = 'Avalanche';}
	elsif ($long =~ m/^Calgary/) { $long = 'Flames';}
	elsif ($long =~ m/^Anaheim/) { $long = 'Ducks';}
	elsif ($long =~ m/^Dallas/) { $long = 'Stars';}
	elsif ($long =~ m/^Los Angeles/) { $long = 'Kings';}
	elsif ($long =~ m/^San Jose/) { $long = 'Sharks';}
	#elsif ($long =~ m/^Phoenix/) { $long = 'Coyotes';}
	
	return $long;
}

sub shortenNFL {
  my $long = shift;
  
  if ($long =~ m/^Chicago/) { $long = 'Bears';}
  elsif ($long=~ m/^Green Bay/) { $long = 'Packers';}
  elsif ($long=~ m/^Indianapolis/) { $long = 'Colts';}
  elsif ($long=~ m/^Philadelphia/) { $long = 'Eagles';}
  elsif ($long=~ m/^Pittsburgh/) { $long = 'Steelers';}
  elsif ($long=~ m/^New Orleans/) { $long = 'Saints';}
  elsif ($long=~ m/^New England/) { $long = 'Patriots';}
  elsif ($long=~ m/^San Francisco/) { $long = '49ers';}
  elsif ($long=~ m/^Jacksonville/) { $long = 'Jaguars';}
  elsif ($long=~ m/^Tennessee/) { $long = 'Titans';}
  #elsif ($long=~ m/^Tampa Bay/) { $long = 'Buccaneers';}
  elsif ($long=~ m/^Washington/) { $long = 'Redskins';}
  elsif ($long=~ m/^New York Jets/) { $long = 'Jets';}
  elsif ($long=~ m/^New York Giants/) { $long = 'Giants';}
  elsif ($long=~ m/^Cleveland/) { $long = 'Browns';}
  elsif ($long=~ m/^St. Louis/) { $long = 'Rams';}
  elsif ($long=~ m/^Kansas City/) { $long = 'Chiefs';}
  elsif ($long=~ m/^Minnesota/) { $long = 'Vikings';}
  elsif ($long=~ m/^Baltimore/) { $long = 'Ravens';}
  elsif ($long=~ m/^Buffalo/) { $long = 'Bills';}
  elsif ($long=~ m/^Houston/) { $long = 'Texans';}

  return $long;
}

sub setMode() {
	my $client = shift;
	$client->lines(\&lines);
	
	# setting this param will call client->update() frequently
	$client->param('modeUpdateInterval', 1); # seconds
	
}

sub lines {
	my $client = shift;
	
	my $saver = Slim::Player::Source::playmode($client) eq 'play' ? 'screensaver' : 'idlesaver';
	my $line2 = $client->string('SETUP_SCREENSAVER_USE');
	my $overlay2 = Slim::Buttons::Common::checkBoxOverlay($client, $client->prefGet($saver) eq 'SCREENSAVER.superdatetime');
	
	return {
		'line'    => [ $client->string('PLUGIN_SCREENSAVER_SUPERDATETIME'), $line2 ],
		'overlay' => [ undef, $overlay2 ]
	};
}

sub getFunctions {
	return {
		'up' => sub  {
			my $client = shift;
			my $button = shift;
			$client->bumpUp() if ($button !~ /repeat/);
		},
		'down' => sub  {
			my $client = shift;
			my $button = shift;
			$client->bumpDown() if ($button !~ /repeat/);;
		},
		'left' => sub  {
			my $client = shift;
			Slim::Buttons::Common::popModeRight($client);
		},
		'right' => sub  {
			my $client = shift;
			
			my $saver = Slim::Player::Source::playmode($client) eq 'play' ? 'screensaver' : 'idlesaver';
		
			if ($client->prefGet($saver) ne 'SCREENSAVER.superdatetime') {
				$client->prefSet($saver,'SCREENSAVER.superdatetime');
			} else {
				$client->prefSet($saver, $Slim::Player::Player::defaultPrefs->{$saver});
			}
		},
		'stop' => sub {
			my $client = shift;
			Slim::Buttons::Common::pushMode($client, 'SCREENSAVER.superdatetime');
		},
		'showme' => sub { #Function to force screensaver into screensaver mode
			my $client = shift;
			Slim::Buttons::Common::pushMode($client, 'SCREENSAVER.superdatetime');
		}	
	};
}

sub handleIndex {
	my ($client, $params) = @_;
	my $body;

	$params->{'enable'} =
		($client->prefGet('screensaver') eq 'SCREENSAVER.superdatetime') ? 0 : 1;

	return Slim::Web::HTTP::filltemplatefile(
			'plugins/SuperDateTime/index.html',
			$params,
		);
}

sub handleEnable {
	my ($client, $params) = @_;
	my $body;

	if ($params->{'enable'}) {
		Slim::Utils::Prefs::clientSet(
			$client,
			'screensaver',
			'SCREENSAVER.superdatetime');
	} else {
		Slim::Utils::Prefs::clientSet(
			$client,
			'screensaver',
			'screensaver');
	}
	return Slim::Web::HTTP::filltemplatefile(
			'plugins/SuperDateTime/enable.html',
			$params,
	);
}

sub webPages_disabled {
	my %pages = (
		"index\.(?:htm|xml)" => \&handleIndex,
		"enable\.(?:htm|xml)" => \&handleEnable,
	);

	return (\%pages, "index.html");
}

# First, Register the screensaver mode here.  Must make the call to addStrings in order to have plugin
# localization available at this point.
sub screenSaver() {
	Slim::Buttons::Common::addSaver('SCREENSAVER.superdatetime', getScreensaverSuperDatetime(), \&setScreensaverSuperDateTimeMode,\&leaveScreensaverSuperDateTimeMode,'PLUGIN_SCREENSAVER_SUPERDATETIME');
}

our %mapping = ('arrow_up' => 'up',
					'arrow_right' => 'right',
					'arrow_left' => 'left',
					'add.single' => 'refresh',
					'arrow_down' => 'down',
					'fwd'        => 'wnext',
					'rew'        => 'wprev',
					'size.hold'  => 'size.hold');

our %screensaverSuperDateTimeFunctions = (
	'done' => sub  {
					my ($client, $funct, $functarg) = @_;
					Slim::Buttons::Common::popMode($client);
					$client->update();
					#pass along ir code to new mode if requested
					if (defined $functarg && $functarg eq 'passback') {
						Slim::Hardware::IR::resendButton($client);
					}
	},
	'up' => sub  {
		my $client = shift;
		
		if (!$client->display->hasScreen2()) { #Not Dual screens
			$weathershowing{$client} = 1; #Reset weather showoing in case up was hit while displaying weather
		
			if ($scrollType eq 'Ticker') { #Set flag to reset out of ticker mode
				$killTicker = 1;
			}
		
			if ($nowshowing{$client} == 0) { #Is the time currently showing?
				if($topNowShowing{$client} == (scalar @TOPdisplayItems-1)) {
					$topNowShowing{$client} = 0;
				}
				else {
					$topNowShowing{$client}++;
				}
			}
			else {
				$nowshowing{$client} = 0; #Show the time
			}
		
			killClientTimers($client);
			Slim::Utils::Timers::setTimer($client, Time::HiRes::time() + 10, \&nextDisplayItem);
		}
		else { #Dual screens
			if($topNowShowing{$client} == (scalar @TOPdisplayItems-1)) {
				$topNowShowing{$client} = 0;
			}
			else {
				$topNowShowing{$client}++;
			}
		}

		$client->update(); #Refresh the display
	},
	'down' => sub  {
		my $client = shift;
		
		if (!$client->display->hasScreen2()) { #Not Dual screens
			$weathershowing{$client} = 1; #Reset weather showoing incase down was hit while displaying weather
		
			if ($scrollType eq 'Ticker') { #Set flag to reset out of ticker mode
				$killTicker = 1;
			}
		
			if ($nowshowing{$client} == 0) { #Is the time currently showing?
				if($topNowShowing{$client} == 0) {
					$topNowShowing{$client} = scalar @TOPdisplayItems-1;
				}
				else {
					$topNowShowing{$client}--;
				}
			}
			else {
				$nowshowing{$client} = 0; #Show the time
			}
		
			killClientTimers($client);			
			Slim::Utils::Timers::setTimer($client, Time::HiRes::time() + 10, \&nextDisplayItem);	
		}
		else { #Dual screens
				if($topNowShowing{$client} == 0) {
					$topNowShowing{$client} = scalar @TOPdisplayItems-1;
				}
				else {
					$topNowShowing{$client}--;
				}
		}
		
		$client->update(); #Refresh the display
	},
	'refresh' => sub  {
		my $client = shift;
		$client->showBriefly("Refreshing Data...\n");
		Slim::Utils::Timers::killTimers(undef, \&refreshData);
		refreshData(undef, $client);
	},	
	'wnext' => sub  {
		my $client = shift;

		if (scalar @WETdisplayItems2 >0) { #Make sure there are some long forecasts to show
			killClientTimers($client);

			nextWeatherItem($client,1);
		}
		else {
			$client->bumpLeft();
		}
	},
	'wprev' => sub  {
		my $client = shift;
		
		if (scalar @WETdisplayItems2 >0) { #Make sure there are some long forecasts to show
			killClientTimers($client);
			nextWeatherItem($client,-1);
		}
		else {
			$client->bumpRight();
		}
	},	
	'right' => sub  {
		my $client = shift;
		
		if ((totalGames() + currentWeatherInterval()) >0) { #Are there games?
			killClientTimers($client);
			nextDisplayItem($client);
		}
		else {
			$client->bumpLeft();
		}
		
	},	
	'left' => sub  {
		my $client = shift;

		if ((totalGames() + currentWeatherInterval()) >0) { #Are there games?
			killClientTimers($client);
			prevDisplayItem($client);
		}
		else {
			$client->bumpRight();
		}
	},
	'size.hold' => sub  {
		my $client = shift;
		if ($client->power()) { #Client power is on
			Slim::Buttons::Common::popModeRight($client); #Bring client back to where they were b4 screensaver
		}
	},	
	
);

sub currentWeatherInterval {
	if (scalar @WETdisplayItems2 > 0) {
		if ($lweather == 4) {
			return 1;
		}
		if ($activeGames == 1 && $lweather == 2) {
			return 1;
		}
		elsif ($activeGames == 0 && $lweather == 3) {
			return 1;
		}
		else {
			return 0;
		}
	}
	else {
		return 0;
	}
}

sub totalGames {
	return scalar @MLBdisplayItems2 + scalar @NBAdisplayItems2 + scalar @NFLdisplayItems2 + scalar @NHLdisplayItems2 + scalar @CBBdisplayItems2 + scalar @CFBdisplayItems2 + scalar @STKdisplayItems1;
}

sub getScreensaverSuperDatetime {

	return \%screensaverSuperDateTimeFunctions;
}

sub setScreensaverSuperDateTimeMode() {
	my $client = shift;
	
	#***TESTING***   Need to make sure this only occurs once... instead of each setmode?
	
	my $key;
	my $value;
	while (($key, $value) = each(%NFLmap)){
		Slim::Display::Graphics::setCustomChar( 'nfl-'.$value, chr(hex $value), 'nfl.2' );
	}
	
	while (($key, $value) = each(%MLBmap)){
			Slim::Display::Graphics::setCustomChar( 'mlb-'.$value, chr(hex $value), 'mlb.2' );
	}
	
	$activeClients++;

	#$::d_plugins && msg("SuperDateTime: ENTERING Active Clients: " . $activeClients . "\n");
	Slim::Hardware::IR::addModeDefaultMapping('SCREENSAVER.superdatetime',\%mapping);
	Slim::Hardware::IR::addModeDefaultMapping('OFF.superdatetime',\%mapping);

	#Set default for top line per client
	if ((not defined($topNowShowing{$client})) && $client->textSize() != 2) { #Not large text
		$topNowShowing{$client} = 2;
	}
	elsif (not defined($topNowShowing{$client})) {
		$topNowShowing{$client} = 0;
	}

	if ($activeClients == 1) {
		Slim::Utils::Timers::killTimers(undef, \&refreshData); #Just in case there's a rogue timer
		Slim::Utils::Timers::setTimer(undef, Time::HiRes::time() + 3, \&refreshData, $client);
	}

	$nowshowing{$client} = 0; #Start on time display
	Slim::Utils::Timers::setTimer($client, Time::HiRes::time() + 10, \&nextDisplayItem);
			
	$client->lines(\&screensaverSuperDateTimelines);

	# setting this param will call client->update() frequently
	
	$client->modeParam('modeUpdateInterval', 1);
   if ($client->display->hasScreen2()) { #Dual screens
   	$client->modeParam('screen2','superdatetime'); #Inform that SuperDateTime is using both screens
	}
	
	#Graphical forecasts code...
	# get display size for player if at least Squeezebox2
	if( $client && $client->isa( "Slim::Player::Squeezebox2")) {
		$xmax{$client} = $client->display()->displayWidth();
		$ymax{$client} = $client->display()->bytesPerColumn() * 8;
		$::d_plugins && Slim::Utils::Misc::msg("SuperDateTime: found graphic display $xmax{$client} x $ymax{$client} ($client)\n");
	}
	# only use text on SqueezeboxG and SLIMP3
	else {
		$xmax{$client} = 0;
		$ymax{$client} = 0;
	}

	if (scalar @forecastG==0) {  #Only set the weather channel logo the first time
		clearCanvas($client); #Show weatherchannel logo at startup
		drawIcon($client,29,$ymax{$client}-1,$TWClogo);
   	$forecastG[0] = getFramebuf($client,$gxwidth);
   	$forecastG[1] = $forecastG[0];
   	$forecastG[2] = $forecastG[0];
	}
}

sub leaveScreensaverSuperDateTimeMode {
	my $client = shift;
	
	$activeClients--;
	#$::d_plugins && msg("SuperDateTime: LEAVING Active Clients: " . $activeClients . "\n");
	
	if ($activeClients == 0) {
		Slim::Utils::Timers::killTimers(undef, \&refreshData);
	}
	
	killClientTimers($client);

}

sub setupGroup {

   my %setupGroup = (
      PrefOrder => ['plugin_screensaver_superdatetime_city', 'plugin_screensaver_superdatetime_wunder', 'plugin_screensaver_superdatetime_weatherformat1t', 'plugin_screensaver_superdatetime_weatherformat1b', 'plugin_screensaver_superdatetime_weatherformat2t', 'plugin_screensaver_superdatetime_weatherformat2b', 'plugin_screensaver_superdatetime_temperature', 'plugin_screensaver_superdatetime_windunit', 'plugin_screensaver_superdatetime_averages',
                    'plugin_screensaver_superdatetime_offset', 'plugin_screensaver_superdatetime_scroll', 'plugin_screensaver_superdatetime_stocks', 'plugin_screensaver_superdatetime_stock1format', 'plugin_screensaver_superdatetime_stock2format', 'plugin_screensaver_superdatetime_teamlogos', 'plugin_screensaver_superdatetime_mlb', 'plugin_screensaver_superdatetime_nba', 'plugin_screensaver_superdatetime_nhl', 'plugin_screensaver_superdatetime_nfl', 'plugin_screensaver_superdatetime_cbballconf', 'plugin_screensaver_superdatetime_cbb', 'plugin_screensaver_superdatetime_cfballconf', 'plugin_screensaver_superdatetime_cfb', 'plugin_screensaver_superdatetime_refresh', 
                    'plugin_screensaver_superdatetime_time', 'plugin_screensaver_superdatetime_atime',
                    'plugin_screensaver_superdatetime_score', 'plugin_screensaver_superdatetime_ascore', 'plugin_screensaver_superdatetime_lweather'],
      GroupHead => string('SETUP_GROUP_PLUGIN_SCREENSAVER_SUPERDATETIME'),
      GroupDesc => string('SETUP_GROUP_PLUGIN_SCREENSAVER_SUPERDATETIME_DESC'),
      GroupLine => 1,
      GroupSub => 1,
      Suppress_PrefSub => 1,
      Suppress_PrefLine => 1,
      Suppress_PrefHead => 0
   );
   my %setupPrefs = (
      plugin_screensaver_superdatetime_city => {
		'onChange' => sub {
			$city = Slim::Utils::Prefs::get("plugin_screensaver_superdatetime_city");
		}
      },
      plugin_screensaver_superdatetime_wunder => {
		'PrefSize' => 'medium',
		'onChange' => sub {
			$wunderIdent = Slim::Utils::Prefs::get("plugin_screensaver_superdatetime_wunder");
		}
      },      
      plugin_screensaver_superdatetime_weatherformat1t => {
		'PrefSize' => 'large',
		'onChange' => sub {
			$weatherFormat1t = Slim::Utils::Prefs::get("plugin_screensaver_superdatetime_weatherformat1t");
		}
      },
      plugin_screensaver_superdatetime_weatherformat1b => {
		'PrefSize' => 'large',
		'onChange' => sub {
			$weatherFormat1b = Slim::Utils::Prefs::get("plugin_screensaver_superdatetime_weatherformat1b");
		}
      },
      plugin_screensaver_superdatetime_weatherformat2t => {
		'PrefSize' => 'large',
		'onChange' => sub {
			$weatherFormat2t = Slim::Utils::Prefs::get("plugin_screensaver_superdatetime_weatherformat2t");
		}
      },  
      plugin_screensaver_superdatetime_weatherformat2b => {
		'PrefSize' => 'large',
		'onChange' => sub {
			$weatherFormat2b = Slim::Utils::Prefs::get("plugin_screensaver_superdatetime_weatherformat2b");
		}
      },      
      plugin_screensaver_superdatetime_temperature => {
		'options' => {
			'0' => 'Fahrenheit',
			'1' => 'Celsius',
		},
		'onChange' => sub {
			$temptype = Slim::Utils::Prefs::get("plugin_screensaver_superdatetime_temperature");
		}
      },    
		plugin_screensaver_superdatetime_windunit => {
		'options' => {
			'0' => 'mi/hr',
			'1' => 'km/hr',
			'2' => 'kt/hr',
			'3' => 'm/s',
		},
		'onChange' => sub {
			$windspeedUnit = Slim::Utils::Prefs::get("plugin_screensaver_superdatetime_windunit");
		}
      },       
		plugin_screensaver_superdatetime_averages => {
		'options' => {
			'0' => 'OFF',
			'1' => 'ON',
		},
		'onChange' => sub {
			$show_averages = Slim::Utils::Prefs::get("plugin_screensaver_superdatetime_averages");
		}
      }, 
      plugin_screensaver_superdatetime_offset => {
		'options' => {
			'18' => '+18:00',
			'17' => '+17:00 Fiji',
			'16' => '+16:00',
			'15' => '+15:00 Melbourne,Sydney',
			'14' => '+14:00 Tokyo',
			'13' => '+13:00',
			'12' => '+12:00 Bangkok',
			'11' => '+11:00',
			'10' => '+10:00',
			'09' => '+09:00',
			'08' => '+08:00 Baghdad,Moscow',
			'07' => '+07:00 Athens',
			'06' => '+06:00 Amsterdam,Berlin,Rome,Prague,Madrid,Paris',
			'05' => '+05:00 Dublin,London',
			'04' => '+04:00',
			'03' => '+03:00',
			'02' => '+02:00',
			'01' => '+01:00',
			'00' => ' 00:00 Eastern',
			'-01' => '-01:00 Central',
			'-02' => '-02:00 Mountain',
			'-03' => '-03:00 Pacific',
			'-04' => '-04:00 Alaska',
			'-05' => '-05:00 Hawaii',
			'-06' => '-06:00',
			'-07' => '-07:00',
			'-08' => '-08:00',
			'-09' => '-09:00',
			'-10' => '-10:00',
		},
		'onChange' => sub {
			$timeoffset = Slim::Utils::Prefs::get("plugin_screensaver_superdatetime_offset");
		}
      },
		plugin_screensaver_superdatetime_scroll => {
		'options' => {
			'Basic' => 'Basic',
			'Slide' => 'Slide',
			'Ticker' => 'Ticker',
		},
		'onChange' => sub {
			$scrollType = Slim::Utils::Prefs::get("plugin_screensaver_superdatetime_scroll");
		}
      },
      plugin_screensaver_superdatetime_stocks => {
		'PrefSize' => 'large',
		'onChange' => sub {
			$stocks = Slim::Utils::Prefs::get("plugin_screensaver_superdatetime_stocks");
		}
      },
      plugin_screensaver_superdatetime_stock1format => {
		'PrefSize' => 'large',
		'onChange' => sub {
			$stockFormat1 = Slim::Utils::Prefs::get("plugin_screensaver_superdatetime_stock1format");
		}
      },
      plugin_screensaver_superdatetime_stock2format => {
		'PrefSize' => 'large',
		'onChange' => sub {
			$stockFormat2 = Slim::Utils::Prefs::get("plugin_screensaver_superdatetime_stock2format");
		}
      },
      plugin_screensaver_superdatetime_teamlogos => {
		'options' => {
			'0' => 'Text Only - No Logo',
			'1' => 'Logo Only - No Text',
			'2' => 'Logo and Text',
		},
		'onChange' => sub {
			$teamLogos = Slim::Utils::Prefs::get("plugin_screensaver_superdatetime_teamlogos");
		}
      },       
      plugin_screensaver_superdatetime_mlb => {
		'isArray' => 1,
		'arrayDeleteValue' => '0',
		'arrayDeleteNull' => 1,
		'arrayAddExtra' => 1,
		'options' => {
			'Cubs' => 'Chicago Cubs',
			'White Sox' => 'Chicago Sox',
			'Arizona' => 'Arizona',
			'Atlanta' => 'Atlanta',
			'Baltimore' => 'Baltimore',
			'Boston' => 'Boston',
			'Cincinnati' => 'Cincinnati',
			'Cleveland' => 'Cleveland',
			'Colorado' => 'Colorado',
			'Detroit' => 'Detroit',
			'Florida' => 'Florida',
			'Houston' => 'Houston',
			'Kansas City' => 'Kansas City',
			'LA Angels' => 'LA Angels',
			'LA Dodgers' => 'LA Dodgers',
			'Milwaukee' => 'Milwaukee',
			'Minnesota' => 'Minnesota',
			'NY Mets' => 'NY Mets',
			'NY Yankees' => 'NY Yankees',
			'Oakland' => 'Oakland',
			'Philadelphia' => 'Philadelphia',
			'Pittsburgh' => 'Pittsburgh',
			'San Diego' => 'San Diego',
			'San Francisco' => 'San Francisco',
			'Seattle' => 'Seattle',
			'St. Louis' => 'St. Louis',
			'Tampa Bay' => 'Tampa Bay',
			'Texas' => 'Texas',
			'Toronto' => 'Toronto',
			'Washington' => 'Washington',
			'0' => 'None',
			'1' => 'All'
		},
		'onChange' => sub {
			my ($client,$changeref,$paramref,$pageref) = @_;
			Slim::Web::Setup::processArrayChange($client, 'plugin_screensaver_superdatetime_mlb', $paramref, $pageref);
			@MLBteams = Slim::Utils::Prefs::getArray("plugin_screensaver_superdatetime_mlb");
			$refreshTracker[0] = 1; #Need to refresh MLB again
			#refreshSoon(); #Have all data refreshed once all variables updated.
		}
      },
      plugin_screensaver_superdatetime_nba => {
		'isArray' => 1,
		'arrayDeleteValue' => '0',
		'arrayDeleteNull' => 1,
		'arrayAddExtra' => 1,
		'options' => {
			'Boston' => 'Boston',
			'Philadelphia' => 'Philadelphia',
			'New Jersey' => 'New Jersey',
			'Toronto' => 'Toronto',
			'New York' => 'New York',
			'Detroit' => 'Detroit',
			'Chicago' => 'Chicago',
			'Indiana' => 'Indiana',
			'Cleveland' => 'Cleveland',
			'Milwaukee' => 'Milwaukee',
			'Miami' => 'Miami',
			'Washington' => 'Washington',
			'Orlando' => 'Orlando',
			'Charlotte' => 'Charlotte',
			'Atlanta' => 'Atlanta',
			'Seattle' => 'Seattle',
			'Denver' => 'Denver',
			'Minnesota' => 'Minnesota',
			'Portland' => 'Portland',
			'Utah' => 'Utah',
			'Phoenix' => 'Phoenix',
			'Sacramento' => 'Sacramento',
			'LA Clippers' => 'LA Clippers',
			'LA Lakers' => 'LA Lakers',
			'Golden State' => 'Golden State',
			'San Antonio' => 'San Antonio',
			'Dallas' => 'Dallas',
			'Houston' => 'Houston',
			'Memphis' => 'Memphis',
			'NO/Oklahoma City' => 'New Orleans',
			'0' => 'None',
			'1' => 'All'
		},
		'onChange' => sub {
			my ($client,$changeref,$paramref,$pageref) = @_;
			Slim::Web::Setup::processArrayChange($client, 'plugin_screensaver_superdatetime_nba', $paramref, $pageref);
			@NBAteams = Slim::Utils::Prefs::getArray("plugin_screensaver_superdatetime_nba");
			$refreshTracker[1] = 1; #Need to refresh NBA again
		}
      },
      plugin_screensaver_superdatetime_nhl => {
				'isArray' => 1,
				'arrayDeleteValue' => '0',
				'arrayDeleteNull' => 1,
				'arrayAddExtra' => 1,
				'options' => {
					'New Jersey' => 'New Jersey',
					'NY Rangers' => 'NY Rangers',
					'Philadelphia' => 'Philadelphia',
					'NY Islanders' => 'NY Islanders',
					'Pittsburgh' => 'Pittsburgh',
					'Montreal' => 'Montreal',
					'Ottawa' => 'Ottawa',
					'Buffalo' => 'Buffalo',
					'Boston' => 'Boston',
					'Toronto' => 'Toronto',
					'Atlanta' => 'Atlanta',
					'Tampa Bay' => 'Tampa Bay',
					'Florida' => 'Florida',
					'Washington' => 'Washington',
					'Carolina' => 'Carolina',
					'Detroit' => 'Detroit',
					'Nashville' => 'Nashville',
					'Chicago' => 'Chicago',
					'Colorado' => 'Colorado',
					'Columbus' => 'Columbus',
					'St. Louis' => 'St. Louis',
					'Minnesota' => 'Minnesota',
					'Edmonton' => 'Edmonton',
					'Vancouver' => 'Vancouver',
					'Calgary' => 'Calgary',
					'Anaheim' => 'Anaheim',
					'Dallas' => 'Dallas',
					'Los Angeles' => 'Los Angeles',
					'San Jose' => 'San Jose',
					'Phoenix' => 'Phoenix',
					'0' => 'None',
					'1' => 'All'
				},
				'onChange' => sub {
					my ($client,$changeref,$paramref,$pageref) = @_;
					Slim::Web::Setup::processArrayChange($client, 'plugin_screensaver_superdatetime_nhl', $paramref, $pageref);
					@NHLteams = Slim::Utils::Prefs::getArray("plugin_screensaver_superdatetime_nhl");
					$refreshTracker[2] = 1; #Need to refresh NHL again
				}
		      },
      plugin_screensaver_superdatetime_nfl => {
		'isArray' => 1,
		'arrayDeleteValue' => '0',
		'arrayDeleteNull' => 1,
		'arrayAddExtra' => 1,
		'options' => {
			'Dallas' => 'Dallas',
			'New York Giants' => 'New York Giants',
			'New York Jets' => 'New York Jets',
			'Philadelphia' => 'Philadelphia',
			'Washington' => 'Washington',
			'Chicago' => 'Chicago',
			'Green Bay' => 'Green Bay',
			'Minnesota' => 'Minnesota',
			'Detroit' => 'Detroit',
			'Atlanta' => 'Atlanta',
			'New Orleans' => 'New Orleans',
			'Tampa Bay' => 'Tampa Bay',
			'Carolina' => 'Carolina',
			'St. Louis' => 'St. Louis',
			'Arizona' => 'Arizona',
			'San Francisco' => 'San Francisco',
			'Seattle' => 'Seattle',
			'Denver' => 'Denver',
			'Buffalo' => 'Buffalo',
			'New England' => 'New England',
			'Miami' => 'Miami',
			'Cincinnati' => 'Cincinnati',
			'Cleveland' => 'Cleveland',
			'Pittsburgh' => 'Pittsburgh',
			'Baltimore' => 'Baltimore',
			'Tennessee' => 'Tennessee',
			'Jacksonville' => 'Jacksonville',
			'Houston' => 'Houston',
			'Indianapolis' => 'Indianapolis',
			'Denver' => 'Denver',
			'Kansas City' => 'Kansas City',
			'Oakland' => 'Oakland',
			'San Diego' => 'San Diego',
			'0' => 'None',
			'1' => 'All'
		},
		'onChange' => sub {
			my ($client,$changeref,$paramref,$pageref) = @_;
			Slim::Web::Setup::processArrayChange($client, 'plugin_screensaver_superdatetime_nfl', $paramref, $pageref);
			@NFLteams = Slim::Utils::Prefs::getArray("plugin_screensaver_superdatetime_nfl");
		}
      },
      plugin_screensaver_superdatetime_cbballconf => {
		'options' => {
			'0' => 'None',
			'50' => 'All',
			'1' => 'Am. East',
			'2' => 'ACC',
			'3' => 'A Ten',			
			'4' => 'Big East',			
			'7' => 'Big Ten',
			'46' => 'A-Sun',
			'8' => 'Big 12',
			'5' => 'Big Sky',
			'6' => 'B. South',
			'9' => 'B. West',
			'10' => 'CAA',
			'11' => 'C-USA',
			'43' => 'Indep.',
			'45' => 'HOR',
			'12' => 'Ivy',
			'13' => 'MAAC',
			'15' => 'Mid-Con',
			'14' => 'MAC',
			'16' => 'MEAC',
			'18' => 'MVC',
			'44' => 'MWC',
			'19' => 'NEC',
			'20' => 'OVC',
			'21' => 'Pac-10',
			'22' => 'Patriot',
			'23' => 'SEC',
			'24' => 'Southern',
			'25' => 'Southland',
			'26' => 'SWAC',
			'27' => 'S. Belt',
			'29' => 'WCC',
			'30' => 'WAC',
			'1000' => 'Top-25'
		},
		'onChange' => sub {
			$cbballconf = Slim::Utils::Prefs::get("plugin_screensaver_superdatetime_cbballconf");
		}
      }, 
	plugin_screensaver_superdatetime_cbb => { 
			'isArray' => 1
			,'arrayAddExtra' => 1
			,'arrayDeleteNull' => 1
			,'arrayDeleteValue' => ''
			,'arrayBasicValue' => 0
			,'PrefSize' => 'large'
			,'PrefInTable' => 1
			,'showTextExtValue' => 0
			,'onChange' => sub {
				my ($client,$changeref,$paramref,$pageref) = @_;
				Slim::Web::Setup::processArrayChange($client, 'plugin_screensaver_superdatetime_cbb', $paramref, $pageref);
				@CBBteams = Slim::Utils::Prefs::getArray("plugin_screensaver_superdatetime_cbb");				
			}
			},
      plugin_screensaver_superdatetime_cfballconf => {
		'options' => {
			'0' => 'None',
			'80' => 'All Div I-A',
			'1' => 'ACC',
			'4' => 'Big 12',
			'10' => 'Big East',			
			'5' => 'Big Ten',			
			'12' => 'C-USA',
			'46' => 'A-Sun',
			'18' => 'IA Indep.',
			'15' => 'MAC',
			'17' => 'MWC',
			'9' => 'Pac-10',
			'37' => 'S. Belt',
			'8' => 'SEC',
			'16' => 'WAC',
			'81' => 'All Div I-AA',
			'19' => 'A 10',
			'20' => 'Big Sky',
			'40' => 'Big South',
			'21' => 'Gateway',
			'43' => 'Great West',
			'32' => 'IAA Indep.',
			'22' => 'Ivy',
			'23' => 'MAAC',
			'24' => 'MEAC',
			'25' => 'NEC',
			'26' => 'OVC',
			'27' => 'Patriot',
			'28' => 'Pioneer',
			'29' => 'Southern',
			'30' => 'Southland',
			'31' => 'SWAC',
			'1000' => 'Top-25'
		},
		'onChange' => sub {
			$cfballconf = Slim::Utils::Prefs::get("plugin_screensaver_superdatetime_cfballconf");
		}
      }, 
	plugin_screensaver_superdatetime_cfb => { 
			'isArray' => 1
			,'arrayAddExtra' => 1
			,'arrayDeleteNull' => 1
			,'arrayDeleteValue' => ''
			,'arrayBasicValue' => 0
			,'PrefSize' => 'large'
			,'PrefInTable' => 1
			,'showTextExtValue' => 0
			,'onChange' => sub {
				my ($client,$changeref,$paramref,$pageref) = @_;
				Slim::Web::Setup::processArrayChange($client, 'plugin_screensaver_superdatetime_cfb', $paramref, $pageref);
				@CFBteams = Slim::Utils::Prefs::getArray("plugin_screensaver_superdatetime_cfb");
			}
			},			
	plugin_screensaver_superdatetime_refresh => {
		'onChange' => sub {
			$refreshint = Slim::Utils::Prefs::get("plugin_screensaver_superdatetime_refresh");
			#refreshSoon(); #Have all data refreshed once all variables updated.		
		}
      },
	plugin_screensaver_superdatetime_time => {
		'onChange' => sub {
			$showtime = Slim::Utils::Prefs::get("plugin_screensaver_superdatetime_time");
		}
      },
	plugin_screensaver_superdatetime_score => {
		'onChange' => sub {
			$showgame = Slim::Utils::Prefs::get("plugin_screensaver_superdatetime_score");
		}
      },
	plugin_screensaver_superdatetime_atime => {
		'onChange' => sub {
			$showactivetime = Slim::Utils::Prefs::get("plugin_screensaver_superdatetime_atime");
		}
      },
	plugin_screensaver_superdatetime_ascore => {
		'onChange' => sub {
			$showactivegame = Slim::Utils::Prefs::get("plugin_screensaver_superdatetime_ascore");
		}
      },
	plugin_screensaver_superdatetime_lweather => {
		'options' => {
			'1' => 'Never',
			'2' => 'Active Games Only',
			'3' => 'In-Active Games Only',
			'4' => 'Always',
		},	
		'onChange' => sub {
			$lweather = Slim::Utils::Prefs::get("plugin_screensaver_superdatetime_lweather");
		}
      },        
   );	
   return ( \%setupGroup, \%setupPrefs);
}

sub gotErrorViaHTTP {
	my $http = shift;
	my $params = $http->params();
	my $caller = $params->{'caller'};
	my $client = $params->{'client'}; #Only set by getWeather
	
	$::d_plugins && msg("SuperDateTime: error getting " . $http->url() . "\n");
	$::d_plugins && msg("SuperDateTime: " . $http->error() . "\n");

	$errorCount++;
	
	if ($errorCount >3) {
		$::d_plugins && msg("SuperDateTime: Network error count reached.\n");
		$status = '?';
		$refreshCounter--;
		checkRefreshStatus();
	}
	elsif ($caller eq "getWeather") {
		$::d_plugins && msg("SuperDateTime: Trying getWeather again.\n");
		getWeather(undef, $client);
	}
	elsif ($caller eq "getWunderground") {
		$::d_plugins && msg("SuperDateTime: Trying getWunderground again.\n");
		getWunderground();
	}
	elsif ($caller eq "getMLB") {
		$::d_plugins && msg("SuperDateTime: Trying getMLB again.\n");
		getMLB(undef, $client);
	}
	elsif ($caller eq "getNFL") {
		$::d_plugins && msg("SuperDateTime: Trying getNFL again.\n");
		getNFL(undef, $client);
	}
	elsif ($caller eq "getNBA") {
		$::d_plugins && msg("SuperDateTime: Trying getNBA again.\n");
		getNBA();
	}
	elsif ($caller eq "getNHL") {
		$::d_plugins && msg("SuperDateTime: Trying getNHL again.\n");
		getNHL();
	}
	elsif ($caller eq "getCBB") {
		$::d_plugins && msg("SuperDateTime: Trying getCBB again.\n");
		getCBB();
	}
	elsif ($caller eq "getCFB") {
		$::d_plugins && msg("SuperDateTime: Trying getCFB again.\n");
		getCFB(undef, $client);
	}
	elsif ($caller eq "getStocks") {
		$::d_plugins && msg("SuperDateTime: Trying getStocks again.\n");
		getStocks();
	}
	
}

sub nextWeatherItem {
	my $client = shift;
	my $caller = shift;
	
	$killTicker = 3;

	if (defined $weathershowing{$client}) {
		if ($caller == -1) {
			if ($weathershowing{$client} == 1) {
				$weathershowing{$client} = 3;
			}
			else {
				$weathershowing{$client}--;
			}
		}
		else {
			if ($weathershowing{$client} == 3) {
				$weathershowing{$client} = 1;
			}
			else {
				$weathershowing{$client}++;
			}
		}
	}
	else {
		if ($caller == -1) {
			$weathershowing{$client} = 3;
		}
		else {
			$weathershowing{$client} = 1;
		}
	}

	$displayLine1{$client} = $TOPdisplayItems[$weathershowing{$client}+1];
	$displayLine2{$client} = $WETdisplayItems2[$weathershowing{$client}-1];
	$nowshowing{$client} = 8; #Don't display the time...
	$displayGameID{$client} = 100; #Set to 100 so that it wont show any other forecasts when it calls nextdisplayitem

	if ($weathershowing{$client} == 3) {		
		#Need to give time for display lines to be called (+2)
		Slim::Utils::Timers::setTimer($client, Time::HiRes::time() + 2, \&setWeatherTimer,2);
	}
	else {
		#Need to give time for display lines to be called (+2)
		Slim::Utils::Timers::setTimer($client, Time::HiRes::time() + 2, \&setWeatherTimer,1);
	}

	#Update display
	if ($scrollType eq 'Basic') {
		$client->update(); #Refresh the display
	}
	else {
		if ($caller == -1) {
			$client->pushRight();
		}
		else {
			$client->pushLeft();
		}
	}	
	
}

sub nextDisplayItem {
	my $client = shift;
	
	my $timerInterval = 0;

	if ($nowshowing{$client} == 0) { #TIME
		$displayGameID{$client} = 0;
		$nowshowing{$client} = 1;
		return nextDisplayItem($client);
	}
	elsif ($nowshowing{$client} < 8) {  #Main sports and stocks
  		if ($displayGameID{$client} < ($#{$displayItems2[($nowshowing{$client}-1)]}+1)) { #More display items (games) to show
			$displayGameID{$client}++;
			$displayLine1{$client} = $displayItems1[$nowshowing{$client}-1][$displayGameID{$client}-1];
			$displayLine2{$client} = $displayItems2[$nowshowing{$client}-1][$displayGameID{$client}-1];
			$timerInterval = $displayIntervals[$nowshowing{$client}-1][$displayGameID{$client}-1];
		}
		else {
			$nowshowing{$client} = $nowshowing{$client}+1;
			$displayGameID{$client} = 0;
			return nextDisplayItem($client);
		}
	}
	elsif ($nowshowing{$client} == 8) {  #WEATHER FORECASTS
  		if (($displayGameID{$client} < (scalar @WETdisplayItems2)) && (currentWeatherInterval()>0)) { #More weather forecasts to show
			$displayGameID{$client}++;
			$timerInterval = currentWeatherInterval();
			$displayLine1{$client} = $TOPdisplayItems[$displayGameID{$client}+1];
			$displayLine2{$client} = $WETdisplayItems2[$displayGameID{$client}-1];
		}
		else { #Shall we display the time?
			if (($activeGames == 1) && ($showactivetime == 0)) { #Don't show time when active games
				$nowshowing{$client} = 1;
				return nextDisplayItem($client);
			}
			elsif ((($activeGames == 0) && ($showtime == 0)) && #Don't show time when no active games
				((totalGames() + scalar @WETdisplayItems2) >0)) #make sure there are some games to show
			{ 
				$nowshowing{$client} = 1;
				return nextDisplayItem($client);
			}
			else { #Show the time
				$nowshowing{$client} = 0;
				if ($activeGames == 0) {
					$timerInterval = $showtime;
				}
				else {
					$timerInterval = $showactivetime;
				}
			}
		}
  	}  
		
	#Update alarm clock status indicator
	my ($sec,$min,$hour,$mday,$mon,$year,$wday,$yday,$isdst) = localtime(time);
	my $alarmOn = Slim::Utils::Prefs::clientGet($client, "alarm", 0) || Slim::Utils::Prefs::clientGet($client, "alarm", $wday);

	if ($alarmOn) {
		$overlay = $client->symbols('bell');
	}
	else {
		$overlay = '';
	}

	if ($scrollType eq 'Ticker' && $killTicker == 0) {
		my $tickerScreen;
		if ($client->display->hasScreen2()) {
			$tickerScreen = 2;
		}
		else {
			$tickerScreen = 1;
		}
		
		my ($complete, $queue) = $client->scrollTickerTimeLeft($tickerScreen);
		if ($nowshowing{$client} == 0) {  #NEED TO ONLY OCCUR IF TICKER MODE
			Slim::Utils::Timers::setTimer($client, Time::HiRes::time() + $timerInterval + $complete, \&nextDisplayItem);
		}
	}
   else {
		#Make sure there are items besides the time showing
		if ((totalGames() + currentWeatherInterval()) >0) {
			#Update display
			if ($scrollType eq 'Basic') {
				$client->update(); #Refresh the display
			}
			else {				
				if ($client->display->hasScreen2()) {
					my $prevHash = $client->curDisplay();
					delete $prevHash->{'screen1'};
					
					my $hash = $client->curLines();
					delete $hash->{'screen1'};
					$client->pushLeft($prevHash, $hash);
				}
				else {
					$client->pushLeft();
				}				
			}
		}

		if ($nowshowing{$client} == 8) { #Weather forecast
			#Need to give time for display lines to be called (+2)
			Slim::Utils::Timers::setTimer($client, Time::HiRes::time() + 2.5, \&setWeatherTimer);
		}
		else {
			Slim::Utils::Timers::setTimer($client, Time::HiRes::time() + $timerInterval, \&nextDisplayItem);
		}
	}

	$killTicker = 0;
}

sub setWeatherTimer {
	#This creates a timer to set the nextDisplayItem timer for a weather forecast.
	#This is necessary because display length is based on how long it takes to scroll...
	my $client = shift;
	my $caller = shift;
	
	my $tickerScreen;
	if ($client->display->hasScreen2()) {
		$tickerScreen = 2;
	}
	else {
		$tickerScreen = 1;
	}	
	my ($complete, $queue) = $client->scrollTickerTimeLeft($tickerScreen);
	
	if ($caller == 1) { #User viewing weather via fast forward/reverse buttons
		Slim::Utils::Timers::setTimer($client, Time::HiRes::time() + $complete + $client->prefGet("scrollPause"), \&nextWeatherItem);	
	}
	elsif ($caller == 2) { #User viewing weather via fast forward/reverse buttons and at last item
		Slim::Utils::Timers::setTimer($client, Time::HiRes::time() + $complete + $client->prefGet("scrollPause"), \&nextDisplayItem);
	}
	else { #Viewing weather forecast via left/right buttons or regular display intervals
		Slim::Utils::Timers::setTimer($client, Time::HiRes::time() + $complete + $client->prefGet("scrollPause"), \&nextDisplayItem);
	}
}

#Used during ticker display mode to set the top display line to the text at halfway point
sub topLineSet {

	my $client = shift;
	my $topLine = shift;
	
	$line1 = $topLine;	
}

sub prevDisplayItem {
	my $client = shift;
	
	my $timerInterval = 0;  #should this be declared elsewhere to save memory creation overhead?
#	$::d_plugins && msg("SuperDateTime: " . "INSIDE PREV DISPLAY ITEM" . "\n");

	if ($nowshowing{$client} == 0) {
		$displayGameID{$client} = 1000;
		$nowshowing{$client} = 8;
		return prevDisplayItem($client);
	}
	elsif ($nowshowing{$client} == 1) {  #MLB
		if(($displayGameID{$client} == 1000) && (($#{$displayItems2[($nowshowing{$client}-1)]}+1) > 0)) { #There are baseball games to show
			$displayGameID{$client} = ($#{$displayItems2[($nowshowing{$client}-1)]}+1); #last MLB game
  			$displayLine1{$client} = $displayItems1[$nowshowing{$client}-1][$displayGameID{$client}-1];
  			$displayLine2{$client} = $displayItems2[$nowshowing{$client}-1][$displayGameID{$client}-1];
  			$timerInterval = $displayIntervals[$nowshowing{$client}-1][$displayGameID{$client}-1];
  		}
  		elsif (($displayGameID{$client} == 1) || ($displayGameID{$client} == 1000)) { #Shall we display the time?
			if (($activeGames == 1) && ($showactivetime == 0)) { #Don't show time when active games
				$nowshowing{$client} = scalar @displayItems2; #Should this be 5 or largest number?
				$displayGameID{$client} = 1000;
				return prevDisplayItem($client);
			}
			elsif ((($activeGames == 0) && ($showtime == 0)) && #Don't show time when no active games
				((totalGames() + scalar @WETdisplayItems2) >0)) #make sure there are some games to show
			{ 
				$nowshowing{$client} = scalar @displayItems2; #Should this be 5 or largest number?
				$displayGameID{$client} = 1000;
				return prevDisplayItem($client);
			}
			else { #Show the time
				$nowshowing{$client} = 0;
				
				if ($activeGames == 0) {
					$timerInterval = $showtime;
				}
				else {
					$timerInterval = $showactivetime;
				}								
			}
		}
  		else {
  			$displayGameID{$client}--;
  		  	$displayLine1{$client} = $displayItems1[$nowshowing{$client}-1][$displayGameID{$client}-1];
		  	$displayLine2{$client} = $displayItems2[$nowshowing{$client}-1][$displayGameID{$client}-1];
  			$timerInterval = $displayIntervals[$nowshowing{$client}-1][$displayGameID{$client}-1];
  		}
	}
	elsif ($nowshowing{$client} < 8) { #Sports & stocks. Need custom code added for single line stocks mode
		if(($displayGameID{$client} == 1000) && (($#{$displayItems2[($nowshowing{$client}-1)]}+1) >0)) { #Are there games
  			$displayGameID{$client} = ($#{$displayItems2[($nowshowing{$client}-1)]}+1); #last game
			$displayLine1{$client} = $displayItems1[$nowshowing{$client}-1][$displayGameID{$client}-1];  			
  			$displayLine2{$client} = $displayItems2[$nowshowing{$client}-1][$displayGameID{$client}-1];
  			$timerInterval = $displayIntervals[$nowshowing{$client}-1][$displayGameID{$client}-1];
  		}
  		elsif (($displayGameID{$client} == 1) || ($displayGameID{$client} == 1000)) {
  			$displayGameID{$client} = 1000;
  			$nowshowing{$client} = $nowshowing{$client}-1;
  			return prevDisplayItem($client);
  		}
  		else {
  			$displayGameID{$client}--;			
		  	$displayLine1{$client} = $displayItems1[$nowshowing{$client}-1][$displayGameID{$client}-1];
		  	$displayLine2{$client} = $displayItems2[$nowshowing{$client}-1][$displayGameID{$client}-1];
  			$timerInterval = $displayIntervals[$nowshowing{$client}-1][$displayGameID{$client}-1];
  		}
	}
	elsif ($nowshowing{$client} == 8) {  #Weather forecasts		
  		if(($displayGameID{$client} == 1000) && (scalar @WETdisplayItems2 >0) && (currentWeatherInterval()>0)) { #Are there weather forecasts
  			$displayGameID{$client} = scalar @WETdisplayItems2; #last weather forecast
  			$displayLine1{$client} = $TOPdisplayItems[$displayGameID{$client}+1];
			$displayLine2{$client} = $WETdisplayItems2[$displayGameID{$client}-1];
  		}
  		elsif (($displayGameID{$client} == 1) || ($displayGameID{$client} == 1000)) {
  			$displayGameID{$client} = 1000;
  			$nowshowing{$client} = $nowshowing{$client}-1;;
  			return prevDisplayItem($client);
  		}
  		else {
  			$displayGameID{$client}--;
  			$displayLine1{$client} = $TOPdisplayItems[$displayGameID{$client}+1];
			$displayLine2{$client} = $WETdisplayItems2[$displayGameID{$client}-1];
  		}
	}	  	

	#Update display
	if ($scrollType eq 'Basic') {
		$client->update(); #Refresh the display
	}
	else {
		if ($client->display->hasScreen2()) {
			my $hash = screensaverSuperDateTimelines($client);
			delete $hash->{'screen1'};
			#my $curHash = $client->curDisplay();
			#delete $curHash->{'screen2'};
			$client->pushRight(undef, $hash);
		}
		else {
			$client->pushRight();
		}
	}

	if ($nowshowing{$client} == 8) { #Weather forecast
		#Need to give time for display lines to be called (+2)
		Slim::Utils::Timers::setTimer($client, Time::HiRes::time() + 2, \&setWeatherTimer);
	}
	else {
		Slim::Utils::Timers::setTimer($client, Time::HiRes::time() + $timerInterval, \&nextDisplayItem);
	}
}

sub killClientTimers {
	my $client = shift;

	Slim::Utils::Timers::killTimers($client, \&nextWeatherItem);
	Slim::Utils::Timers::killTimers($client, \&setWeatherTimer);
	Slim::Utils::Timers::killTimers($client, \&nextDisplayItem);
	Slim::Utils::Timers::killTimers($client, \&topLineSet);
}

#
# Graphic functions
#
sub clearCanvas {
	my $client = shift;

	for( my $xi = 0; $xi < $xmax{$client}; $xi++) {
		for( my $yi = 0; $yi < $ymax{$client}; $yi++) {
			$hashDisp{$client}[$xi][$yi] = 0;
		}
	}
}

sub drawIcon {
	my $client = shift;
	my $xpos = shift;
	my $ypos = shift;
	my $icon = shift;

	#$::d_plugins && Slim::Utils::Misc::msg("SuperDateTime-Icon ($xpos,$ypos): $icon\n");
	if ($xmax{$client} && $ymax{$client}) {
		my $firstline = 1;
		my $xs = $xpos < 0 ? 0 : $xpos;
		my $yi = $ypos > $ymax{$client} ? $ymax{$client} : $ypos;
		for my $line (split('\n',$icon)) {
			# first line must be skipped (empty)
			if ($firstline) {
				$firstline = 0;
				next;
			}
			chomp $line;
			for( my $xi = $xs; $xi < length($line)+$xs && $xi < $xmax{$client} && $yi >= 0; $xi++) {
				if (substr($line,$xi-$xs,1) eq "*") {
					$hashDisp{$client}[$xi][$yi] = 1;
				}
			}
			$yi--;
		}
	}
}

sub drawText {
	my $client = shift;
	my $xpos = shift;
	my $ypos = shift;
	my $text = shift;

	#$::d_plugins && Slim::Utils::Misc::msg("SuperDateTime-Text ($xpos,$ypos): $text\n");
	if ($xmax{$client} && $ymax{$client}) {
		for (my $ci = 0; $ci < length($text); $ci++) {
			my $c = substr($text,$ci,1);
			my $firstline = 1;
			my $xs = $xpos < 0 ? 0 : $xpos + $ci*6;
			my $yi = $ypos > $ymax{$client} ? $ymax{$client} : $ypos;
			for my $line (split('\n',$Charset[$Codepage{$c}])) {
				# first line must be skipped (empty)
				if ($firstline) {
					$firstline = 0;
					next;
				}
				chomp $line;
				for( my $xi = $xs; $xi < length($line)+$xs && $xi < $xmax{$client} && $yi >= 0; $xi++) {
					if (substr($line,$xi-$xs,1) eq "*") {
						$hashDisp{$client}[$xi][$yi] = 1;
					}
				}
				$yi--;
			}
		}
	}
}

# convert %hashDisp into line framebuffer format
sub getFramebuf {
	my $client = shift;
	my $width = shift;
	my $line1 = "";
	
	for( my $x = 0; $x < $width && $x < $xmax{$client}; $x++) {
		my $byte;
		for( my $y = $ymax{$client}; $y > 0; $y -= 8) {
			$byte = ($hashDisp{$client}[$x][$y-1] << 7)
			      + ($hashDisp{$client}[$x][$y-2] << 6)
			      + ($hashDisp{$client}[$x][$y-3] << 5)
			      + ($hashDisp{$client}[$x][$y-4] << 4)
			      + ($hashDisp{$client}[$x][$y-5] << 3)
			      + ($hashDisp{$client}[$x][$y-6] << 2)
			      + ($hashDisp{$client}[$x][$y-7] << 1)
			      +  $hashDisp{$client}[$x][$y-8];
			$line1 .= pack("C", $byte);
		}
	}
	return $line1;
}

sub screensaverSuperDateTimelines {
	my $client = shift;

#		my $nextUpdate = $client->periodicUpdateTime();
#		Slim::Buttons::Common::syncPeriodicUpdates($client, int($nextUpdate)) if (($nextUpdate - int($nextUpdate)) > 0.01);

	my $lastTicker = 0; #Flag set to indicate showing last ticker item
	my $hash;

	if ($nowshowing{$client} == 0) { #Show time and temperature	
		my $time = Slim::Utils::DateTime::timeF(undef,Slim::Utils::Prefs::get('timeFormat'));
		$displayLine2{$client} = $weatherString1b;
		$displayLine2{$client} =~ s/%1/$time/;
		
		if ($topNowShowing{$client} == 0 && $client->textSize() == 2) { #Large font showing time
			$displayLine2{$client} = $btmLinePreSpace[$largeFontTimeIcon]. $displayLine2{$client};
		}
		else {
			$displayLine2{$client} = $btmLinePreSpace[$topNowShowing{$client}]. $displayLine2{$client};
		}
		
		if (defined($TOPdisplayItems[$topNowShowing{$client}])) { #Show next forecast
			$displayLine1{$client} = $TOPdisplayItems[$topNowShowing{$client}];
		}
		else { #Show the date
			#$displayLine1{$client} = Slim::Utils::Misc::longDateF();
			$displayLine1{$client} = Slim::Utils::DateTime::longDateF(undef,Slim::Utils::Prefs::get('dateFormat'))
		}
	}


	if ($scrollType eq 'Ticker' && $killTicker !=3) {
		my $tickerScreen;
		if ($client->display->hasScreen2()) {
			$tickerScreen = 2;
		}
		else {
			$tickerScreen = 1;
		}		
		my ($complete, $queue) = $client->scrollTickerTimeLeft($tickerScreen);
		#$::d_plugins && msg("SuperDateTime: $complete $queue " . $nowshowing{$client} . ' '. $displayLine1{$client} ."\n");
		#Slim::Utils::Timers::listTimers();
		if ($nowshowing{$client} == 0) { #Time
			if ($topNowShowing{$client} != 0 && $client->textSize() == 2) {
			#User is in large text mode and has chosen to look at some of the time line 1 text.
			#In this unique circumstance the plugin will continue to display that info until the user chooses to display the time again.
			#This is by design, otherwise code would get very ugly to handle scrolling ticker and top line text...
				killClientTimers($client); #Kill the timers otherwise it may think it's in the wrong state
				#Timers will get reactivated once the user chooses to show the time again.
					$hash = {
						'overlay' => [$overlay . $status, undef],
						'center'  => [$displayLine1{$client}, undef],
						'line'    => [undef , $displayLine1{$client}],
					};
			}		
			elsif ($complete == 0 || $killTicker == 1) { #Show the time
				$killTicker = 0; #Reset kill ticker in case it's toggeled
				if ($client->textSize() != 2) { #Not large text
					#$::d_plugins && msg("SuperDateTime: *A* ". $nowshowing{$client} ." Show Time\n");
					$hash = {
						'overlay' => [$overlay . $status, undef],
						'center'  => [$displayLine1{$client}, $displayLine2{$client}],
					};
				}
				elsif ($topNowShowing{$client} == 0) { #Large text and showing time
					$hash = {
						'overlay' => [$overlay . $status, undef],
						'center'  => [undef, $displayLine2{$client}],
					};				
				}
				else { #Large text, show top line of time display
					$hash = {
						'overlay' => [$overlay . $status, undef],
						'center'  => [$displayLine1{$client}, undef],
					};				
				}
			}
			else { #Last ticker item still displaying
				$lastTicker = 1;
				#$::d_plugins && msg("SuperDateTime: *C* ". $nowshowing{$client} ." Last Ticker Still Displaying\n");
				$hash = {
					'overlay'  => [ $overlay . $status, undef],
					'center'   => [ $line1, undef ],
					'ticker'   => [ undef, undef ],
				};
			}
		}	
		elsif ($queue <1 && $complete >0) { #Queue empty, item is still showing
			nextDisplayItem($client);
			if ($nowshowing{$client} != 0) { #Add item to ticker
				#$::d_plugins && msg("SuperDateTime: *B* ". $nowshowing{$client} ." Add item to ticker\n");
				my $tickerScreen;
				if ($client->display->hasScreen2()) {
					$tickerScreen = 2;
				}
				else {
					$tickerScreen = 1;
				}		
				#my ($complete, $queue) = $client->scrollTickerTimeLeft($tickerScreen);
	
				Slim::Utils::Timers::setTimer($client, Time::HiRes::time() + ($complete*.5), \&topLineSet, $displayLine1{$client});	
						
				$hash = { 
					'overlay' => [ $overlay . $status, undef ],
					'center'  => [ $line1, undef ],
					'ticker'  => [ undef, $displayLine2{$client} ],
				};
			}
			else { #Last ticker item about to show time
				#$::d_plugins && msg("SuperDateTime: *D* ". $nowshowing{$client} ." Last ticker item about to show time.\n");
				$lastTicker = 1;
				$hash = {
					'overlay' => [ $overlay . $status, undef ],
					'center'  => [ $line1, undef ],
					'ticker'  => [ undef, undef ],
				};		
			}
		}
		elsif ($complete > 0) { #Showing a ticker item
			#$::d_plugins && msg("SuperDateTime: *E* ". $nowshowing{$client} ." Showing a ticker item.\n");
			$hash = {
				'overlay' => [ $overlay . $status, undef ],
				'center'  => [$line1, undef ],
				'ticker'  => [ undef, undef ],
			};
		}
		else {  #Add first ticker item
			#$::d_plugins && msg("SuperDateTime: *F* ". $nowshowing{$client} ." Add first item to ticker.\n");
			$line1 = $displayLine1{$client};
				$hash = {
					'overlay' => [ $overlay . $status, undef ],
					'center'  => [ $line1, undef ],
					'ticker'  => [ undef, $displayLine2{$client} ],
				};
		}
	}
	else {  #BASIC OR SLIDE
		if ($client->textSize() != 2) { #Not large text
			if ($nowshowing{$client} == 0 && defined($btmLinePreSpace[$topNowShowing{$client}])) { #Time with special spacing				
			#$::d_plugins && msg("SuperDateTime: ***\n");
			$hash = {
					'overlay' => [ $overlay . $status, undef ],
					'center'  => [ $displayLine1{$client}, undef ],
					'line'    => [ undef, $displayLine2{$client} ],						    
				};
			}
			elsif ($nowshowing{$client} == 0) { #Time without special spacing
				$hash = {
					'overlay' => [ $overlay . $status, undef ],
					'center'  => [ $displayLine1{$client}, $displayLine2{$client} ],						    
				};
			}			
			elsif ($nowshowing{$client} == 8) { #Weather with scrolling
				$hash = {
					'overlay' => [ $overlay . $status ],
					'center'  => [ $displayLine1{$client} ],
					'line'    => [ undef, $displayLine2{$client} ],
				};
			}
			else {
				$hash = {  #Game
					'overlay' => [ $overlay . $status, undef ],
					'center'  => [ $displayLine1{$client}, $displayLine2{$client} ],
				};
			} 
	   } #End of not large text
	   else { #Large text
	   	if ($nowshowing{$client} == 0) { #Time
	   		if ($topNowShowing{$client} == 0) { #Show the actual time
					$hash = {
						'overlay' => [ $overlay . $status, undef ],
						'center'  => [ undef,$displayLine2{$client}],
					};
				}
				else { #Show the top line of the time display
					$hash = {
						'overlay' => [ $overlay . $status, undef ],
						'line'  => [ undef,$btmLinePreSpace[$topNowShowing{$client}].$displayLine1{$client}],
					};				
				}
			}
			else { #Sport scores/stocks in large text
				$hash = {
					'overlay' => [ $overlay . $status, undef ],
					'line'    => [ undef,$displayLine2{$client}],
				};
			}
	   }
	}
	
	my $dispHash;
	if ($client->display->hasScreen2()) { #Dual screens
		my $time = Slim::Utils::DateTime::timeF(undef,Slim::Utils::Prefs::get('timeFormat'));
		my $line1;
		my $line2 = $weatherString1b;
		$line2 =~ s/%1/$time/; #Add the time if its included
		
		if (defined($TOPdisplayItems[$topNowShowing{$client}])) { #Show next forecast
			$line1 = $TOPdisplayItems[$topNowShowing{$client}];
		}
		else { #Show the date
			#$line1 = Slim::Utils::Misc::longDateF();
			$line1 = Slim::Utils::DateTime::longDateF(undef,Slim::Utils::Prefs::get('dateFormat'))
		}

		my $timeHash;
		if (defined($btmLinePreSpace[$topNowShowing{$client}])) { #Time with special spacing				
			$timeHash = {
				'center' => [ $line1, undef ],
				'line'   => [ undef, $btmLinePreSpace[$topNowShowing{$client}].$line2 ],
			};
		}
		else {
			$timeHash = {
				'center'  => [ $line1, $line2 ],
			};		
		}

		if ($nowshowing{$client} != 0) { #Not time
			$dispHash->{'screen2'} = $hash;
		}
		else {
			my $line2 = $weatherString2b;
			$line2 =~ s/%1/$time/; #Add the time if its included
		
			my $screen2 = {
					'overlay' => [ $overlay . $status, undef ],
					'center'  => [ $weatherString2t, $line2 ],
			};
			$dispHash->{'screen2'} = $screen2;
		}
		
		if ($showGraphics && $xmax{$client} && $ymax{$client}) {
			$timeHash->{'bits'} = $forecastG[$topNowShowing{$client}];
		}
		$dispHash->{'screen1'} = $timeHash;
	}
	else { #Single screen
		$hash->{'fonts'} = { 'graphic-280x16'  => { 'overlay' => [ 'small.1' ]},
								   'graphic-320x32'  => { 'overlay' => [ 'standard.1' ]},
								   'text' =>            { 'displayoverlays' => 1 },
								 };

		if ($showGraphics && $xmax{$client} && $ymax{$client} && $nowshowing{$client} == 0 && $lastTicker == 0) {
			if ($topNowShowing{$client} == 0 && $client->textSize() == 2) { #Large text showing time
				$hash->{'bits'} = $forecastG[$largeFontTimeIcon]; #Change $largeFontTimeIcon to what you want to see when showing time in large text
			}
			else {
				$hash->{'bits'} = $forecastG[$topNowShowing{$client}];
			}
		}
		$dispHash->{'screen1'} = $hash;
	}
	
	return $dispHash;		
}

1;

__END__

# Local Variables:
# tab-width:4
# indent-tabs-mode:t
# End:
